/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.databinding.DataBindingMode;
import com.android.tools.idea.databinding.DataBindingProjectComponent;
import com.android.tools.idea.databinding.LightBindingClass;
import com.android.tools.idea.databinding.LightBrClass;
import com.android.tools.idea.databinding.ModuleDataBinding;
import com.android.tools.idea.databinding.config.DataBindingConfiguration;
import com.android.tools.idea.lang.databinding.DbFile;
import com.android.tools.idea.lang.databinding.psi.DbTokenTypes;
import com.android.tools.idea.lang.databinding.psi.PsiDbConstantValue;
import com.android.tools.idea.lang.databinding.psi.PsiDbDefaults;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.PsiDataBindingResourceItem;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.collect.ImmutableList;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.FileContentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.dom.layout.Import;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingUtil {
    static Logger LOG = Logger.getInstance((String)"databinding");
    public static final String BR = "BR";
    private static AtomicLong ourDataBindingEnabledModificationCount = new AtomicLong(0L);
    private static AtomicBoolean ourCreateInMemoryClasses = new AtomicBoolean(false);
    private static List<String> VIEW_PACKAGE_ELEMENTS = ImmutableList.of((Object)"View", (Object)"ViewGroup", (Object)"TextureView", (Object)"SurfaceView");
    private static AtomicBoolean ourReadInMemoryClassGenerationSettings = new AtomicBoolean(false);
    public static ModificationTracker DATA_BINDING_ENABLED_TRACKER = () -> ourDataBindingEnabledModificationCount.longValue();

    private static void invalidateJavaCodeOnOpenDataBindingProjects() {
        ourDataBindingEnabledModificationCount.incrementAndGet();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            DataBindingProjectComponent component = (DataBindingProjectComponent)project.getComponent(DataBindingProjectComponent.class);
            if (component == null) continue;
            boolean invalidated = DataBindingUtil.invalidateAllSources(component);
            if (!invalidated) {
                return;
            }
            PsiModificationTracker tracker = PsiManager.getInstance((Project)project).getModificationTracker();
            if (tracker instanceof PsiModificationTrackerImpl) {
                ((PsiModificationTrackerImpl)tracker).incCounter();
            }
            FileContentUtil.reparseFiles((Project)project, Collections.emptyList(), (boolean)true);
        }
        ourDataBindingEnabledModificationCount.incrementAndGet();
    }

    public static boolean invalidateAllSources(DataBindingProjectComponent component) {
        boolean invalidated = false;
        for (AndroidFacet facet : component.getDataBindingEnabledFacets()) {
            LocalResourceRepository moduleResources = ResourceRepositoryManager.getModuleResources(facet);
            Map<String, DataBindingInfo> dataBindingResourceFiles = moduleResources.getDataBindingResourceFiles();
            if (dataBindingResourceFiles == null) continue;
            for (DataBindingInfo info : dataBindingResourceFiles.values()) {
                PsiFile containingFile;
                PsiClass psiClass = info.getPsiClass();
                if (psiClass == null || (containingFile = psiClass.getContainingFile()) == null) continue;
                containingFile.subtreeChanged();
                invalidated = true;
            }
        }
        return invalidated;
    }

    public static boolean inMemoryClassGenerationIsEnabled() {
        if (!ourReadInMemoryClassGenerationSettings.getAndSet(true)) {
            ourCreateInMemoryClasses.set(DataBindingUtil.calculateEnableInMemoryClasses());
        }
        return ourCreateInMemoryClasses.get();
    }

    public static void recalculateEnableInMemoryClassGeneration() {
        boolean oldValue;
        boolean newValue = DataBindingUtil.calculateEnableInMemoryClasses();
        if (newValue != (oldValue = ourCreateInMemoryClasses.getAndSet(newValue))) {
            LOG.debug("Data binding in memory completion value change. (old, new)", new Object[]{oldValue, newValue});
            ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(DataBindingUtil::invalidateJavaCodeOnOpenDataBindingProjects));
        }
    }

    private static boolean calculateEnableInMemoryClasses() {
        DataBindingConfiguration config = DataBindingConfiguration.getInstance();
        return config.CODE_NAVIGATION_MODE == DataBindingConfiguration.CodeNavigationMode.XML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LightBrClass getOrCreateBrClassFor(AndroidFacet facet) {
        ModuleDataBinding dataBinding = ModuleDataBinding.getInstance(facet);
        LightBrClass existing2 = dataBinding.getLightBrClass();
        if (existing2 == null) {
            AndroidFacet androidFacet = facet;
            synchronized (androidFacet) {
                existing2 = dataBinding.getLightBrClass();
                if (existing2 == null) {
                    existing2 = new LightBrClass(PsiManager.getInstance((Project)facet.getModule().getProject()), facet);
                    dataBinding.setLightBrClass(existing2);
                }
            }
        }
        return existing2;
    }

    @Nullable
    static PsiType parsePsiType(@NotNull String text, @NotNull AndroidFacet facet, @Nullable PsiElement context) {
        if (text == null) {
            DataBindingUtil.$$$reportNull$$$0(0);
        }
        if (facet == null) {
            DataBindingUtil.$$$reportNull$$$0(1);
        }
        PsiElementFactory instance = PsiElementFactory.getInstance((Project)facet.getModule().getProject());
        try {
            PsiType type = instance.createTypeFromText(text, context);
            if (type instanceof PsiClassReferenceType && ((PsiClassReferenceType)type).getClassName() == null) {
                return null;
            }
            return type;
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    public static PsiType resolveViewPsiType(DataBindingInfo.ViewWithId viewWithId, AndroidFacet facet) {
        String viewClassName = DataBindingUtil.getViewClassName(viewWithId.tag, facet);
        if (StringUtil.isNotEmpty((String)viewClassName)) {
            return DataBindingUtil.parsePsiType(viewClassName, facet, null);
        }
        return null;
    }

    @Nullable
    private static String getViewClassName(XmlTag tag, AndroidFacet facet) {
        String elementName = DataBindingUtil.getViewName(tag);
        if (elementName != null && elementName.indexOf(46) == -1) {
            if (VIEW_PACKAGE_ELEMENTS.contains(elementName)) {
                return "android.view." + elementName;
            }
            if ("WebView".equals(elementName)) {
                return "android.webkit." + elementName;
            }
            if ("merge".equals(elementName)) {
                return DataBindingUtil.getViewClassNameFromMerge(tag, facet);
            }
            if ("include".equals(elementName)) {
                return DataBindingUtil.getViewClassNameFromInclude(tag, facet);
            }
            if ("ViewStub".equals(elementName)) {
                DataBindingMode mode = ModuleDataBinding.getInstance(facet).getDataBindingMode();
                return mode.viewStubProxy;
            }
            return "android.widget." + elementName;
        }
        return elementName;
    }

    private static String getViewClassNameFromInclude(XmlTag tag, AndroidFacet facet) {
        String reference2 = DataBindingUtil.getViewClassNameFromLayoutReferenceTag(tag, facet);
        return reference2 == null ? "android.view.View" : reference2;
    }

    private static String getViewClassNameFromMerge(XmlTag tag, AndroidFacet facet) {
        return DataBindingUtil.getViewClassNameFromLayoutReferenceTag(tag, facet);
    }

    private static String getViewClassNameFromLayoutReferenceTag(XmlTag tag, AndroidFacet facet) {
        String layout2 = tag.getAttributeValue("layout");
        if (layout2 == null) {
            return null;
        }
        LocalResourceRepository moduleResources = ResourceRepositoryManager.getOrCreateInstance(facet).getModuleResources(false);
        if (moduleResources == null) {
            return null;
        }
        ResourceUrl resourceUrl = ResourceUrl.parse((String)layout2);
        if (resourceUrl == null || resourceUrl.type != ResourceType.LAYOUT) {
            return null;
        }
        DataBindingInfo info = moduleResources.getDataBindingInfoForLayout(resourceUrl.name);
        if (info == null) {
            return null;
        }
        return info.getQualifiedName();
    }

    @Nullable
    private static String getViewName(XmlTag tag) {
        String viewName = tag.getName();
        if ("view".equals(viewName)) {
            viewName = tag.getAttributeValue("class", "http://schemas.android.com/apk/res/android");
        }
        return viewName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PsiClass getOrCreatePsiClass(DataBindingInfo info) {
        PsiClass psiClass = info.getPsiClass();
        if (psiClass == null) {
            DataBindingInfo dataBindingInfo = info;
            synchronized (dataBindingInfo) {
                psiClass = info.getPsiClass();
                if (psiClass == null) {
                    psiClass = new LightBindingClass(info.getFacet(), PsiManager.getInstance((Project)info.getProject()), info);
                    info.setPsiClass(psiClass);
                }
            }
        }
        return psiClass;
    }

    public static String convertToJavaClassName(String name) {
        int dotIndex = name.indexOf(46);
        if (dotIndex >= 0) {
            name = name.substring(0, dotIndex);
        }
        String[] split = name.split("[_-]");
        StringBuilder out = new StringBuilder();
        for (String section : split) {
            out.append(StringUtil.capitalize((String)section));
        }
        return out.toString();
    }

    public static String convertToJavaFieldName(String name) {
        int dotIndex = name.indexOf(46);
        if (dotIndex >= 0) {
            name = name.substring(0, dotIndex);
        }
        String[] split = name.split("[_-]");
        StringBuilder out = new StringBuilder();
        boolean first = true;
        for (String section : split) {
            if (first) {
                first = false;
                out.append(section);
                continue;
            }
            out.append(StringUtil.capitalize((String)section));
        }
        return out.toString();
    }

    public static String getBrQualifiedName(AndroidFacet facet) {
        return DataBindingUtil.getGeneratedPackageName(facet) + "." + BR;
    }

    public static String getGeneratedPackageName(AndroidFacet facet) {
        return MergedManifest.get(facet).getPackage();
    }

    public static void incrementModificationCount() {
        ourDataBindingEnabledModificationCount.incrementAndGet();
    }

    @Nullable
    public static String getBindingExprDefault(@NotNull XmlAttribute psiAttribute) {
        XmlAttributeValue attrValue;
        if (psiAttribute == null) {
            DataBindingUtil.$$$reportNull$$$0(2);
        }
        if ((attrValue = psiAttribute.getValueElement()) instanceof PsiLanguageInjectionHost) {
            PsiDbDefaults defaults;
            Ref injections = Ref.create();
            InjectedLanguageManager.getInstance((Project)psiAttribute.getProject()).enumerate((PsiElement)attrValue, (injectedPsi, places) -> {
                if (injectedPsi instanceof DbFile) {
                    injections.set((Object)injectedPsi);
                }
            });
            if (injections.get() != null && (defaults = (PsiDbDefaults)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)injections.get()), PsiDbDefaults.class)) != null) {
                PsiDbConstantValue constantValue = defaults.getConstantValue();
                ASTNode stringLiteral = constantValue.getNode().findChildByType(DbTokenTypes.STRING_LITERAL);
                if (stringLiteral == null) {
                    return constantValue.getText();
                }
                String text = stringLiteral.getText();
                if (text.length() > 1) {
                    return text.substring(1, text.length() - 1);
                }
                return text;
            }
        }
        return null;
    }

    @Nullable
    public static String getBindingExprDefault(@NotNull String exprn) {
        if (exprn == null) {
            DataBindingUtil.$$$reportNull$$$0(3);
        }
        if (!exprn.contains(DbTokenTypes.DEFAULT_KEYWORD.toString())) {
            return null;
        }
        Pattern defaultCheck = Pattern.compile(",\\s*default\\s*=\\s*");
        int index = 0;
        Matcher matcher = defaultCheck.matcher(exprn);
        while (matcher.find()) {
            index = matcher.end();
        }
        String def = exprn.substring(index, exprn.length() - 1).trim();
        if (def.startsWith("\"") && def.endsWith("\"")) {
            def = def.substring(1, def.length() - 1);
        }
        return def;
    }

    public static boolean isBindingExpression(@NotNull String string) {
        if (string == null) {
            DataBindingUtil.$$$reportNull$$$0(4);
        }
        return string.startsWith("@{") || string.startsWith("@={");
    }

    @Nullable
    public static String getAlias(@NotNull Import anImport) {
        XmlAttributeValue value2;
        GenericAttributeValue<PsiElement> type;
        if (anImport == null) {
            DataBindingUtil.$$$reportNull$$$0(5);
        }
        String aliasValue = null;
        String typeValue = null;
        GenericAttributeValue<String> alias = anImport.getAlias();
        if (alias != null && alias.getXmlAttributeValue() != null) {
            aliasValue = alias.getXmlAttributeValue().getValue();
        }
        if ((type = anImport.getType()) != null && (value2 = type.getXmlAttributeValue()) != null) {
            typeValue = value2.getValue();
        }
        return DataBindingUtil.getAlias(typeValue, aliasValue);
    }

    @Nullable
    public static String getAlias(@NotNull PsiDataBindingResourceItem anImport) {
        if (anImport == null) {
            DataBindingUtil.$$$reportNull$$$0(6);
        }
        return DataBindingUtil.getAlias(anImport.getTypeDeclaration(), anImport.getExtra("alias"));
    }

    private static String getAlias(@Nullable String type, @Nullable String alias) {
        int d;
        if (alias != null || type == null) {
            return alias;
        }
        int i2 = type.lastIndexOf(46);
        int n = i2 = i2 > (d = type.lastIndexOf(36)) ? i2 : d;
        if (i2 < 0) {
            return type;
        }
        return type.length() > i2 + 1 ? type.substring(i2 + 1) : null;
    }

    @Nullable
    public static String getQualifiedType(final @Nullable String nameOrAlias, final @Nullable DataBindingInfo dataBindingInfo, final boolean qualifyJavaLang) {
        class UnresolvedClassNameException
        extends RuntimeException {
            UnresolvedClassNameException() {
            }
        }
        PsiType psiType;
        if (nameOrAlias == null || dataBindingInfo == null) {
            return nameOrAlias;
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)dataBindingInfo.getProject());
        final PsiJavaParserFacade parser = psiFacade.getParserFacade();
        try {
            psiType = parser.createTypeFromText(nameOrAlias, null);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
        if (psiType instanceof PsiPrimitiveType) {
            return nameOrAlias;
        }
        final StringBuilder result2 = new StringBuilder();
        final int[] offset = new int[1];
        try {
            psiType.accept((PsiTypeVisitor)new ClassReferenceVisitor(){

                @Override
                public void visitClassReference(@NotNull PsiClassReferenceType classReference) {
                    String className;
                    if (classReference == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    PsiJavaCodeReferenceElement reference2 = classReference.getReference();
                    int nameOffset = reference2.getTextRange().getStartOffset();
                    while (offset[0] < nameOffset) {
                        int n = offset[0];
                        offset[0] = n + 1;
                        result2.append(nameOrAlias.charAt(n));
                    }
                    String string = className = reference2.isQualified() ? reference2.getQualifiedName() : reference2.getReferenceName();
                    if (className != null) {
                        int nameLength = className.length();
                        className = DataBindingUtil.resolveImport(className, dataBindingInfo);
                        if (qualifyJavaLang && className.indexOf(46) < 0 && (className = DataBindingUtil.qualifyClassName(className, parser)) == null) {
                            throw new UnresolvedClassNameException();
                        }
                        result2.append(className);
                        offset[0] = offset[0] + nameLength;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classReference", "com/android/tools/idea/databinding/DataBindingUtil$1", "visitClassReference"));
                }
            });
        }
        catch (UnresolvedClassNameException e) {
            return null;
        }
        while (offset[0] < nameOrAlias.length()) {
            int n = offset[0];
            offset[0] = n + 1;
            result2.append(nameOrAlias.charAt(n));
        }
        return result2.toString();
    }

    @Nullable
    private static String qualifyClassName(@NotNull String className, @NotNull PsiJavaParserFacade parser) {
        PsiType psiType;
        if (className == null) {
            DataBindingUtil.$$$reportNull$$$0(7);
        }
        if (parser == null) {
            DataBindingUtil.$$$reportNull$$$0(8);
        }
        if ((psiType = parser.createTypeFromText(className, null)) instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            if (psiClass == null) {
                return null;
            }
            String name = psiClass.getQualifiedName();
            if (name != null) {
                return name;
            }
        }
        return className;
    }

    @NotNull
    public static String resolveImport(@NotNull String className, @Nullable DataBindingInfo dataBindingInfo) {
        int dotOffset;
        String firstSegment;
        String importedType;
        if (className == null) {
            DataBindingUtil.$$$reportNull$$$0(9);
        }
        if (dataBindingInfo != null && (importedType = dataBindingInfo.resolveImport(firstSegment = (dotOffset = className.indexOf(46)) >= 0 ? className.substring(0, dotOffset) : className)) != null) {
            String string = dotOffset >= 0 ? importedType + className.substring(dotOffset) : importedType;
            if (string == null) {
                DataBindingUtil.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = className;
        if (string == null) {
            DataBindingUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAttribute";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exprn";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anImport";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/databinding/DataBindingUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/databinding/DataBindingUtil";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveImport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parsePsiType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBindingExprDefault";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isBindingExpression";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAlias";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "qualifyClassName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveImport";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class ClassReferenceVisitor
    extends PsiTypeVisitor<Void> {
        @Nullable
        public final Void visitClassType(@NotNull PsiClassType classType) {
            PsiType[] parameters;
            if (classType == null) {
                ClassReferenceVisitor.$$$reportNull$$$0(0);
            }
            if (classType instanceof PsiClassReferenceType) {
                this.visitClassReference((PsiClassReferenceType)classType);
            }
            for (PsiType parameter : parameters = classType.getParameters()) {
                parameter.accept((PsiTypeVisitor)this);
            }
            return null;
        }

        @Nullable
        public final Void visitArrayType(@NotNull PsiArrayType arrayType) {
            if (arrayType == null) {
                ClassReferenceVisitor.$$$reportNull$$$0(1);
            }
            PsiType type = arrayType.getComponentType();
            type.accept((PsiTypeVisitor)this);
            return null;
        }

        public abstract void visitClassReference(@NotNull PsiClassReferenceType var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayType";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/databinding/DataBindingUtil$ClassReferenceVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClassType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitArrayType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

