/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.tools.idea.databinding.DataBindingProjectComponent;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.databinding.ProjectResourceCachedValueProvider;
import com.android.tools.idea.databinding.ResourceCacheValueProvider;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DataBindingShortNamesCache
extends PsiShortNamesCache {
    private final DataBindingProjectComponent myComponent;
    private final CachedValue<Map<String, List<DataBindingInfo>>> myNameCache;
    private final CachedValue<String[]> myAllClassNamesCache;
    private final CachedValue<Map<String, List<PsiMethod>>> myMethodsByNameCache;
    private final CachedValue<Map<String, List<PsiField>>> myFieldsByNameCache;
    private final CachedValue<String[]> myAllMethodNamesCache;
    private final CachedValue<String[]> myAllFieldNamesCache;

    public DataBindingShortNamesCache(@NotNull Project project) {
        if (project == null) {
            DataBindingShortNamesCache.$$$reportNull$$$0(0);
        }
        this.myComponent = (DataBindingProjectComponent)project.getComponent(DataBindingProjectComponent.class);
        NameCacheProvider nameCacheProvider = new NameCacheProvider(this.myComponent);
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)project);
        this.myNameCache = cachedValuesManager.createCachedValue((CachedValueProvider)nameCacheProvider, false);
        this.myAllClassNamesCache = cachedValuesManager.createCachedValue(() -> CachedValueProvider.Result.create((Object)ArrayUtilRt.toStringArray(((Map)this.myNameCache.getValue()).keySet()), (Object[])new Object[]{nameCacheProvider}), false);
        this.myMethodsByNameCache = cachedValuesManager.createCachedValue(() -> {
            HashMap result2 = Maps.newHashMap();
            this.traverseAllClasses((Function<PsiClass, Void>)((Function)psiClass -> {
                for (PsiMethod method : psiClass.getMethods()) {
                    List psiMethods = (List)result2.get(method.getName());
                    if (psiMethods == null) {
                        psiMethods = Lists.newArrayList();
                        result2.put(method.getName(), psiMethods);
                    }
                    psiMethods.add(method);
                }
                return null;
            }));
            return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{nameCacheProvider});
        }, false);
        this.myFieldsByNameCache = cachedValuesManager.createCachedValue(() -> {
            HashMap result2 = Maps.newHashMap();
            this.traverseAllClasses((Function<PsiClass, Void>)((Function)psiClass -> {
                for (PsiField field2 : psiClass.getFields()) {
                    List psiFields = (List)result2.get(field2.getName());
                    if (psiFields == null) {
                        psiFields = Lists.newArrayList();
                        result2.put(field2.getName(), psiFields);
                    }
                    psiFields.add(field2);
                }
                return null;
            }));
            return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{nameCacheProvider});
        }, false);
        this.myAllMethodNamesCache = cachedValuesManager.createCachedValue(() -> {
            Set names = ((Map)this.myMethodsByNameCache.getValue()).keySet();
            return CachedValueProvider.Result.create((Object)ArrayUtilRt.toStringArray(names), (Object[])new Object[]{nameCacheProvider});
        }, false);
        this.myAllFieldNamesCache = cachedValuesManager.createCachedValue(() -> {
            Set names = ((Map)this.myFieldsByNameCache.getValue()).keySet();
            return CachedValueProvider.Result.create((Object)ArrayUtilRt.toStringArray(names), (Object[])new Object[]{nameCacheProvider});
        }, false);
    }

    private void traverseAllClasses(Function<PsiClass, Void> receiver) {
        for (List infoList : ((Map)this.myNameCache.getValue()).values()) {
            for (DataBindingInfo info : infoList) {
                PsiClass psiClass = DataBindingUtil.getOrCreatePsiClass(info);
                receiver.fun((Object)psiClass);
            }
        }
    }

    @NotNull
    public PsiClass[] getClassesByName(@NotNull @NonNls String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            DataBindingShortNamesCache.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            DataBindingShortNamesCache.$$$reportNull$$$0(2);
        }
        if (!this.isEnabled()) {
            if (PsiClass.EMPTY_ARRAY == null) {
                DataBindingShortNamesCache.$$$reportNull$$$0(3);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        List infoList = (List)((Map)this.myNameCache.getValue()).get(name);
        if (infoList == null || infoList.isEmpty()) {
            if (PsiClass.EMPTY_ARRAY == null) {
                DataBindingShortNamesCache.$$$reportNull$$$0(4);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList selected = Lists.newArrayList();
        for (DataBindingInfo info : infoList) {
            if (!scope.accept(info.getPsiFile().getVirtualFile())) continue;
            selected.add(DataBindingUtil.getOrCreatePsiClass(info));
        }
        if (selected.isEmpty()) {
            if (PsiClass.EMPTY_ARRAY == null) {
                DataBindingShortNamesCache.$$$reportNull$$$0(5);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass[] psiClassArray = selected.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            DataBindingShortNamesCache.$$$reportNull$$$0(6);
        }
        return psiClassArray;
    }

    @NotNull
    public String[] getAllClassNames() {
        if (!this.isEnabled()) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                DataBindingShortNamesCache.$$$reportNull$$$0(7);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = (String[])this.myAllClassNamesCache.getValue();
        if (stringArray == null) {
            DataBindingShortNamesCache.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    public void getAllClassNames(@NotNull HashSet<String> dest) {
        if (dest == null) {
            DataBindingShortNamesCache.$$$reportNull$$$0(9);
        }
        if (!this.isEnabled()) {
            return;
        }
        Collections.addAll(dest, this.getAllClassNames());
    }

    @NotNull
    public PsiMethod[] getMethodsByName(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            DataBindingShortNamesCache.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            DataBindingShortNamesCache.$$$reportNull$$$0(11);
        }
        if (!this.isEnabled()) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                DataBindingShortNamesCache.$$$reportNull$$$0(12);
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        List methods = (List)((Map)this.myMethodsByNameCache.getValue()).get(name);
        PsiMethod[] psiMethodArray = (PsiMethod[])DataBindingShortNamesCache.filterByScope((List)methods, (GlobalSearchScope)scope, PsiMethod.class, (PsiElement[])PsiMethod.EMPTY_ARRAY);
        if (psiMethodArray == null) {
            DataBindingShortNamesCache.$$$reportNull$$$0(13);
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] getMethodsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name == null) {
            DataBindingShortNamesCache.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            DataBindingShortNamesCache.$$$reportNull$$$0(15);
        }
        if (!this.isEnabled()) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                DataBindingShortNamesCache.$$$reportNull$$$0(16);
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] methods = this.getMethodsByName(name, scope);
        if (methods.length > maxCount) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                DataBindingShortNamesCache.$$$reportNull$$$0(17);
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        if (methods == null) {
            DataBindingShortNamesCache.$$$reportNull$$$0(18);
        }
        return methods;
    }

    @NotNull
    public PsiField[] getFieldsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name == null) {
            DataBindingShortNamesCache.$$$reportNull$$$0(19);
        }
        if (scope == null) {
            DataBindingShortNamesCache.$$$reportNull$$$0(20);
        }
        if (!this.isEnabled()) {
            if (PsiField.EMPTY_ARRAY == null) {
                DataBindingShortNamesCache.$$$reportNull$$$0(21);
            }
            return PsiField.EMPTY_ARRAY;
        }
        List psiFields = (List)((Map)this.myFieldsByNameCache.getValue()).get(name);
        PsiField[] selected = (PsiField[])DataBindingShortNamesCache.filterByScope((List)psiFields, (GlobalSearchScope)scope, PsiField.class, (PsiElement[])PsiField.EMPTY_ARRAY);
        if (selected.length > maxCount) {
            if (PsiField.EMPTY_ARRAY == null) {
                DataBindingShortNamesCache.$$$reportNull$$$0(22);
            }
            return PsiField.EMPTY_ARRAY;
        }
        if (selected == null) {
            DataBindingShortNamesCache.$$$reportNull$$$0(23);
        }
        return selected;
    }

    private static <T extends PsiElement> T[] filterByScope(List<T> items2, @NotNull GlobalSearchScope scope, Class<T> klass, T[] defaultValue) {
        if (scope == null) {
            DataBindingShortNamesCache.$$$reportNull$$$0(24);
        }
        if (items2 == null || items2.isEmpty()) {
            return defaultValue;
        }
        ArrayList selected = Lists.newArrayList();
        for (PsiElement item : items2) {
            if (item.getContainingFile() == null || !scope.accept(item.getContainingFile().getVirtualFile())) continue;
            selected.add(item);
        }
        return selected.toArray((PsiElement[])Array.newInstance(klass, selected.size()));
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiMethod> processor) {
        if (name == null) {
            DataBindingShortNamesCache.$$$reportNull$$$0(25);
        }
        if (scope == null) {
            DataBindingShortNamesCache.$$$reportNull$$$0(26);
        }
        if (processor == null) {
            DataBindingShortNamesCache.$$$reportNull$$$0(27);
        }
        for (PsiMethod method : this.getMethodsByName(name, scope)) {
            if (processor.process((Object)method)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String[] getAllMethodNames() {
        if (!this.isEnabled()) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                DataBindingShortNamesCache.$$$reportNull$$$0(28);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = (String[])this.myAllMethodNamesCache.getValue();
        if (stringArray == null) {
            DataBindingShortNamesCache.$$$reportNull$$$0(29);
        }
        return stringArray;
    }

    public void getAllMethodNames(@NotNull HashSet<String> set) {
        if (set == null) {
            DataBindingShortNamesCache.$$$reportNull$$$0(30);
        }
        if (!this.isEnabled()) {
            return;
        }
        Collections.addAll(set, this.getAllClassNames());
    }

    @NotNull
    public PsiField[] getFieldsByName(@NotNull @NonNls String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            DataBindingShortNamesCache.$$$reportNull$$$0(31);
        }
        if (scope == null) {
            DataBindingShortNamesCache.$$$reportNull$$$0(32);
        }
        if (!this.isEnabled()) {
            if (PsiField.EMPTY_ARRAY == null) {
                DataBindingShortNamesCache.$$$reportNull$$$0(33);
            }
            return PsiField.EMPTY_ARRAY;
        }
        List psiFields = (List)((Map)this.myFieldsByNameCache.getValue()).get(name);
        PsiField[] psiFieldArray = (PsiField[])DataBindingShortNamesCache.filterByScope((List)psiFields, (GlobalSearchScope)scope, PsiField.class, (PsiElement[])PsiField.EMPTY_ARRAY);
        if (psiFieldArray == null) {
            DataBindingShortNamesCache.$$$reportNull$$$0(34);
        }
        return psiFieldArray;
    }

    @NotNull
    public String[] getAllFieldNames() {
        if (!this.isEnabled()) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                DataBindingShortNamesCache.$$$reportNull$$$0(35);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = (String[])this.myAllFieldNamesCache.getValue();
        if (stringArray == null) {
            DataBindingShortNamesCache.$$$reportNull$$$0(36);
        }
        return stringArray;
    }

    public void getAllFieldNames(@NotNull HashSet<String> set) {
        if (set == null) {
            DataBindingShortNamesCache.$$$reportNull$$$0(37);
        }
        if (!this.isEnabled()) {
            return;
        }
        Collections.addAll(set, this.getAllFieldNames());
    }

    private boolean isEnabled() {
        return DataBindingUtil.inMemoryClassGenerationIsEnabled() && this.myComponent.hasAnyDataBindingEnabledFacet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: 
            case 14: 
            case 19: 
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 11: 
            case 15: 
            case 20: 
            case 24: 
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/databinding/DataBindingShortNamesCache";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 30: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/databinding/DataBindingShortNamesCache";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesByName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClassNames";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsByName";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsByNameIfNotMoreThan";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsByNameIfNotMoreThan";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethodNames";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsByName";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFieldNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getClassesByName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllClassNames";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMethodsByName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMethodsByNameIfNotMoreThan";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getFieldsByNameIfNotMoreThan";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "filterByScope";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processMethodsWithName";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getAllMethodNames";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getFieldsByName";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getAllFieldNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FacetNameCacheProvider
    extends ResourceCacheValueProvider<Map<String, List<DataBindingInfo>>> {
        FacetNameCacheProvider(AndroidFacet facet) {
            super(facet, null, new ModificationTracker[0]);
        }

        @Override
        Map<String, List<DataBindingInfo>> doCompute() {
            LocalResourceRepository moduleResources = ResourceRepositoryManager.getOrCreateInstance(this.getFacet()).getModuleResources(false);
            if (moduleResources == null) {
                return this.defaultValue();
            }
            Map<String, DataBindingInfo> dataBindingResourceFiles = moduleResources.getDataBindingResourceFiles();
            if (dataBindingResourceFiles == null) {
                return this.defaultValue();
            }
            HashMap cache = Maps.newHashMap();
            for (DataBindingInfo info : dataBindingResourceFiles.values()) {
                List infoList = (List)cache.get(info.getClassName());
                if (infoList == null) {
                    infoList = Lists.newArrayList();
                    cache.put(info.getClassName(), infoList);
                }
                infoList.add(info);
            }
            return cache;
        }

        @Override
        Map<String, List<DataBindingInfo>> defaultValue() {
            return Maps.newHashMap();
        }
    }

    private static class NameCacheProvider
    extends ProjectResourceCachedValueProvider.MergedMapValueProvider<String, DataBindingInfo> {
        NameCacheProvider(DataBindingProjectComponent component) {
            super(component, new ModificationTracker[0]);
        }

        @Override
        ResourceCacheValueProvider<Map<String, List<DataBindingInfo>>> createCacheProvider(AndroidFacet facet) {
            return new FacetNameCacheProvider(facet);
        }
    }
}

