/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.tools.idea.databinding.DataBindingProjectComponent;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.databinding.LightGeneratedComponentClass;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingComponentClassFinder
extends PsiElementFinder {
    private final DataBindingProjectComponent myComponent;
    private final CachedValue<List<PsiClass>> myClasses;

    public DataBindingComponentClassFinder(@NotNull Project project) {
        if (project == null) {
            DataBindingComponentClassFinder.$$$reportNull$$$0(0);
        }
        this.myComponent = (DataBindingProjectComponent)project.getComponent(DataBindingProjectComponent.class);
        this.myClasses = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            ArrayList classes = Lists.newArrayList();
            for (AndroidFacet facet : this.myComponent.getDataBindingEnabledFacets()) {
                if (((AndroidFacetConfiguration)facet.getConfiguration()).isLibraryProject()) continue;
                classes.add(new LightGeneratedComponentClass(PsiManager.getInstance((Project)project), facet));
            }
            return CachedValueProvider.Result.create((Object)classes, (Object[])new Object[]{this.myComponent, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        }, false);
    }

    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            DataBindingComponentClassFinder.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            DataBindingComponentClassFinder.$$$reportNull$$$0(2);
        }
        if (!this.isEnabled()) {
            return null;
        }
        return (PsiClass)Iterables.tryFind((Iterable)((Iterable)this.myClasses.getValue()), input -> DataBindingComponentClassFinder.check(input, qualifiedName, scope)).orNull();
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            DataBindingComponentClassFinder.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            DataBindingComponentClassFinder.$$$reportNull$$$0(4);
        }
        if (!this.isEnabled()) {
            if (PsiClass.EMPTY_ARRAY == null) {
                DataBindingComponentClassFinder.$$$reportNull$$$0(5);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        Iterable filtered = Iterables.filter((Iterable)((Iterable)this.myClasses.getValue()), input -> DataBindingComponentClassFinder.check(input, qualifiedName, scope));
        if (filtered.iterator().hasNext()) {
            PsiClass[] psiClassArray = (PsiClass[])Iterables.toArray((Iterable)filtered, PsiClass.class);
            if (psiClassArray == null) {
                DataBindingComponentClassFinder.$$$reportNull$$$0(6);
            }
            return psiClassArray;
        }
        if (PsiClass.EMPTY_ARRAY == null) {
            DataBindingComponentClassFinder.$$$reportNull$$$0(7);
        }
        return PsiClass.EMPTY_ARRAY;
    }

    private static boolean check(@Nullable PsiClass psiClass, @NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            DataBindingComponentClassFinder.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            DataBindingComponentClassFinder.$$$reportNull$$$0(9);
        }
        return psiClass != null && psiClass.getProject() == scope.getProject() && qualifiedName.equals(psiClass.getQualifiedName());
    }

    private boolean isEnabled() {
        return DataBindingUtil.inMemoryClassGenerationIsEnabled() && this.myComponent.hasAnyDataBindingEnabledFacet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 2: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/databinding/DataBindingComponentClassFinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/databinding/DataBindingComponentClassFinder";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "check";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

