/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import icons.StudioIcons;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public enum ZoomType {
    FIT("Zoom to Fit Screen", StudioIcons.Common.RESET_ZOOM),
    FIT_INTO("Zoom out to Fit Screen", StudioIcons.Common.RESET_ZOOM),
    ACTUAL("100%", null),
    IN("Zoom In", StudioIcons.Common.ZOOM_IN),
    OUT("Zoom Out", StudioIcons.Common.ZOOM_OUT),
    SCREEN("Exact Device Size", null);

    private final String myLabel;
    private final Icon myIcon;
    private static final int[] ZOOM_POINTS;

    private ZoomType(String label, Icon icon) {
        if (label == null) {
            ZoomType.$$$reportNull$$$0(0);
        }
        this.myLabel = label;
        this.myIcon = icon;
    }

    public String getLabel() {
        return this.myLabel;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    public boolean showInMenu() {
        return this != FIT_INTO && this != SCREEN;
    }

    public String toString() {
        return this.getLabel();
    }

    public static int zoomIn(int percentage) {
        int i2 = Arrays.binarySearch(ZOOM_POINTS, percentage);
        if (i2 < 0) {
            if ((i2 = -i2 - 1) == 0 && percentage < 22) {
                return (int)Math.ceil((double)percentage * 1.1);
            }
            if (i2 < ZOOM_POINTS.length) {
                return ZOOM_POINTS[i2];
            }
            return (percentage / 100 + 1) * 100;
        }
        if (i2 < ZOOM_POINTS.length - 1) {
            return ZOOM_POINTS[i2 + 1];
        }
        return percentage + 100;
    }

    public static int zoomOut(int percentage) {
        int i2 = Arrays.binarySearch(ZOOM_POINTS, percentage);
        if (i2 < 0) {
            if ((i2 = -i2 - 1) == 0) {
                return (int)Math.floor((double)percentage / 1.1);
            }
            if (i2 < ZOOM_POINTS.length) {
                return ZOOM_POINTS[i2 - 1];
            }
            return (percentage / 100 - 1) * 100;
        }
        if (i2 > 0) {
            return ZOOM_POINTS[i2 - 1];
        }
        return (int)Math.floor((double)percentage / 1.1);
    }

    static {
        ZOOM_POINTS = new int[]{25, 33, 50, 67, 75, 90, 100, 110, 125, 150, 200};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/common/surface/ZoomType", "<init>"));
    }
}

