/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.tools.adtui.ui.AdtUiCursors;
import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceShortcut;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.surface.ScrollInteraction;
import com.android.tools.idea.common.surface.ZoomType;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.NlDropEvent;
import com.android.tools.idea.uibuilder.surface.DragDropInteraction;
import com.android.tools.idea.uibuilder.surface.MarqueeInteraction;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InteractionManager {
    private static final int HOVER_DELAY_MS = Registry.intValue((String)"ide.tooltip.initialDelay");
    private static final int SCROLL_END_TIME_MS = 500;
    @NotNull
    private final DesignSurface mySurface;
    @Nullable
    private Interaction myCurrentInteraction;
    @Nullable
    private List<Layer> myLayers;
    protected int myLastMouseX;
    protected int myLastMouseY;
    @JdkConstants.InputEventMask
    protected static int ourLastStateMask;
    private final Timer myHoverTimer;
    private final Timer myScrollEndTimer;
    private final ActionListener myScrollEndListener;
    private final Listener myListener;
    private DropTarget myDropTarget;
    private boolean myIsListening;
    private boolean myIsPanning;

    public InteractionManager(@NotNull DesignSurface surface) {
        if (surface == null) {
            InteractionManager.$$$reportNull$$$0(0);
        }
        this.mySurface = surface;
        this.myListener = new Listener();
        this.myHoverTimer = new Timer(HOVER_DELAY_MS, null);
        this.myHoverTimer.setRepeats(false);
        this.myScrollEndTimer = new Timer(500, null);
        this.myScrollEndTimer.setRepeats(false);
        this.myScrollEndListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InteractionManager.this.myScrollEndTimer.removeActionListener(this);
                InteractionManager.this.finishInteraction(0, 0, 0, false);
            }
        };
    }

    @NotNull
    public DesignSurface getSurface() {
        DesignSurface designSurface = this.mySurface;
        if (designSurface == null) {
            InteractionManager.$$$reportNull$$$0(1);
        }
        return designSurface;
    }

    public void startListening() {
        if (this.myIsListening) {
            return;
        }
        JComponent layeredPane = this.mySurface.getLayeredPane();
        layeredPane.addMouseMotionListener(this.myListener);
        layeredPane.addMouseWheelListener(this.myListener);
        layeredPane.addMouseListener(this.myListener);
        layeredPane.addKeyListener(this.myListener);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.myDropTarget = new DropTarget(this.mySurface.getLayeredPane(), 3, this.myListener, true, null);
        }
        this.myHoverTimer.addActionListener(this.myListener);
        this.myIsListening = true;
    }

    public void stopListening() {
        if (!this.myIsListening) {
            return;
        }
        JComponent layeredPane = this.mySurface.getLayeredPane();
        layeredPane.removeMouseMotionListener(this.myListener);
        layeredPane.removeMouseWheelListener(this.myListener);
        layeredPane.removeMouseListener(this.myListener);
        layeredPane.removeKeyListener(this.myListener);
        if (this.myDropTarget != null) {
            this.myDropTarget.removeDropTargetListener(this.myListener);
        }
        this.myHoverTimer.removeActionListener(this.myListener);
        this.myHoverTimer.stop();
        this.myIsListening = false;
    }

    private void startInteraction(int x, int y, @Nullable Interaction interaction, int modifiers) {
        if (this.myCurrentInteraction != null) {
            this.finishInteraction(x, y, modifiers, true);
            assert (this.myCurrentInteraction == null);
        }
        if (interaction != null) {
            this.myCurrentInteraction = interaction;
            this.myCurrentInteraction.begin(x, y, modifiers);
            this.myLayers = interaction.createOverlays();
        }
    }

    @Nullable
    public List<Layer> getLayers() {
        return this.myLayers;
    }

    @JdkConstants.InputEventMask
    public static int getLastModifiers() {
        return ourLastStateMask;
    }

    private void updateMouse(int x, int y) {
        if (this.myCurrentInteraction != null) {
            this.myCurrentInteraction.update(x, y, ourLastStateMask);
            this.mySurface.repaint();
        }
    }

    private void finishInteraction(int x, int y, int modifiers, boolean canceled) {
        if (this.myCurrentInteraction != null) {
            this.myCurrentInteraction.end(x, y, modifiers, canceled);
            if (this.myLayers != null) {
                for (Layer layer : this.myLayers) {
                    layer.dispose();
                }
                this.myLayers = null;
            }
            this.myCurrentInteraction = null;
            ourLastStateMask = 0;
            this.updateCursor(x, y);
            this.mySurface.repaint();
        }
    }

    void updateCursor(int x, int y) {
        Cursor cursor = null;
        SceneView sceneView = this.mySurface.getSceneView(x, y);
        if (sceneView != null) {
            cursor = sceneView.getCursor(x, y);
        }
        this.mySurface.setCursor(cursor != Cursor.getDefaultCursor() ? cursor : null);
    }

    public boolean isInteractionInProgress() {
        return this.myCurrentInteraction != null;
    }

    void setPanning(boolean panning) {
        if (panning != this.myIsPanning) {
            this.myIsPanning = panning;
            this.mySurface.setCursor(panning ? AdtUiCursors.GRAB : Cursor.getDefaultCursor());
        }
    }

    boolean interceptPanInteraction(@NotNull MouseEvent event, int x, int y) {
        if (event == null) {
            InteractionManager.$$$reportNull$$$0(2);
        }
        int modifierKeyMask = 0x400 | (SystemInfo.isMac ? 256 : 128);
        if (this.myIsPanning || (event.getModifiersEx() & 0x800) != 0 || (event.getModifiersEx() & modifierKeyMask) == modifierKeyMask) {
            DesignSurface surface = this.getSurface();
            Point position = surface.getScrollPosition();
            if (position != null) {
                position.translate(this.myLastMouseX - x, this.myLastMouseY - y);
                surface.setScrollPosition(position);
                this.mySurface.setCursor(AdtUiCursors.GRABBING);
            }
            return true;
        }
        return false;
    }

    public void cancelInteraction() {
        this.finishInteraction(this.myLastMouseX, this.myLastMouseY, ourLastStateMask, true);
    }

    public Object getListener() {
        return this.myListener;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/surface/InteractionManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/surface/InteractionManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSurface";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "interceptPanInteraction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Listener
    implements MouseMotionListener,
    MouseListener,
    KeyListener,
    DropTargetListener,
    ActionListener,
    MouseWheelListener {
        private Listener() {
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent event) {
            if (event == null) {
                Listener.$$$reportNull$$$0(0);
            }
            int x = event.getX();
            int y = event.getY();
            int clickCount = event.getClickCount();
            NlComponent component = this.getComponentAt(x, y);
            if (clickCount == 2 && event.getButton() == 1) {
                if (component != null) {
                    if (InteractionManager.this.mySurface instanceof NlDesignSurface && ((NlDesignSurface)InteractionManager.this.mySurface).isPreviewSurface()) {
                        this.navigateEditor(component, true);
                    } else {
                        SceneView view = InteractionManager.this.mySurface.getSceneView(x, y);
                        if (view == null) {
                            return;
                        }
                        InteractionManager.this.mySurface.notifyComponentActivate(component, Coordinates.getAndroidX(view, x), Coordinates.getAndroidY(view, y));
                    }
                }
                return;
            }
            if (clickCount == 1 && event.getButton() == 1 && !event.isShiftDown() && component != null && InteractionManager.this.mySurface instanceof NlDesignSurface && ((NlDesignSurface)InteractionManager.this.mySurface).isPreviewSurface()) {
                this.navigateEditor(component, false);
            }
            if (event.isPopupTrigger()) {
                this.selectComponentAt(x, y, false, true);
                InteractionManager.this.mySurface.getActionManager().showPopup(event, component);
            }
        }

        private void navigateEditor(@NotNull NlComponent component, boolean needFocusEditor) {
            if (component == null) {
                Listener.$$$reportNull$$$0(1);
            }
            PsiElement element = component.getTag().getNavigationElement();
            if (PsiNavigationSupport.getInstance().canNavigate(element) && element instanceof Navigatable) {
                ((Navigatable)element).navigate(needFocusEditor);
            }
        }

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            if (event == null) {
                Listener.$$$reportNull$$$0(2);
            }
            if (event.getID() == 501) {
                InteractionManager.this.mySurface.getLayeredPane().requestFocusInWindow();
            }
            InteractionManager.this.myLastMouseX = event.getX();
            InteractionManager.this.myLastMouseY = event.getY();
            ourLastStateMask = event.getModifiers();
            if (event.isPopupTrigger()) {
                NlComponent selected = this.selectComponentAt(event.getX(), event.getY(), false, true);
                InteractionManager.this.mySurface.getActionManager().showPopup(event, selected);
                event.consume();
                return;
            }
            if (InteractionManager.this.interceptPanInteraction(event, InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY)) {
                return;
            }
            Interaction interaction = InteractionManager.this.getSurface().createInteractionOnClick(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY);
            if (interaction != null) {
                InteractionManager.this.startInteraction(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, interaction, ourLastStateMask);
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent event) {
            if (event == null) {
                Listener.$$$reportNull$$$0(3);
            }
            if (event.isPopupTrigger()) {
                NlComponent selected = this.selectComponentAt(event.getX(), event.getY(), false, true);
                InteractionManager.this.mySurface.repaint();
                InteractionManager.this.mySurface.getActionManager().showPopup(event, selected);
                return;
            }
            if (event.getButton() > 1 || SystemInfo.isMac && event.isControlDown()) {
                return;
            }
            int x = event.getX();
            int y = event.getY();
            int modifiers = event.getModifiers();
            if (InteractionManager.this.interceptPanInteraction(event, x, y)) {
                return;
            }
            if (InteractionManager.this.myCurrentInteraction == null) {
                boolean allowToggle = (modifiers & (1 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) != 0;
                this.selectComponentAt(x, y, allowToggle, false);
                InteractionManager.this.mySurface.repaint();
            }
            if (InteractionManager.this.myCurrentInteraction == null) {
                InteractionManager.this.updateCursor(x, y);
            } else {
                InteractionManager.this.finishInteraction(x, y, modifiers, false);
            }
            InteractionManager.this.mySurface.repaint();
        }

        @Nullable
        private NlComponent selectComponentAt(int x, int y, boolean allowToggle, boolean ignoreIfAlreadySelected) {
            SceneView sceneView = InteractionManager.this.mySurface.getSceneView(x, y);
            if (sceneView == null) {
                return null;
            }
            SceneContext context = SceneContext.get(sceneView);
            int xDip = Coordinates.getAndroidXDip(sceneView, x);
            int yDip = Coordinates.getAndroidYDip(sceneView, y);
            Scene scene = sceneView.getScene();
            Target clickedTarget = scene.findTarget(context, xDip, yDip);
            SceneComponent clicked = clickedTarget != null ? clickedTarget.getComponent() : scene.findComponent(context, xDip, yDip);
            NlComponent component = null;
            if (clicked != null) {
                component = clicked.getNlComponent();
            }
            SelectionModel selectionModel = sceneView.getSelectionModel();
            if (ignoreIfAlreadySelected && component != null && selectionModel.isSelected(component)) {
                return component;
            }
            if (component == null) {
                selectionModel.clear();
            } else if (allowToggle) {
                selectionModel.toggle(component);
            } else {
                selectionModel.setSelection(Collections.singletonList(component));
            }
            return component;
        }

        @Nullable
        private NlComponent getComponentAt(int x, int y) {
            SceneView sceneView = InteractionManager.this.mySurface.getSceneView(x, y);
            if (sceneView == null) {
                return null;
            }
            return Coordinates.findComponent(sceneView, x, y);
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent event) {
            if (event == null) {
                Listener.$$$reportNull$$$0(4);
            }
            InteractionManager.this.myHoverTimer.restart();
        }

        @Override
        public void mouseExited(@NotNull MouseEvent event) {
            if (event == null) {
                Listener.$$$reportNull$$$0(5);
            }
            InteractionManager.this.myHoverTimer.stop();
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            int y;
            int x = event.getX();
            if (InteractionManager.this.interceptPanInteraction(event, x, y = event.getY())) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(event)) {
                return;
            }
            if (InteractionManager.this.myCurrentInteraction != null) {
                InteractionManager.this.myLastMouseX = x;
                InteractionManager.this.myLastMouseY = y;
                ourLastStateMask = event.getModifiers();
                InteractionManager.this.myCurrentInteraction.update(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, ourLastStateMask);
                InteractionManager.this.updateCursor(x, y);
                InteractionManager.this.mySurface.getLayeredPane().scrollRectToVisible(new Rectangle(x - 50, y - 50, 100, 100));
                InteractionManager.this.mySurface.repaint();
            } else {
                Interaction interaction;
                NlComponent primaryNlComponent;
                SceneComponent primary;
                int modifiers;
                x = InteractionManager.this.myLastMouseX;
                y = InteractionManager.this.myLastMouseY;
                ourLastStateMask = modifiers = event.getModifiers();
                SceneView sceneView = InteractionManager.this.mySurface.getSceneView(x, y);
                if (sceneView == null) {
                    return;
                }
                Scene scene = sceneView.getScene();
                SelectionModel selectionModel = sceneView.getSelectionModel();
                int xDp = Coordinates.getAndroidXDip(sceneView, x);
                int yDp = Coordinates.getAndroidYDip(sceneView, y);
                NlModel model = sceneView.getModel();
                SceneComponent component = null;
                if (selectionModel.isEmpty() && !model.getComponents().isEmpty()) {
                    selectionModel.setSelection((List<NlComponent>)ImmutableList.of((Object)((NlComponent)model.getComponents().get(0)).getRoot()));
                }
                if ((primary = scene.getSceneComponent(primaryNlComponent = selectionModel.getPrimary())) != null && primary.getParent() != null && primary.containsX(xDp) && primary.containsY(yDp)) {
                    component = primary;
                }
                if (component == null) {
                    component = scene.findComponent(SceneContext.get(sceneView), xDp, yDp);
                }
                if ((interaction = component == null || component.getParent() == null ? new MarqueeInteraction(sceneView) : InteractionManager.this.getSurface().createInteractionOnDrag(component, primary)) != null) {
                    InteractionManager.this.startInteraction(x, y, interaction, modifiers);
                }
                InteractionManager.this.updateCursor(x, y);
            }
            InteractionManager.this.myHoverTimer.restart();
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            int x = event.getX();
            int y = event.getY();
            InteractionManager.this.myLastMouseX = x;
            InteractionManager.this.myLastMouseY = y;
            if (InteractionManager.this.interceptPanInteraction(event, x, y)) {
                return;
            }
            ourLastStateMask = event.getModifiers();
            InteractionManager.this.mySurface.hover(x, y);
            if ((ourLastStateMask & 0x400) != 0) {
                if (InteractionManager.this.myCurrentInteraction != null) {
                    InteractionManager.this.updateMouse(x, y);
                    InteractionManager.this.mySurface.repaint();
                }
            } else {
                InteractionManager.this.updateCursor(x, y);
            }
            InteractionManager.this.myHoverTimer.restart();
        }

        @Override
        public void keyTyped(KeyEvent event) {
            ourLastStateMask = event.getModifiers();
        }

        @Override
        public void keyPressed(KeyEvent event) {
            SelectionModel model;
            SceneView sceneView;
            int modifiers = event.getModifiers();
            int keyCode = event.getKeyCode();
            ourLastStateMask = modifiers;
            if (InteractionManager.this.myCurrentInteraction != null) {
                if (keyCode == 27) {
                    InteractionManager.this.finishInteraction(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, ourLastStateMask, true);
                    return;
                }
                if (InteractionManager.this.myCurrentInteraction.keyPressed(event)) {
                    return;
                }
            }
            if (keyCode == DesignSurfaceShortcut.PAN.getKeyCode()) {
                InteractionManager.this.setPanning(true);
                return;
            }
            if (event.isAltDown() || event.isMetaDown() || event.isShiftDown() || event.isControlDown()) {
                return;
            }
            if (!(keyCode != 127 && keyCode != 8 || (sceneView = InteractionManager.this.mySurface.getSceneView(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY)) == null || (model = sceneView.getSelectionModel()).isEmpty())) {
                ImmutableList<NlComponent> selection = model.getSelection();
                sceneView.getModel().delete((Collection<NlComponent>)selection);
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
            ourLastStateMask = event.getModifiers();
            if (InteractionManager.this.myCurrentInteraction != null) {
                InteractionManager.this.myCurrentInteraction.keyReleased(event);
            }
            if (event.getKeyCode() == DesignSurfaceShortcut.PAN.getKeyCode()) {
                InteractionManager.this.setPanning(false);
                InteractionManager.this.updateCursor(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY);
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent dragEvent) {
            if (InteractionManager.this.myCurrentInteraction == null) {
                NlDropEvent event = new NlDropEvent(dragEvent);
                Point location = event.getLocation();
                InteractionManager.this.myLastMouseX = location.x;
                InteractionManager.this.myLastMouseY = location.y;
                SceneView sceneView = InteractionManager.this.mySurface.getSceneView(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY);
                if (sceneView == null) {
                    event.reject();
                    return;
                }
                NlModel model = sceneView.getModel();
                DnDTransferItem item = DnDTransferItem.getTransferItem(event.getTransferable(), true);
                if (item == null) {
                    event.reject();
                    return;
                }
                DragType dragType = event.getDropAction() == 1 ? DragType.COPY : DragType.MOVE;
                InsertType insertType = model.determineInsertType(dragType, item, true);
                List dragged = (List)ApplicationManager.getApplication().runWriteAction(() -> model.createComponents(item, insertType, InteractionManager.this.mySurface));
                if (dragged == null) {
                    event.reject();
                    return;
                }
                DragDropInteraction interaction = new DragDropInteraction(InteractionManager.this.mySurface, dragged);
                interaction.setType(dragType);
                interaction.setTransferItem(item);
                InteractionManager.this.startInteraction(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, interaction, 0);
                event.accept(insertType);
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dragEvent) {
            NlDropEvent event = new NlDropEvent(dragEvent);
            Point location = event.getLocation();
            InteractionManager.this.myLastMouseX = location.x;
            InteractionManager.this.myLastMouseY = location.y;
            SceneView sceneView = InteractionManager.this.mySurface.getSceneView(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY);
            if (sceneView != null && InteractionManager.this.myCurrentInteraction instanceof DragDropInteraction) {
                DragDropInteraction interaction = (DragDropInteraction)InteractionManager.this.myCurrentInteraction;
                interaction.update(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, ourLastStateMask);
                if (interaction.acceptsDrop()) {
                    DragType dragType = event.getDropAction() == 1 ? DragType.COPY : DragType.MOVE;
                    interaction.setType(dragType);
                    NlModel model = sceneView.getModel();
                    InsertType insertType = model.determineInsertType(dragType, interaction.getTransferItem(), true);
                    event.accept(insertType);
                } else {
                    event.reject();
                }
            } else {
                event.reject();
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
        }

        @Override
        public void dragExit(DropTargetEvent event) {
            if (InteractionManager.this.myCurrentInteraction instanceof DragDropInteraction) {
                InteractionManager.this.finishInteraction(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, ourLastStateMask, true);
            }
        }

        @Override
        public void drop(DropTargetDropEvent dropEvent) {
            NlDropEvent event = new NlDropEvent(dropEvent);
            Point location = event.getLocation();
            InteractionManager.this.myLastMouseX = location.x;
            InteractionManager.this.myLastMouseY = location.y;
            InsertType insertType = this.performDrop(event.getDropAction(), event.getTransferable());
            if (insertType != null) {
                event.accept(insertType);
                event.complete();
            } else {
                event.reject();
            }
        }

        @Nullable
        private InsertType performDrop(int dropAction, @Nullable Transferable transferable) {
            if (!(InteractionManager.this.myCurrentInteraction instanceof DragDropInteraction)) {
                return null;
            }
            InsertType insertType = this.finishDropInteraction(dropAction, transferable);
            InteractionManager.this.finishInteraction(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, ourLastStateMask, insertType == null);
            return insertType;
        }

        @Nullable
        private InsertType finishDropInteraction(int dropAction, @Nullable Transferable transferable) {
            Object components;
            if (transferable == null) {
                return null;
            }
            DnDTransferItem item = DnDTransferItem.getTransferItem(transferable, false);
            if (item == null) {
                return null;
            }
            SceneView sceneView = InteractionManager.this.mySurface.getSceneView(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY);
            if (sceneView == null) {
                return null;
            }
            NlModel model = sceneView.getModel();
            DragType dragType = dropAction == 1 ? DragType.COPY : DragType.MOVE;
            InsertType insertType = model.determineInsertType(dragType, item, false);
            DragDropInteraction interaction = (DragDropInteraction)InteractionManager.this.myCurrentInteraction;
            assert (interaction != null);
            interaction.setType(dragType);
            interaction.setTransferItem(item);
            List<NlComponent> dragged = interaction.getDraggedComponents();
            if (insertType.isMove()) {
                components = InteractionManager.this.mySurface.getSelectionModel().getSelection();
            } else {
                components = model.createComponents(item, insertType, InteractionManager.this.mySurface);
                if (components.isEmpty()) {
                    return null;
                }
            }
            if (dragged.size() != components.size()) {
                throw new AssertionError((Object)String.format("Problem with drop: dragged.size(%1$d) != components.size(%2$d)", dragged.size(), components.size()));
            }
            for (int index = 0; index < dragged.size(); ++index) {
                NlComponentHelperKt.setX((NlComponent)components.get(index), NlComponentHelperKt.getX(dragged.get(index)));
                NlComponentHelperKt.setY((NlComponent)components.get(index), NlComponentHelperKt.getY(dragged.get(index)));
            }
            dragged.clear();
            dragged.addAll((Collection<NlComponent>)components);
            return insertType;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() != InteractionManager.this.myHoverTimer) {
                return;
            }
            int x = InteractionManager.this.myLastMouseX;
            int y = InteractionManager.this.myLastMouseY;
            InteractionManager.this.mySurface.hover(x, y);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            boolean isScrollInteraction;
            int scrollAmount;
            int x = e.getX();
            int y = e.getY();
            if (e.getScrollType() == 0) {
                scrollAmount = e.getUnitsToScroll();
            } else {
                int n = scrollAmount = e.getWheelRotation() < 0 ? -1 : 1;
            }
            if (!e.isShiftDown() && (SystemInfo.isMac && e.isMetaDown() || e.isControlDown())) {
                if (scrollAmount < 0) {
                    InteractionManager.this.mySurface.zoom(ZoomType.IN, x, y);
                } else if (scrollAmount > 0) {
                    InteractionManager.this.mySurface.zoom(ZoomType.OUT, x, y);
                }
                return;
            }
            SceneView sceneView = InteractionManager.this.mySurface.getSceneView(x, y);
            if (sceneView == null) {
                e.getComponent().getParent().dispatchEvent(e);
                return;
            }
            NlComponent component = Coordinates.findComponent(sceneView, x, y);
            if (component == null) {
                e.getComponent().getParent().dispatchEvent(e);
                return;
            }
            if (InteractionManager.this.myCurrentInteraction == null) {
                ScrollInteraction scrollInteraction = ScrollInteraction.createScrollInteraction(sceneView, component);
                if (scrollInteraction == null) {
                    e.getComponent().getParent().dispatchEvent(e);
                    return;
                }
                InteractionManager.this.startInteraction(x, y, scrollInteraction, 0);
                isScrollInteraction = true;
                InteractionManager.this.myScrollEndTimer.addActionListener(InteractionManager.this.myScrollEndListener);
            } else {
                isScrollInteraction = InteractionManager.this.myCurrentInteraction instanceof ScrollInteraction;
            }
            if (isScrollInteraction && !((ScrollInteraction)InteractionManager.this.myCurrentInteraction).canScroll(scrollAmount)) {
                JScrollPane scrollPane = InteractionManager.this.mySurface.getScrollPane();
                JViewport viewport = scrollPane.getViewport();
                Dimension extentSize = viewport.getExtentSize();
                Dimension viewSize = viewport.getViewSize();
                if (viewSize.width > extentSize.width || viewSize.height > extentSize.height) {
                    e.getComponent().getParent().dispatchEvent(e);
                    return;
                }
            }
            InteractionManager.this.myCurrentInteraction.scroll(e.getX(), e.getY(), scrollAmount);
            if (isScrollInteraction) {
                InteractionManager.this.myScrollEndTimer.restart();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/common/surface/InteractionManager$Listener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseClicked";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "navigateEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mousePressed";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseReleased";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseEntered";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseExited";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

