/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class DrawTextRegion
extends DrawRegion {
    protected static final int DEFAULT_FONT_SIZE = 14;
    protected static final float DEFAULT_SCALE = 1.0f;
    protected static final float SCALE_ADJUST = 0.88f;
    private static final Color TEXT_PANE_BACKGROUND = new Color(0, 0, 0, 0);
    static boolean DO_WRAP = false;
    protected final int mFontSize;
    protected final int mMode;
    protected int mLevel = 20;
    protected final float mScale;
    protected final int myBaseLineOffset;
    protected int mHorizontalPadding = 0;
    protected int mVerticalPadding = 0;
    protected int mVerticalMargin = 0;
    protected int mHorizontalMargin = 0;
    protected final boolean mToUpperCase;
    public static final int TEXT_ALIGNMENT_TEXT_START = 2;
    public static final int TEXT_ALIGNMENT_TEXT_END = 3;
    public static final int TEXT_ALIGNMENT_VIEW_START = 5;
    public static final int TEXT_ALIGNMENT_VIEW_END = 6;
    public static final int TEXT_ALIGNMENT_CENTER = 4;
    protected final int mAlignmentX;
    protected final int mAlignmentY;
    protected final String mText;
    protected final Font mFont;
    protected boolean mSingleLine = false;
    static final JTextPane sTextPane = new JTextPane();

    public static void setDoWrap(boolean doWrap) {
        DO_WRAP = doWrap;
    }

    @Override
    public int getLevel() {
        return this.mLevel;
    }

    public static DrawTextRegion createFromString(String string) {
        String[] sp = string.split(",");
        int c = 0;
        int x = Integer.parseInt(sp[c++]);
        int y = Integer.parseInt(sp[c++]);
        int width = Integer.parseInt(sp[c++]);
        int height = Integer.parseInt(sp[c++]);
        int mode = Integer.parseInt(sp[c++]);
        int baseLineOffset = Integer.parseInt(sp[c++]);
        boolean singleLine = Boolean.parseBoolean(sp[c++]);
        boolean toUpperCase = Boolean.parseBoolean(sp[c++]);
        int alignmentX = Integer.parseInt(sp[c++]);
        int alignmentY = Integer.parseInt(sp[c++]);
        int fontSize = Integer.parseInt(sp[c++]);
        float scale = Float.parseFloat(sp[c++]);
        String text = string.substring(string.indexOf(34) + 1, string.lastIndexOf(34));
        return new DrawTextRegion(x, y, width, height, mode, baseLineOffset, text, singleLine, toUpperCase, alignmentX, alignmentY, fontSize, scale);
    }

    @Override
    public String serialize() {
        return this.getClass().getSimpleName() + "," + this.x + "," + this.y + "," + this.width + "," + this.height + "," + this.mMode + "," + this.myBaseLineOffset + "," + this.mSingleLine + "," + this.mToUpperCase + "," + this.mAlignmentX + "," + this.mAlignmentY + "," + this.mFontSize + "," + this.mScale + ",\"" + this.mText + "\"";
    }

    public DrawTextRegion(int x, int y, int width, int height, int mode, int baseLineOffset, String text, boolean singleLine, boolean toUpperCase, int textAlignmentX, int textAlignmentY, int fontSize, float scale) {
        super(x, y, width, height);
        this.mMode = mode;
        this.mText = text;
        this.myBaseLineOffset = baseLineOffset;
        this.mSingleLine = singleLine;
        this.mToUpperCase = toUpperCase;
        this.mAlignmentX = textAlignmentX;
        this.mAlignmentY = textAlignmentY;
        this.mFontSize = fontSize;
        this.mScale = scale;
        this.mFont = new Font("Helvetica", 0, this.mFontSize).deriveFont(AffineTransform.getScaleInstance(scale * 0.88f, scale * 0.88f));
        switch (this.mMode) {
            case 2: {
                this.mLevel = 30;
            }
        }
    }

    public DrawTextRegion(int x, int y, int width, int height, int mode, int baseLineOffset, String text) {
        this(x, y, width, height, mode, baseLineOffset, text, false, false, 2, 2, 14, 1.0f);
    }

    @Override
    public void paint(Graphics2D g2d, SceneContext sceneContext) {
        int tx = this.x;
        int ty = this.y;
        int h = this.height;
        int w = this.width;
        if (!sceneContext.getColorSet().drawBackground()) {
            return;
        }
        Font originalFont = g2d.getFont();
        Color originalColor = g2d.getColor();
        ColorSet colorSet = sceneContext.getColorSet();
        int horizontalPadding = this.mHorizontalPadding + this.mHorizontalMargin;
        int verticalPadding = this.mVerticalPadding + this.mVerticalMargin;
        g2d.setFont(this.mFont);
        FontMetrics fontMetrics = g2d.getFontMetrics();
        Color color = colorSet.getFrames();
        g2d.setColor(color);
        String string = this.mText;
        if (this.mToUpperCase) {
            string = StringUtil.toUpperCase((String)string);
        }
        int ftx = 0;
        int fty = 0;
        int stringWidth = fontMetrics.stringWidth(string);
        if (stringWidth > w + 10 && !this.mSingleLine) {
            sTextPane.setBackground(TEXT_PANE_BACKGROUND);
            sTextPane.setText(string);
            sTextPane.setForeground(color);
            sTextPane.setSize(w, h);
            sTextPane.setFont(this.mFont);
            StyledDocument doc = sTextPane.getStyledDocument();
            SimpleAttributeSet attributeSet = new SimpleAttributeSet();
            switch (this.mAlignmentX) {
                case 5: {
                    StyleConstants.setAlignment(attributeSet, 0);
                    break;
                }
                case 4: {
                    StyleConstants.setAlignment(attributeSet, 1);
                    break;
                }
                case 6: {
                    StyleConstants.setAlignment(attributeSet, 2);
                }
            }
            switch (this.mAlignmentY) {
                case 5: {
                    sTextPane.setAlignmentY(0.0f);
                    break;
                }
                case 4: {
                    sTextPane.setAlignmentY(0.5f);
                    break;
                }
                case 6: {
                    sTextPane.setAlignmentY(1.0f);
                }
            }
            doc.setParagraphAttributes(0, doc.getLength(), attributeSet, false);
            g2d.translate(tx, ty);
            Shape clip = g2d.getClip();
            g2d.clipRect(0, 0, w, h);
            sTextPane.paint(g2d);
            g2d.setClip(clip);
            g2d.translate(-tx, -ty);
        } else {
            int alignX = DrawTextRegion.switchAlignment(string, this.mAlignmentX);
            switch (alignX) {
                case 2: 
                case 5: {
                    ftx = tx + horizontalPadding;
                    break;
                }
                case 4: {
                    int paddx = (w - stringWidth) / 2;
                    ftx = tx + paddx;
                    break;
                }
                case 3: 
                case 6: {
                    int padd = w - stringWidth + horizontalPadding;
                    ftx = tx + padd;
                }
            }
            fty = this.myBaseLineOffset + ty;
            Shape clip = g2d.getClip();
            g2d.clipRect(tx, ty, w, h);
            g2d.drawString(string, ftx, fty);
            g2d.setClip(clip);
        }
        g2d.setFont(originalFont);
        g2d.setColor(originalColor);
    }

    private static int switchAlignment(String string, int alignmentX) {
        boolean flip_text;
        if (string.isEmpty()) {
            return alignmentX;
        }
        char c = string.charAt(0);
        boolean bl = flip_text = c >= '\u0590' && c <= '\u06ff';
        if (flip_text) {
            switch (alignmentX) {
                case 3: {
                    return 2;
                }
                case 2: {
                    return 3;
                }
            }
        }
        return alignmentX;
    }

    public static int getFont(NlComponent nlc, String default_dim) {
        String textSize;
        Configuration configuration = nlc.getModel().getConfiguration();
        ResourceResolver resourceResolver = configuration.getResourceResolver();
        Integer size = null;
        if (resourceResolver != null && (textSize = nlc.getAttribute("http://schemas.android.com/apk/res/android", "textSize")) != null) {
            size = ViewEditor.resolveDimensionPixelSize((RenderResources)resourceResolver, textSize, configuration);
        }
        if (size == null) {
            size = ViewEditor.resolveDimensionPixelSize((RenderResources)resourceResolver, default_dim, configuration);
        }
        if (size != null) {
            return size;
        }
        return -1;
    }
}

