/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DrawCommandBase;
import com.android.tools.idea.common.scene.draw.DrawCommandBaseKt;
import com.android.tools.idea.common.scene.draw.DrawCommandSerializationHelperKt;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\b\u0012\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007B%\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u0011\u001a\u00020\tH\u00c2\u0003J\t\u0010\u0012\u001a\u00020\u000bH\u00c2\u0003J\t\u0010\u0013\u001a\u00020\rH\u00c2\u0003J\t\u0010\u0014\u001a\u00020\u000fH\u00c2\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\b\u0010\u001a\u001a\u00020\tH\u0016J\t\u0010\u001b\u001a\u00020\tH\u00d6\u0001J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020\u0004H\u0016J\t\u0010#\u001a\u00020\u0004H\u00d6\u0001R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/common/scene/draw/DrawRoundRectangle;", "Lcom/android/tools/idea/common/scene/draw/DrawCommandBase;", "sp", "", "", "([Ljava/lang/String;)V", "s", "(Ljava/lang/String;)V", "level", "", "rectangle", "Ljava/awt/geom/RoundRectangle2D$Float;", "color", "Ljava/awt/Color;", "brushThickness", "", "(ILjava/awt/geom/RoundRectangle2D$Float;Ljava/awt/Color;F)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "getLevel", "hashCode", "onPaint", "", "g", "Ljava/awt/Graphics2D;", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "serialize", "toString", "intellij.android.designer"})
public final class DrawRoundRectangle
extends DrawCommandBase {
    private final int level;
    private final RoundRectangle2D.Float rectangle;
    private final Color color;
    private final float brushThickness;

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    @NotNull
    public String serialize() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        return DrawCommandSerializationHelperKt.buildString(string, this.level, DrawCommandSerializationHelperKt.roundRect2DToString(this.rectangle), DrawCommandSerializationHelperKt.colorToString(this.color), Float.valueOf(this.brushThickness));
    }

    @Override
    protected void onPaint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)sceneContext, (String)"sceneContext");
        g.setRenderingHints((Map)DrawCommandBaseKt.getHQ_RENDERING_HINTS());
        g.setColor(this.color);
        g.setStroke(new BasicStroke(this.brushThickness));
        g.draw(this.rectangle);
    }

    public DrawRoundRectangle(int level, @NotNull RoundRectangle2D.Float rectangle, @NotNull Color color, float brushThickness) {
        Intrinsics.checkParameterIsNotNull((Object)rectangle, (String)"rectangle");
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        this.level = level;
        this.rectangle = rectangle;
        this.color = color;
        this.brushThickness = brushThickness;
    }

    private DrawRoundRectangle(String[] sp) {
        String string = sp[0];
        DrawRoundRectangle drawRoundRectangle = this;
        boolean bl = false;
        int n = Integer.parseInt(string);
        string = sp[3];
        Color color = DrawCommandSerializationHelperKt.stringToColor(sp[2]);
        RoundRectangle2D.Float float_ = DrawCommandSerializationHelperKt.stringToRoundRect2D(sp[1]);
        bl = false;
        float f = Float.parseFloat(string);
        drawRoundRectangle(n, float_, color, f);
    }

    public DrawRoundRectangle(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        this(DrawCommandSerializationHelperKt.parse(s, 4));
    }

    private final int component1() {
        return this.level;
    }

    private final RoundRectangle2D.Float component2() {
        return this.rectangle;
    }

    private final Color component3() {
        return this.color;
    }

    private final float component4() {
        return this.brushThickness;
    }

    @NotNull
    public final DrawRoundRectangle copy(int level, @NotNull RoundRectangle2D.Float rectangle, @NotNull Color color, float brushThickness) {
        Intrinsics.checkParameterIsNotNull((Object)rectangle, (String)"rectangle");
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        return new DrawRoundRectangle(level, rectangle, color, brushThickness);
    }

    public static /* synthetic */ DrawRoundRectangle copy$default(DrawRoundRectangle drawRoundRectangle, int n, RoundRectangle2D.Float float_, Color color, float f, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = drawRoundRectangle.level;
        }
        if ((n2 & 2) != 0) {
            float_ = drawRoundRectangle.rectangle;
        }
        if ((n2 & 4) != 0) {
            color = drawRoundRectangle.color;
        }
        if ((n2 & 8) != 0) {
            f = drawRoundRectangle.brushThickness;
        }
        return drawRoundRectangle.copy(n, float_, color, f);
    }

    @NotNull
    public String toString() {
        return "DrawRoundRectangle(level=" + this.level + ", rectangle=" + this.rectangle + ", color=" + this.color + ", brushThickness=" + this.brushThickness + ")";
    }

    public int hashCode() {
        RoundRectangle2D.Float float_ = this.rectangle;
        Color color = this.color;
        return ((Integer.hashCode(this.level) * 31 + (float_ != null ? ((Object)float_).hashCode() : 0)) * 31 + (color != null ? ((Object)color).hashCode() : 0)) * 31 + Float.hashCode(this.brushThickness);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DrawRoundRectangle)) break block3;
                DrawRoundRectangle drawRoundRectangle = (DrawRoundRectangle)object;
                if (!(this.level == drawRoundRectangle.level) || !Intrinsics.areEqual((Object)this.rectangle, (Object)drawRoundRectangle.rectangle) || !Intrinsics.areEqual((Object)this.color, (Object)drawRoundRectangle.color) || Float.compare(this.brushThickness, drawRoundRectangle.brushThickness) != 0) break block3;
            }
            return true;
        }
        return false;
    }
}

