/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawLassoUtil;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import java.awt.Graphics2D;

public class DrawLasso
extends DrawRegion {
    private int myMouseX;
    private int myMouseY;
    private boolean myShowSize;

    public DrawLasso(String s) {
        super(s);
    }

    public DrawLasso(int x, int y, int width, int height, int mouseX, int mouseY, boolean showSize) {
        super(x, y, width, height);
        this.myMouseX = mouseX;
        this.myMouseY = mouseY;
        this.myShowSize = showSize;
    }

    @Override
    protected int parse(String[] sp, int c) {
        this.myMouseX = Integer.parseInt(sp[c++]);
        this.myMouseY = Integer.parseInt(sp[c++]);
        this.myShowSize = Boolean.parseBoolean(sp[c++]);
        return c;
    }

    @Override
    public String serialize() {
        return super.serialize() + "," + this.myMouseX + "," + this.myMouseY + "," + this.myShowSize;
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        int dpWidth = (int)((double)sceneContext.pxToDp(this.width) / sceneContext.getScale());
        int dpHeight = (int)((double)sceneContext.pxToDp(this.height) / sceneContext.getScale());
        ColorSet colorSet = sceneContext.getColorSet();
        DrawLassoUtil.drawLasso(g, colorSet, this.x, this.y, this.width, this.height, this.myMouseX, this.myMouseY, dpWidth, dpHeight, this.myShowSize);
    }

    public static void add(DisplayList list, SceneContext transform2, float left, float top, float right, float bottom, float mouseX, float mouseY, boolean showSize) {
        int l = transform2.getSwingXDip(left);
        int t = transform2.getSwingYDip(top);
        int w = transform2.getSwingDimensionDip(right - left);
        int h = transform2.getSwingDimensionDip(bottom - top);
        int swingMouseX = transform2.getSwingXDip(mouseX);
        int swingMouseY = transform2.getSwingYDip(mouseY);
        list.add(new DrawLasso(l, t, w, h, swingMouseX, swingMouseY, showSize));
    }
}

