/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import com.android.tools.idea.uibuilder.graphics.NlIcon;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DrawAction
extends DrawRegion {
    private final NlIcon myIcon;
    private boolean myIsOver;
    int myMode;
    protected Font mFont;

    @Override
    public int getLevel() {
        return 1010;
    }

    public DrawAction(int x, int y, int width, int height, @NotNull NlIcon icon, boolean isOver) {
        if (icon == null) {
            DrawAction.$$$reportNull$$$0(0);
        }
        super(x, y, width, height);
        this.mFont = new Font("Helvetica", 0, 14);
        this.myIcon = icon;
        this.myIsOver = isOver;
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        int r = (int)((double)this.width * 0.3);
        ColorSet colorSet = sceneContext.getColorSet();
        g.setColor(colorSet.getComponentObligatoryBackground());
        g.fillRoundRect(this.x - 1, this.y - 1, this.width + 2, this.height + 2, r, r);
        if (this.myIsOver) {
            g.setColor(colorSet.getWidgetActionSelectedBackground());
            g.fillRoundRect(this.x, this.y, this.width, this.height, r, r);
            g.setColor(colorSet.getWidgetActionSelectedBorder());
            g.drawRoundRect(this.x, this.y, this.width, this.height, r, r);
        } else {
            g.setColor(colorSet.getWidgetActionBackground());
            g.fillRoundRect(this.x, this.y, this.width, this.height, r, r);
        }
        Color color = colorSet.getText();
        g.setColor(color);
        Icon icon = this.myIcon.getSelectedIcon(sceneContext);
        g.setFont(this.mFont);
        int iw = icon.getIconWidth();
        int ih = icon.getIconHeight();
        if (iw > this.width || ih > this.height) {
            double scale = Math.min((double)this.width / (double)iw, (double)this.height / (double)ih);
            Graphics2D g2 = (Graphics2D)g.create();
            double tx = (double)this.x + ((double)this.width - (double)iw * scale) / 2.0;
            double ty = (double)this.y + ((double)this.height - (double)ih * scale) / 2.0;
            g2.translate(tx, ty);
            g2.scale(scale, scale);
            icon.paintIcon(null, g2, 0, 0);
        } else {
            int tx = this.x + (this.width - iw) / 2;
            int ty = this.y + (this.height - ih) / 2;
            icon.paintIcon(null, g, tx, ty);
        }
    }

    @Override
    public String serialize() {
        return super.serialize() + "," + this.myMode;
    }

    public static void add(@NotNull DisplayList list, @NotNull SceneContext transform2, float left, float top, float right, float bottom, @NotNull NlIcon icon, boolean isOver) {
        if (list == null) {
            DrawAction.$$$reportNull$$$0(1);
        }
        if (transform2 == null) {
            DrawAction.$$$reportNull$$$0(2);
        }
        if (icon == null) {
            DrawAction.$$$reportNull$$$0(3);
        }
        int l = transform2.getSwingXDip(left);
        int t = transform2.getSwingYDip(top);
        int w = transform2.getSwingDimensionDip(right - left);
        int h = transform2.getSwingDimensionDip(bottom - top);
        list.add(new DrawAction(l, t, w, h, icon, isOver));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/common/scene/draw/DrawAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

