/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.property2.impl.ui;

import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0003\u001a\u00020\fH\u0002R(\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/common/property2/impl/ui/TooltipComponent;", "Ljavax/swing/JPanel;", "()V", "value", "Ljavax/swing/Icon;", "icon", "getIcon", "()Ljavax/swing/Icon;", "setIcon", "(Ljavax/swing/Icon;)V", "iconLabel", "Lcom/intellij/ui/components/JBLabel;", "", "text", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "textArea", "Ljavax/swing/JTextArea;", "forcePreferredSizeUpdate", "", "updateRowsAndColumns", "intellij.android.designer"})
final class TooltipComponent
extends JPanel {
    private final JBLabel iconLabel = new JBLabel();
    private final JTextArea textArea = new JTextArea(0, 40);

    @Nullable
    public final Icon getIcon() {
        return this.iconLabel.getIcon();
    }

    public final void setIcon(@Nullable Icon value2) {
        this.iconLabel.setIcon(value2);
        this.iconLabel.setVisible(value2 != null);
    }

    @NotNull
    public final String getText() {
        String string = this.textArea.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"textArea.text");
        return string;
    }

    public final void setText(@NotNull String value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        boolean forceUpdate = Intrinsics.areEqual((Object)this.textArea.getText(), (Object)value2) ^ true;
        this.textArea.setText(value2);
        if (forceUpdate) {
            this.updateRowsAndColumns(value2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateRowsAndColumns(String value2) {
        int columns;
        void $this$mapTo$iv$iv;
        List lines = StringsKt.lines((CharSequence)value2);
        FontMetrics fm = this.textArea.getFontMetrics(this.textArea.getFont());
        int em = fm.charWidth('m');
        Iterable $this$map$iv = lines;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = fm.stringWidth((String)it);
            collection.add(n);
        }
        Integer maxLineLength = (Integer)CollectionsKt.max((Iterable)((List)destination$iv$iv));
        int n = columns = maxLineLength != null ? maxLineLength / em : Integer.MAX_VALUE;
        if (columns > 50) {
            this.textArea.setColumns(50);
            this.textArea.setRows(0);
            this.forcePreferredSizeUpdate();
        } else {
            this.textArea.setColumns(columns + 1);
            this.textArea.setRows(lines.size());
        }
    }

    private final void forcePreferredSizeUpdate() {
        BufferedImage bufferedImage = UIUtil.createImage((int)1, (int)1, (int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)bufferedImage, (String)"UIUtil.createImage(1, 1,\u2026fferedImage.TYPE_INT_RGB)");
        BufferedImage buffer = bufferedImage;
        Graphics2D graphics = buffer.createGraphics();
        Dimension size = this.textArea.getPreferredSize();
        this.textArea.setBounds(0, 0, size.width, size.height);
        this.textArea.paint(graphics);
        graphics.dispose();
    }

    public TooltipComponent() {
        super(new BorderLayout());
        this.setBackground(UIUtil.TRANSPARENT_COLOR);
        this.textArea.setBorder((Border)JBUI.Borders.empty());
        this.textArea.setBackground(UIUtil.TRANSPARENT_COLOR);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        this.iconLabel.setBorder((Border)JBUI.Borders.emptyRight((int)6));
        this.iconLabel.setVerticalAlignment(1);
        this.add((Component)this.iconLabel, "West");
        this.add((Component)this.textArea, "Center");
    }
}

