/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.DnDTransferComponent;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponentDelegate;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.rendering.parsers.AttributeSnapshot;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.uibuilder.model.AttributesHelperKt;
import com.android.tools.idea.uibuilder.model.QualifiedName;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlComponent
implements NlAttributesHolder {
    @Nullable
    private XmlModelComponentMixin myMixin;
    private final List<NlComponent> children;
    @Nullable
    private List<NlComponent> cachedChildrenCopy;
    private NlComponent myParent;
    @NotNull
    private final NlModel myModel;
    @NotNull
    private XmlTag myTag;
    @NotNull
    private SmartPsiElementPointer<XmlTag> myTagPointer;
    @NotNull
    private String myTagName;
    @Nullable
    private TagSnapshot mySnapshot;
    private final HashMap<Object, Object> myClientProperties;
    private final ListenerCollection<ChangeListener> myListeners;
    private final ChangeEvent myChangeEvent;
    private NlComponentDelegate myDelegate;
    @Nullable
    AttributesTransaction myCurrentTransaction;

    public NlComponent(@NotNull NlModel model, @NotNull XmlTag tag) {
        if (model == null) {
            NlComponent.$$$reportNull$$$0(0);
        }
        if (tag == null) {
            NlComponent.$$$reportNull$$$0(1);
        }
        this.children = Lists.newArrayList();
        this.cachedChildrenCopy = null;
        this.myClientProperties = new HashMap();
        this.myListeners = ListenerCollection.createWithDirectExecutor();
        this.myChangeEvent = new ChangeEvent(this);
        this.myModel = model;
        this.myTag = tag;
        Application application = ApplicationManager.getApplication();
        if (application.isReadAccessAllowed()) {
            this.myTagPointer = SmartPointerManager.getInstance((Project)this.myModel.getProject()).createSmartPsiElementPointer((PsiElement)tag);
            this.myTagName = tag.getName();
        } else {
            application.runReadAction(() -> {
                this.myTagPointer = SmartPointerManager.getInstance((Project)this.myModel.getProject()).createSmartPsiElementPointer((PsiElement)tag);
                this.myTagName = tag.getName();
            });
        }
    }

    public NlComponent(@NotNull NlModel model, @NotNull XmlTag tag, @NotNull SmartPsiElementPointer<XmlTag> tagPointer) {
        if (model == null) {
            NlComponent.$$$reportNull$$$0(2);
        }
        if (tag == null) {
            NlComponent.$$$reportNull$$$0(3);
        }
        if (tagPointer == null) {
            NlComponent.$$$reportNull$$$0(4);
        }
        this.children = Lists.newArrayList();
        this.cachedChildrenCopy = null;
        this.myClientProperties = new HashMap();
        this.myListeners = ListenerCollection.createWithDirectExecutor();
        this.myChangeEvent = new ChangeEvent(this);
        this.myModel = model;
        this.myTag = tag;
        this.myTagPointer = tagPointer;
        this.myTagName = tag.getName();
    }

    @Nullable
    public NlComponentDelegate getDelegate() {
        return this.myDelegate;
    }

    public void setDelegate(@Nullable NlComponentDelegate delegate) {
        this.myDelegate = delegate;
    }

    public void setMixin(@NotNull XmlModelComponentMixin mixin) {
        if (mixin == null) {
            NlComponent.$$$reportNull$$$0(5);
        }
        assert (this.myMixin == null);
        this.myMixin = mixin;
    }

    @Nullable
    public XmlModelComponentMixin getMixin() {
        return this.myMixin;
    }

    @NotNull
    public XmlTag getTag() {
        Application application = ApplicationManager.getApplication();
        XmlTag tag = application.isReadAccessAllowed() ? (XmlTag)this.myTagPointer.getElement() : (XmlTag)application.runReadAction(() -> this.myTagPointer.getElement());
        XmlTag xmlTag = tag != null ? tag : this.myTag;
        if (xmlTag == null) {
            NlComponent.$$$reportNull$$$0(6);
        }
        return xmlTag;
    }

    @NotNull
    public SmartPsiElementPointer<XmlTag> getTagPointer() {
        SmartPsiElementPointer<XmlTag> smartPsiElementPointer = this.myTagPointer;
        if (smartPsiElementPointer == null) {
            NlComponent.$$$reportNull$$$0(7);
        }
        return smartPsiElementPointer;
    }

    @NotNull
    public NlModel getModel() {
        NlModel nlModel = this.myModel;
        if (nlModel == null) {
            NlComponent.$$$reportNull$$$0(8);
        }
        return nlModel;
    }

    public void setTag(@NotNull XmlTag tag) {
        Application application;
        if (tag == null) {
            NlComponent.$$$reportNull$$$0(9);
        }
        if ((application = ApplicationManager.getApplication()).isReadAccessAllowed()) {
            if (tag.isValid()) {
                this.myTagPointer = SmartPointerManager.getInstance((Project)this.myModel.getProject()).createSmartPsiElementPointer((PsiElement)tag);
            }
            this.myTagName = tag.getName();
        } else {
            application.runReadAction(() -> {
                if (tag.isValid()) {
                    this.myTagPointer = SmartPointerManager.getInstance((Project)this.myModel.getProject()).createSmartPsiElementPointer((PsiElement)tag);
                }
                this.myTagName = tag.getName();
            });
        }
        this.myTag = tag;
    }

    @Nullable
    public TagSnapshot getSnapshot() {
        return this.mySnapshot;
    }

    public void setSnapshot(@Nullable TagSnapshot snapshot) {
        this.mySnapshot = snapshot;
    }

    public void addChild(@NotNull NlComponent component) {
        if (component == null) {
            NlComponent.$$$reportNull$$$0(10);
        }
        this.addChild(component, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(@NotNull NlComponent component, @Nullable NlComponent before) {
        if (component == null) {
            NlComponent.$$$reportNull$$$0(11);
        }
        if (component == this) {
            throw new IllegalArgumentException();
        }
        List<NlComponent> list = this.children;
        synchronized (list) {
            int index;
            this.cachedChildrenCopy = null;
            int n = index = before != null ? this.children.indexOf(before) : -1;
            if (index != -1) {
                this.children.add(index, component);
            } else {
                this.children.add(component);
            }
        }
        component.setParent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(@NotNull NlComponent component) {
        if (component == null) {
            NlComponent.$$$reportNull$$$0(12);
        }
        if (component == this) {
            throw new IllegalArgumentException();
        }
        if (this.myDelegate != null) {
            this.myDelegate.willRemoveChild(component);
        }
        List<NlComponent> list = this.children;
        synchronized (list) {
            this.cachedChildrenCopy = null;
            this.children.remove(component);
        }
        component.setParent(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChildren(@Nullable List<NlComponent> components) {
        List<NlComponent> list = this.children;
        synchronized (list) {
            this.cachedChildrenCopy = null;
            this.children.clear();
            if (components == null) {
                return;
            }
            this.children.addAll(components);
        }
        for (NlComponent component : components) {
            if (component == this) {
                throw new IllegalArgumentException();
            }
            component.setParent(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<NlComponent> getChildren() {
        ImmutableList childrenCopy = this.cachedChildrenCopy;
        if (childrenCopy == null) {
            List<NlComponent> list = this.children;
            synchronized (list) {
                this.cachedChildrenCopy = childrenCopy = ImmutableList.copyOf(this.children);
            }
        }
        ImmutableList immutableList = childrenCopy;
        if (immutableList == null) {
            NlComponent.$$$reportNull$$$0(13);
        }
        return immutableList;
    }

    public int getChildCount() {
        return this.getChildren().size();
    }

    @Nullable
    public NlComponent getChild(int index) {
        List<NlComponent> children = this.getChildren();
        return index >= 0 && index < children.size() ? children.get(index) : null;
    }

    @NotNull
    public Stream<NlComponent> flatten() {
        Stream<NlComponent> stream = Stream.concat(Stream.of(this), this.getChildren().stream().flatMap(NlComponent::flatten));
        if (stream == null) {
            NlComponent.$$$reportNull$$$0(14);
        }
        return stream;
    }

    @Nullable
    public NlComponent getNextSibling() {
        if (this.myParent == null) {
            return null;
        }
        for (int index = 0; index < this.myParent.getChildCount(); ++index) {
            if (this.myParent.getChild(index) != this) continue;
            return this.myParent.getChild(index + 1);
        }
        return null;
    }

    @Nullable
    public NlComponent findViewByTag(@NotNull XmlTag tag) {
        if (tag == null) {
            NlComponent.$$$reportNull$$$0(15);
        }
        if (this.getTag() == tag) {
            return this;
        }
        for (NlComponent child : this.getChildren()) {
            NlComponent result2 = child.findViewByTag(tag);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    private void findViewsByTag(@NotNull XmlTag tag, @NotNull ImmutableList.Builder<NlComponent> builder) {
        if (tag == null) {
            NlComponent.$$$reportNull$$$0(16);
        }
        if (builder == null) {
            NlComponent.$$$reportNull$$$0(17);
        }
        for (NlComponent child : this.getChildren()) {
            child.findViewsByTag(tag, builder);
        }
        if (this.getTag() == tag) {
            builder.add((Object)this);
        }
    }

    @NotNull
    public ImmutableList<NlComponent> findViewsByTag(@NotNull XmlTag tag) {
        if (tag == null) {
            NlComponent.$$$reportNull$$$0(18);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        this.findViewsByTag(tag, (ImmutableList.Builder<NlComponent>)builder);
        ImmutableList immutableList = builder.build();
        if (immutableList == null) {
            NlComponent.$$$reportNull$$$0(19);
        }
        return immutableList;
    }

    public boolean isRoot() {
        return !(this.getTag().getParent() instanceof XmlTag);
    }

    public NlComponent getRoot() {
        NlComponent component;
        for (component = this; component != null && !component.isRoot(); component = component.getParent()) {
        }
        return component;
    }

    @Nullable
    public String getId() {
        String id = this.myCurrentTransaction != null ? this.myCurrentTransaction.getAndroidAttribute("id") : this.resolveAttribute("http://schemas.android.com/apk/res/android", "id");
        return NlComponent.stripId(id);
    }

    public void clearTransaction() {
        if (this.myCurrentTransaction != null) {
            this.myCurrentTransaction.finishTransaction();
        }
    }

    @Nullable
    public static String stripId(@Nullable String id) {
        if (id != null) {
            if (id.startsWith("@+id/")) {
                return id.substring("@+id/".length());
            }
            if (id.startsWith("@id/")) {
                return id.substring("@id/".length());
            }
        }
        return null;
    }

    @Nullable
    public NlComponent getParent() {
        return this.myParent;
    }

    private void setParent(@Nullable NlComponent parent) {
        this.myParent = parent;
    }

    @NotNull
    public String getTagName() {
        String string = this.myTagName;
        if (string == null) {
            NlComponent.$$$reportNull$$$0(20);
        }
        return string;
    }

    public String toString() {
        if (this.getMixin() != null) {
            return this.getMixin().toString();
        }
        return String.format("<%s>", this.myTagName);
    }

    @Override
    public void setAttribute(@Nullable String namespace, @NotNull String attribute, @Nullable String value2) {
        String previous;
        if (attribute == null) {
            NlComponent.$$$reportNull$$$0(21);
        }
        if (this.myDelegate != null && this.myDelegate.handlesAttribute(this, namespace, attribute)) {
            this.myDelegate.setAttribute(this, namespace, attribute, value2);
            return;
        }
        XmlTag tag = this.getTag();
        if (!tag.isValid()) {
            return;
        }
        String prefix = null;
        if (namespace != null && !"http://schemas.android.com/apk/res/android".equals(namespace)) {
            prefix = AndroidResourceUtil.ensureNamespaceImported((XmlFile)tag.getContainingFile(), namespace, null);
        }
        if (Objects.equals(previous = this.getAttribute(namespace, attribute), value2)) {
            return;
        }
        tag.setAttribute(attribute, namespace, value2);
        if (this.mySnapshot != null) {
            this.mySnapshot.setAttribute(attribute, namespace, prefix, value2);
        }
    }

    @NotNull
    public AttributesTransaction startAttributeTransaction() {
        if (this.myCurrentTransaction == null) {
            this.myCurrentTransaction = new AttributesTransaction(this);
        }
        AttributesTransaction attributesTransaction = this.myCurrentTransaction;
        if (attributesTransaction == null) {
            NlComponent.$$$reportNull$$$0(22);
        }
        return attributesTransaction;
    }

    @Nullable
    public String getLiveAttribute(@Nullable String namespace, @NotNull String attribute) {
        if (attribute == null) {
            NlComponent.$$$reportNull$$$0(23);
        }
        if (this.myDelegate != null && this.myDelegate.handlesAttribute(this, namespace, attribute)) {
            return this.myDelegate.getAttribute(this, namespace, attribute);
        }
        if (this.myCurrentTransaction != null) {
            return this.myCurrentTransaction.getAttribute(namespace, attribute);
        }
        return this.getAttribute(namespace, attribute);
    }

    @Override
    @Nullable
    public String getAttribute(@Nullable String namespace, @NotNull String attribute) {
        if (attribute == null) {
            NlComponent.$$$reportNull$$$0(24);
        }
        if (this.myDelegate != null && this.myDelegate.handlesAttribute(this, namespace, attribute)) {
            return this.myDelegate.getAttribute(this, namespace, attribute);
        }
        return this.getAttributeImpl(namespace, attribute);
    }

    public String getAttributeImpl(@Nullable String namespace, @NotNull String attribute) {
        if (attribute == null) {
            NlComponent.$$$reportNull$$$0(25);
        }
        if (this.mySnapshot != null) {
            return this.mySnapshot.getAttribute(attribute, namespace);
        }
        XmlTag tag = this.getTag();
        if (AndroidPsiUtils.isValid(tag)) {
            return AndroidPsiUtils.getAttributeSafely(tag, namespace, attribute);
        }
        return null;
    }

    @Nullable
    public String resolveAttribute(@Nullable String namespace, @NotNull String attribute) {
        String value2;
        if (attribute == null) {
            NlComponent.$$$reportNull$$$0(26);
        }
        if ((value2 = this.getAttribute(namespace, attribute)) != null) {
            return value2;
        }
        if (this.getMixin() != null) {
            return this.getMixin().getAttribute(namespace, attribute);
        }
        return null;
    }

    @NotNull
    public List<AttributeSnapshot> getAttributes() {
        if (this.myDelegate != null && this.myDelegate.handlesAttributes(this)) {
            List<AttributeSnapshot> attributes = this.myDelegate.getAttributes(this);
            if (attributes != null) {
                List<AttributeSnapshot> list = attributes;
                if (list == null) {
                    NlComponent.$$$reportNull$$$0(27);
                }
                return list;
            }
            List<AttributeSnapshot> list = Collections.emptyList();
            if (list == null) {
                NlComponent.$$$reportNull$$$0(28);
            }
            return list;
        }
        List<AttributeSnapshot> list = this.getAttributesImpl();
        if (list == null) {
            NlComponent.$$$reportNull$$$0(29);
        }
        return list;
    }

    @NotNull
    public List<AttributeSnapshot> getAttributesImpl() {
        if (this.mySnapshot != null) {
            List<AttributeSnapshot> list = this.mySnapshot.attributes;
            if (list == null) {
                NlComponent.$$$reportNull$$$0(30);
            }
            return list;
        }
        XmlTag tag = this.getTag();
        if (tag.isValid()) {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                List list = (List)application.runReadAction(() -> AttributeSnapshot.createAttributesForTag(tag));
                if (list == null) {
                    NlComponent.$$$reportNull$$$0(31);
                }
                return list;
            }
            List<AttributeSnapshot> list = AttributeSnapshot.createAttributesForTag(tag);
            if (list == null) {
                NlComponent.$$$reportNull$$$0(32);
            }
            return list;
        }
        List<AttributeSnapshot> list = Collections.emptyList();
        if (list == null) {
            NlComponent.$$$reportNull$$$0(33);
        }
        return list;
    }

    public String ensureNamespace(@NotNull String prefix, @NotNull String namespace) {
        if (prefix == null) {
            NlComponent.$$$reportNull$$$0(34);
        }
        if (namespace == null) {
            NlComponent.$$$reportNull$$$0(35);
        }
        return AndroidResourceUtil.ensureNamespaceImported((XmlFile)this.getTag().getContainingFile(), namespace, prefix);
    }

    public boolean isShowing() {
        return this.mySnapshot != null;
    }

    @Nullable
    public static String extractId(@Nullable String str) {
        if (str == null) {
            return null;
        }
        int index = str.lastIndexOf("@id/");
        if (index != -1) {
            return str.substring(index + 4);
        }
        index = str.lastIndexOf("@+id/");
        if (index != -1) {
            return str.substring(index + 5);
        }
        return null;
    }

    public void removeObsoleteAttributes() {
        Set<QualifiedName> obsoleteAttributes = AttributesHelperKt.getObsoleteAttributes(this);
        AttributesTransaction transaction = this.startAttributeTransaction();
        obsoleteAttributes.forEach(qualifiedName -> transaction.removeAttribute(qualifiedName.getNamespace(), qualifiedName.getName()));
        transaction.commit();
    }

    public final void putClientProperty(Object key, Object value2) {
        this.myClientProperties.put(key, value2);
    }

    public final Object getClientProperty(Object key) {
        return this.myClientProperties.get(key);
    }

    public final Object removeClientProperty(Object key) {
        return this.myClientProperties.remove(key);
    }

    public void addLiveChangeListener(ChangeListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeLiveChangeListener(ChangeListener listener2) {
        this.myListeners.remove(listener2);
    }

    public void fireLiveChangeEvent() {
        this.myListeners.forEach(listener2 -> listener2.stateChanged(this.myChangeEvent));
    }

    @NotNull
    public String assignId() {
        String string = this.assignId(this.getTagName());
        if (string == null) {
            NlComponent.$$$reportNull$$$0(36);
        }
        return string;
    }

    public String ensureId() {
        if (this.getId() != null) {
            return this.getId();
        }
        return this.assignId();
    }

    @NotNull
    public String assignId(@NotNull String baseName) {
        if (baseName == null) {
            NlComponent.$$$reportNull$$$0(37);
        }
        String string = this.assignId(baseName, this.getModel().getIds());
        if (string == null) {
            NlComponent.$$$reportNull$$$0(38);
        }
        return string;
    }

    @NotNull
    public String assignId(@NotNull Set<String> ids) {
        if (ids == null) {
            NlComponent.$$$reportNull$$$0(39);
        }
        String string = this.assignId(this.getTagName(), ids);
        if (string == null) {
            NlComponent.$$$reportNull$$$0(40);
        }
        return string;
    }

    @NotNull
    public String assignId(@NotNull String baseName, @NotNull Set<String> ids) {
        if (baseName == null) {
            NlComponent.$$$reportNull$$$0(41);
        }
        if (ids == null) {
            NlComponent.$$$reportNull$$$0(42);
        }
        String newId = NlComponent.generateId(baseName, ids, ResourceFolderType.LAYOUT, this.getModel().getModule());
        NlAttributesHolder attributes = this.myCurrentTransaction == null ? this : this.myCurrentTransaction;
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "id", "@+id/" + newId);
        this.getModel().getPendingIds().add(newId);
        String string = newId;
        if (string == null) {
            NlComponent.$$$reportNull$$$0(43);
        }
        return string;
    }

    public void incrementId(@NotNull Set<String> ids) {
        String id;
        if (ids == null) {
            NlComponent.$$$reportNull$$$0(44);
        }
        if ((id = this.getId()) == null || id.isEmpty()) {
            ids.add(this.assignId(ids));
        } else {
            String baseName = id.replaceAll("[0-9]*$", "");
            if (baseName != null && !baseName.isEmpty()) {
                ids.add(this.assignId(baseName, ids));
            }
        }
    }

    @NotNull
    public static String generateId(@NotNull String baseName, @NotNull Set<String> ids, ResourceFolderType type, Module module) {
        if (baseName == null) {
            NlComponent.$$$reportNull$$$0(45);
        }
        if (ids == null) {
            NlComponent.$$$reportNull$$$0(46);
        }
        String idValue = StringUtil.decapitalize((String)baseName.substring(baseName.lastIndexOf(46) + 1));
        Project project = module.getProject();
        String nextIdValue = idValue = ResourceHelper.prependResourcePrefix(module, idValue, type);
        int index = 0;
        NamesValidator validator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)JavaLanguage.INSTANCE);
        while (ids.contains(nextIdValue) || validator != null && validator.isKeyword(nextIdValue, project)) {
            if (!(++index != 1 || validator != null && validator.isKeyword(nextIdValue, project))) {
                nextIdValue = idValue;
                continue;
            }
            nextIdValue = idValue + index;
        }
        String string = idValue + (index == 0 ? "" : Integer.valueOf(index));
        if (string == null) {
            NlComponent.$$$reportNull$$$0(47);
        }
        return string;
    }

    @Nullable
    public String getTooltipText() {
        XmlModelComponentMixin mixin = this.getMixin();
        if (mixin != null) {
            return mixin.getTooltipText();
        }
        return null;
    }

    public boolean canAddTo(NlComponent receiver) {
        XmlModelComponentMixin mixin = this.getMixin();
        if (mixin != null) {
            return mixin.canAddTo(receiver);
        }
        return true;
    }

    public void moveTo(@NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType type, @NotNull Set<String> ids, @Nullable DesignSurface surface) {
        XmlModelComponentMixin mixin;
        if (receiver == null) {
            NlComponent.$$$reportNull$$$0(48);
        }
        if (type == null) {
            NlComponent.$$$reportNull$$$0(49);
        }
        if (ids == null) {
            NlComponent.$$$reportNull$$$0(50);
        }
        if ((mixin = this.getMixin()) != null) {
            mixin.beforeMove(type, receiver, ids);
        }
        NlComponent oldParent = this.getParent();
        this.addTags(receiver, before, type);
        if (mixin != null) {
            mixin.afterMove(type, oldParent, receiver, surface);
        }
    }

    public void addTags(@NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType type) {
        NlComponent parent;
        if (receiver == null) {
            NlComponent.$$$reportNull$$$0(51);
        }
        if (type == null) {
            NlComponent.$$$reportNull$$$0(52);
        }
        if ((parent = this.getParent()) != null) {
            parent.removeChild(this);
        }
        receiver.addChild(this, before);
        if (receiver.getTag() != this.getTag()) {
            this.transferNamespaces(receiver);
            XmlTag prev = this.getTag();
            if (before != null) {
                this.setTag((XmlTag)receiver.getTag().addBefore((PsiElement)this.getTag(), (PsiElement)before.getTag()));
            } else {
                this.setTag(receiver.getTag().addSubTag(this.getTag(), false));
            }
            if (type.isMove()) {
                prev.delete();
            }
        }
    }

    public void postCreateFromTransferrable(@NotNull DnDTransferComponent dndComponent) {
        XmlModelComponentMixin mixin;
        if (dndComponent == null) {
            NlComponent.$$$reportNull$$$0(53);
        }
        if ((mixin = this.getMixin()) != null) {
            mixin.postCreateFromTransferrable(dndComponent);
        }
    }

    public boolean postCreate(@Nullable DesignSurface surface, @NotNull InsertType insertType) {
        XmlModelComponentMixin mixin;
        if (insertType == null) {
            NlComponent.$$$reportNull$$$0(54);
        }
        if ((mixin = this.getMixin()) != null) {
            return mixin.postCreate(surface, insertType);
        }
        return true;
    }

    private void transferNamespaces(@NotNull NlComponent receiver) {
        if (receiver == null) {
            NlComponent.$$$reportNull$$$0(55);
        }
        XmlTag rootTag = this.getDocumentRoot();
        XmlTag tag = receiver.getTag();
        while (tag != null && tag != rootTag) {
            if (!tag.getLocalNamespaceDeclarations().isEmpty()) {
                receiver.transferLocalNamespaces();
            }
            tag = (receiver = receiver.getParent()) != null ? receiver.getTag() : null;
        }
        this.transferLocalNamespaces();
    }

    private void transferLocalNamespaces() {
        XmlTag rootTag = this.getDocumentRoot();
        if (rootTag == this) {
            return;
        }
        Map prefixToNamespace = rootTag.getLocalNamespaceDeclarations();
        HashMap namespaceToPrefix = Maps.newHashMap();
        for (Map.Entry entry : prefixToNamespace.entrySet()) {
            namespaceToPrefix.put(entry.getValue(), entry.getKey());
        }
        HashMap oldPrefixToPrefix = Maps.newHashMap();
        for (Map.Entry entry : this.getTag().getLocalNamespaceDeclarations().entrySet()) {
            String namespace = (String)entry.getValue();
            String prefix = (String)entry.getKey();
            String currentPrefix = (String)namespaceToPrefix.get(namespace);
            if (currentPrefix == null) {
                XmlFile file = this.getModel().getFile();
                String newPrefix = AndroidResourceUtil.ensureNamespaceImported(file, namespace, prefix);
                if (prefix.equals(newPrefix)) continue;
                oldPrefixToPrefix.put(prefix, newPrefix);
                namespaceToPrefix.put(namespace, newPrefix);
                continue;
            }
            if (prefix.equals(currentPrefix)) continue;
            oldPrefixToPrefix.put(prefix, currentPrefix);
        }
        if (!oldPrefixToPrefix.isEmpty()) {
            NlComponent.updatePrefixes(this.getTag(), oldPrefixToPrefix);
        }
        this.removeNamespaceAttributes();
    }

    @NotNull
    private XmlTag getDocumentRoot() {
        XmlFile file = this.getModel().getFile();
        XmlDocument xmlDocument = file.getDocument();
        assert (xmlDocument != null);
        XmlTag rootTag = xmlDocument.getRootTag();
        assert (rootTag != null);
        XmlTag xmlTag = rootTag;
        if (xmlTag == null) {
            NlComponent.$$$reportNull$$$0(56);
        }
        return xmlTag;
    }

    private static void updatePrefixes(@NotNull XmlTag tag, @NotNull Map<String, String> oldPrefixToPrefix) {
        if (tag == null) {
            NlComponent.$$$reportNull$$$0(57);
        }
        if (oldPrefixToPrefix == null) {
            NlComponent.$$$reportNull$$$0(58);
        }
        for (XmlAttribute xmlAttribute : tag.getAttributes()) {
            String newPrefix;
            String prefix = xmlAttribute.getNamespacePrefix();
            if (prefix.isEmpty()) continue;
            if (prefix.equals("xmlns")) {
                newPrefix = oldPrefixToPrefix.get(xmlAttribute.getLocalName());
                if (newPrefix == null) continue;
                xmlAttribute.setName("xmlns:" + newPrefix);
                continue;
            }
            newPrefix = oldPrefixToPrefix.get(prefix);
            if (newPrefix == null) continue;
            xmlAttribute.setName(newPrefix + ':' + xmlAttribute.getLocalName());
        }
        for (XmlAttribute xmlAttribute : tag.getSubTags()) {
            NlComponent.updatePrefixes((XmlTag)xmlAttribute, oldPrefixToPrefix);
        }
    }

    private void removeNamespaceAttributes() {
        for (XmlAttribute attribute : this.getTag().getAttributes()) {
            if (!attribute.getName().startsWith("xmlns:")) continue;
            attribute.delete();
        }
    }

    public Set<String> getDependencies() {
        XmlModelComponentMixin mixin = this.getMixin();
        if (mixin != null) {
            return mixin.getDependencies();
        }
        return ImmutableSet.of();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 47: 
            case 56: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 47: 
            case 56: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 15: 
            case 16: 
            case 18: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagPointer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mixin";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 47: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/model/NlComponent";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 37: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 39: 
            case 42: 
            case 44: 
            case 46: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 48: 
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dndComponent";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPrefixToPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/model/NlComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTag";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagPointer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "flatten";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findViewsByTag";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "startAttributeTransaction";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributesImpl";
                break;
            }
            case 36: 
            case 38: 
            case 40: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "assignId";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "generateId";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setMixin";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 47: 
            case 56: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setTag";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findViewByTag";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findViewsByTag";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setAttribute";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLiveAttribute";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAttribute";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeImpl";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "resolveAttribute";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "ensureNamespace";
                break;
            }
            case 37: 
            case 39: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "assignId";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "incrementId";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "generateId";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "moveTo";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "addTags";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "postCreateFromTransferrable";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "postCreate";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "transferNamespaces";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "updatePrefixes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 47: 
            case 56: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class XmlModelComponentMixin {
        private final NlComponent myComponent;

        public XmlModelComponentMixin(@NotNull NlComponent component) {
            if (component == null) {
                XmlModelComponentMixin.$$$reportNull$$$0(0);
            }
            this.myComponent = component;
        }

        @NotNull
        protected NlComponent getComponent() {
            NlComponent nlComponent = this.myComponent;
            if (nlComponent == null) {
                XmlModelComponentMixin.$$$reportNull$$$0(1);
            }
            return nlComponent;
        }

        @Nullable
        public String getAttribute(@Nullable String namespace, @NotNull String attribute) {
            if (attribute == null) {
                XmlModelComponentMixin.$$$reportNull$$$0(2);
            }
            return null;
        }

        public String toString() {
            return String.format("<%s>", this.myComponent.getTagName());
        }

        @Nullable
        public String getTooltipText() {
            return null;
        }

        public boolean canAddTo(@NotNull NlComponent receiver) {
            if (receiver == null) {
                XmlModelComponentMixin.$$$reportNull$$$0(3);
            }
            return true;
        }

        public Set<String> getDependencies() {
            return ImmutableSet.of();
        }

        public void beforeMove(@NotNull InsertType insertType, @NotNull NlComponent receiver, @NotNull Set<String> ids) {
            if (insertType == null) {
                XmlModelComponentMixin.$$$reportNull$$$0(4);
            }
            if (receiver == null) {
                XmlModelComponentMixin.$$$reportNull$$$0(5);
            }
            if (ids == null) {
                XmlModelComponentMixin.$$$reportNull$$$0(6);
            }
        }

        public void afterMove(@NotNull InsertType insertType, @Nullable NlComponent previousParent, @NotNull NlComponent receiver, @Nullable DesignSurface surface) {
            if (insertType == null) {
                XmlModelComponentMixin.$$$reportNull$$$0(7);
            }
            if (receiver == null) {
                XmlModelComponentMixin.$$$reportNull$$$0(8);
            }
        }

        public boolean postCreate(@Nullable DesignSurface surface, @NotNull InsertType insertType) {
            if (insertType == null) {
                XmlModelComponentMixin.$$$reportNull$$$0(9);
            }
            return true;
        }

        public void postCreateFromTransferrable(DnDTransferComponent dndComponent) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/common/model/NlComponent$XmlModelComponentMixin";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attribute";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiver";
                    break;
                }
                case 4: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insertType";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ids";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/common/model/NlComponent$XmlModelComponentMixin";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getAttribute";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "canAddTo";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "beforeMove";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "afterMove";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "postCreate";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

