/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.lint;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.tools.idea.common.lint.AttributeKey;
import com.android.tools.idea.common.lint.LintAnnotationsModel;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.lint.detector.api.Issue;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.android.inspections.lint.AndroidLintExternalAnnotator;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintUtil;
import org.jetbrains.android.inspections.lint.ProblemData;
import org.jetbrains.android.inspections.lint.State;
import org.jetbrains.annotations.NotNull;

public class LintHighlightingPass
implements HighlightingPass {
    private final DesignSurface mySurface;
    private LintAnnotationsModel myLintAnnotationsModel;

    public LintHighlightingPass(@NotNull DesignSurface surface) {
        if (surface == null) {
            LintHighlightingPass.$$$reportNull$$$0(0);
        }
        this.mySurface = surface;
    }

    public void collectInformation(@NotNull ProgressIndicator progress) {
        SceneView sceneView;
        if (progress == null) {
            LintHighlightingPass.$$$reportNull$$$0(1);
        }
        if ((sceneView = this.mySurface.getCurrentSceneView()) == null) {
            return;
        }
        this.myLintAnnotationsModel = LintHighlightingPass.getAnnotations(sceneView.getModel(), progress);
    }

    public void applyInformationToEditor() {
        SceneView sceneView = this.mySurface.getCurrentSceneView();
        if (sceneView == null || this.myLintAnnotationsModel == null) {
            return;
        }
        sceneView.getModel().setLintAnnotationsModel(this.myLintAnnotationsModel);
        this.mySurface.setLintAnnotationsModel(this.myLintAnnotationsModel);
        sceneView.getSurface().repaint();
    }

    @NotNull
    private static LintAnnotationsModel getAnnotations(@NotNull NlModel model, @NotNull ProgressIndicator progress) {
        if (model == null) {
            LintHighlightingPass.$$$reportNull$$$0(2);
        }
        if (progress == null) {
            LintHighlightingPass.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LintAnnotationsModel lintModel = new LintAnnotationsModel();
        XmlFile xmlFile = model.getFile();
        AndroidLintExternalAnnotator annotator = new AndroidLintExternalAnnotator();
        State state = annotator.collectInformation((PsiFile)xmlFile);
        if (state != null) {
            state = annotator.doAnnotate(state);
        }
        if (state == null) {
            LintAnnotationsModel lintAnnotationsModel = lintModel;
            if (lintAnnotationsModel == null) {
                LintHighlightingPass.$$$reportNull$$$0(4);
            }
            return lintAnnotationsModel;
        }
        for (ProblemData problemData : state.getProblems()) {
            AndroidLintInspectionBase inspection;
            NlComponent component;
            if (progress.isCanceled()) break;
            TextRange range = problemData.getTextRange();
            PsiElement startElement = xmlFile.findElementAt(range.getStartOffset());
            PsiElement endElement = xmlFile.findElementAt(range.getEndOffset());
            if (startElement == null || endElement == null || (component = model.findViewByPsi(startElement)) == null) continue;
            ResourceReference attribute = model.findAttributeByPsi(startElement);
            AttributeKey attributeKey = attribute != null ? new AttributeKey(component, attribute.getNamespace().getXmlNamespaceUri(), attribute.getName()) : null;
            Issue issue2 = problemData.getIssue();
            Pair<AndroidLintInspectionBase, HighlightDisplayLevel> pair = AndroidLintUtil.getHighlightLevelAndInspection(xmlFile.getProject(), issue2, (PsiElement)xmlFile);
            if (pair == null || (inspection = (AndroidLintInspectionBase)((Object)pair.getFirst())) == null) continue;
            HighlightDisplayLevel level = (HighlightDisplayLevel)pair.getSecond();
            HighlightDisplayKey key = HighlightDisplayKey.find((String)inspection.getShortName());
            if (key == null) continue;
            lintModel.addIssue(component, attributeKey, issue2, problemData.getMessage(), inspection, level, startElement, endElement, problemData.getQuickfixData());
        }
        LintAnnotationsModel lintAnnotationsModel = lintModel;
        if (lintAnnotationsModel == null) {
            LintHighlightingPass.$$$reportNull$$$0(5);
        }
        return lintAnnotationsModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/lint/LintHighlightingPass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/lint/LintHighlightingPass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectInformation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotations";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

