/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import com.android.tools.adtui.common.AdtSecondaryPanel;
import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueModel;
import com.android.tools.idea.common.error.IssueView;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.DesignSurface;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IssuePanel
extends JPanel
implements Disposable,
PropertyChangeListener {
    private static final String ISSUE_PANEL_NAME = "Layout Editor Error Panel";
    private static final String TITLE_NO_ISSUES = "No issues";
    private static final String TITLE_NO_IMPORTANT_ISSUE = "Issues";
    private static final String WARNING = "Warning";
    private static final String ERROR = "Error";
    private static final String ACTION_PREVIOUS = "PREVIOUS";
    private static final String ACTION_NEXT = "next";
    private static final String ACTION_EXPAND = "expand";
    private static final String ACTION_COLLAPSE = "collapse";
    private static final Pattern MULTIPLE_SPACES = Pattern.compile("\\s+");
    private final HashBiMap<Issue, IssueView> myDisplayedError;
    private final IssueModel myIssueModel;
    private final JPanel myErrorListPanel;
    private final JBLabel myTitleLabel;
    private final IssueModel.IssueModelListener myIssueModelListener;
    private final JBScrollPane myScrollPane;
    private final DesignSurface mySurface;
    private final ColumnHeaderPanel myColumnHeaderView;
    @Nullable
    private MinimizeListener myMinimizeListener;
    @Nullable
    private IssueView mySelectedIssueView;
    private boolean hasUserSeenNewErrors;
    private boolean isMinimized;

    public IssuePanel(@NotNull DesignSurface designSurface, @NotNull IssueModel issueModel) {
        if (designSurface == null) {
            IssuePanel.$$$reportNull$$$0(0);
        }
        if (issueModel == null) {
            IssuePanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myDisplayedError = HashBiMap.create();
        this.setName(ISSUE_PANEL_NAME);
        this.myIssueModel = issueModel;
        this.mySurface = designSurface;
        this.myTitleLabel = IssuePanel.createTitleLabel();
        JComponent titlePanel = this.createTitlePanel(this.myTitleLabel);
        this.add((Component)titlePanel, "North");
        this.myErrorListPanel = IssuePanel.createErrorListPanel();
        this.myScrollPane = IssuePanel.createListScrollPane(this.myErrorListPanel);
        this.myColumnHeaderView = new ColumnHeaderPanel();
        this.myScrollPane.setColumnHeaderView((Component)this.myColumnHeaderView);
        this.add((Component)this.myScrollPane, "Center");
        this.updateTitlebarStyle();
        this.myIssueModelListener = this::updateErrorList;
        this.myIssueModel.addErrorModelListener(this.myIssueModelListener);
        this.updateErrorList();
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.registerKeyboardActions();
        this.addFocusListener(this.createFocusListener());
        this.setMinimized(true);
        this.setMinimumSize((Dimension)JBUI.size((int)200));
        UIManager.addPropertyChangeListener(this);
    }

    @NotNull
    private FocusListener createFocusListener() {
        FocusListener focusListener2 = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (IssuePanel.this.mySelectedIssueView != null) {
                    IssuePanel.this.mySelectedIssueView.setFocused(true);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (IssuePanel.this.mySelectedIssueView != null) {
                    IssuePanel.this.mySelectedIssueView.setFocused(false);
                }
            }
        };
        if (focusListener2 == null) {
            IssuePanel.$$$reportNull$$$0(2);
        }
        return focusListener2;
    }

    private void registerKeyboardActions() {
        this.getActionMap().put(ACTION_PREVIOUS, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IssuePanel.this.keyboardSelect(-1);
            }
        });
        this.getActionMap().put(ACTION_NEXT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IssuePanel.this.keyboardSelect(1);
            }
        });
        this.getActionMap().put(ACTION_EXPAND, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IssuePanel.this.expandSelectedIssue(true);
            }
        });
        this.getActionMap().put(ACTION_COLLAPSE, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IssuePanel.this.expandSelectedIssue(false);
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(38, 0), ACTION_PREVIOUS);
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 0), ACTION_NEXT);
        this.getInputMap().put(KeyStroke.getKeyStroke(39, 0), ACTION_EXPAND);
        this.getInputMap().put(KeyStroke.getKeyStroke(37, 0), ACTION_COLLAPSE);
    }

    private void expandSelectedIssue(boolean expanded) {
        if (this.mySelectedIssueView != null) {
            this.mySelectedIssueView.setExpanded(expanded);
        }
    }

    private void keyboardSelect(int direction) {
        Component component;
        if (!this.myDisplayedError.isEmpty() && this.mySelectedIssueView == null && (component = this.myErrorListPanel.getComponent(0)) instanceof IssueView) {
            this.setSelectedIssue((IssueView)component);
            return;
        }
        Component[] components = this.myErrorListPanel.getComponents();
        for (int i2 = 0; i2 < components.length; ++i2) {
            Component component2 = components[i2];
            if (component2 != this.mySelectedIssueView) continue;
            int selectedIndex = (i2 + (direction >= 0 ? 1 : -1)) % this.myDisplayedError.size();
            if (selectedIndex < 0) {
                selectedIndex += this.myDisplayedError.size();
            }
            assert (components[i2] instanceof IssueView);
            this.setSelectedIssue((IssueView)components[selectedIndex]);
            this.mySelectedIssueView.scrollRectToVisible(this.mySelectedIssueView.getBounds());
            this.myScrollPane.getViewport().setViewPosition(this.mySelectedIssueView.getLocation());
            return;
        }
    }

    @NotNull
    private ActionToolbar createToolbar() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new MinimizeAction());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)actionGroup, true);
        toolbar.setLayoutPolicy(0);
        ActionToolbar actionToolbar = toolbar;
        if (actionToolbar == null) {
            IssuePanel.$$$reportNull$$$0(3);
        }
        return actionToolbar;
    }

    @NotNull
    private JComponent createTitlePanel(@NotNull JBLabel titleLabel) {
        if (titleLabel == null) {
            IssuePanel.$$$reportNull$$$0(4);
        }
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.add((Component)titleLabel, "West");
        JPanel rightPanel = new JPanel(new FlowLayout(2, 0, 0));
        rightPanel.add(this.createToolbar().getComponent());
        titlePanel.add((Component)rightPanel, "East");
        titlePanel.setBorder(IdeBorderFactory.createBorder((int)8));
        JPanel jPanel = titlePanel;
        if (jPanel == null) {
            IssuePanel.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @NotNull
    private static JBScrollPane createListScrollPane(@NotNull JPanel content) {
        if (content == null) {
            IssuePanel.$$$reportNull$$$0(6);
        }
        JBScrollPane pane = new JBScrollPane((Component)content);
        pane.setBorder(null);
        pane.setAlignmentX(0.5f);
        pane.getViewport().setBackground(content.getBackground());
        JBScrollPane jBScrollPane = pane;
        if (jBScrollPane == null) {
            IssuePanel.$$$reportNull$$$0(7);
        }
        return jBScrollPane;
    }

    @NotNull
    private static JPanel createErrorListPanel() {
        AdtSecondaryPanel panel2 = new AdtSecondaryPanel();
        panel2.setLayout(new BoxLayout((Container)panel2, 1));
        AdtSecondaryPanel adtSecondaryPanel = panel2;
        if (adtSecondaryPanel == null) {
            IssuePanel.$$$reportNull$$$0(8);
        }
        return adtSecondaryPanel;
    }

    @NotNull
    private static JBLabel createTitleLabel() {
        JBLabel label = new JBLabel(TITLE_NO_IMPORTANT_ISSUE, 2);
        label.setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)0, (int)20));
        JBLabel jBLabel = label;
        if (jBLabel == null) {
            IssuePanel.$$$reportNull$$$0(9);
        }
        return jBLabel;
    }

    private void updateErrorList() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (!this.myIssueModel.hasIssues()) {
                this.myTitleLabel.setText(TITLE_NO_ISSUES);
                this.myDisplayedError.clear();
                this.myErrorListPanel.removeAll();
                this.setMinimized(true);
                return;
            }
            this.updateTitlebarStyle();
            boolean needsRevalidate = false;
            ImmutableList<Issue> issues = this.myIssueModel.getIssues();
            if (this.myDisplayedError.isEmpty()) {
                issues.forEach(this::addErrorEntry);
            } else {
                this.removeOldIssues((List<Issue>)issues);
                needsRevalidate = this.displayNewIssues((List<Issue>)issues);
            }
            if (needsRevalidate) {
                this.revalidate();
                this.repaint();
            }
        });
    }

    private void updateTitlebarStyle() {
        this.myTitleLabel.setFont(this.myTitleLabel.getFont().deriveFont(!this.isMinimized() || this.hasUserSeenNewErrors ? 0 : 1));
        int warningCount = this.myIssueModel.getWarningCount();
        int errorCount = this.myIssueModel.getErrorCount();
        if (warningCount == 0 && errorCount == 0) {
            this.myTitleLabel.setText(TITLE_NO_IMPORTANT_ISSUE);
        } else {
            StringBuilder title = new StringBuilder();
            if (warningCount > 0) {
                title.append(warningCount).append(' ').append(StringUtil.pluralize((String)WARNING, (int)warningCount)).append(' ');
            }
            if (errorCount > 0) {
                title.append(errorCount).append(' ').append(StringUtil.pluralize((String)ERROR, (int)errorCount));
            }
            this.myTitleLabel.setText(title.toString());
        }
    }

    private boolean displayNewIssues(@NotNull List<Issue> issues) {
        if (issues == null) {
            IssuePanel.$$$reportNull$$$0(10);
        }
        boolean needsRevalidate = false;
        for (Issue error : issues) {
            if (this.myDisplayedError.containsKey((Object)error)) continue;
            this.addErrorEntry(error);
            needsRevalidate = true;
        }
        return needsRevalidate;
    }

    private void removeOldIssues(@NotNull List<Issue> newIssues) {
        if (newIssues == null) {
            IssuePanel.$$$reportNull$$$0(11);
        }
        Iterator iterator = this.myDisplayedError.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Issue issue2 = (Issue)entry.getKey();
            if (newIssues.contains(issue2)) continue;
            IssueView issueView = (IssueView)entry.getValue();
            this.myErrorListPanel.remove(issueView);
            iterator.remove();
        }
    }

    private void addErrorEntry(@NotNull Issue error) {
        if (error == null) {
            IssuePanel.$$$reportNull$$$0(12);
        }
        if (this.myErrorListPanel.getComponentCount() == 0) {
            this.myErrorListPanel.add(Box.createVerticalGlue(), -1);
        }
        IssueView issueView = new IssueView(error, this);
        this.myDisplayedError.put((Object)error, (Object)issueView);
        this.myErrorListPanel.add((Component)issueView, this.getInsertionIndex(issueView));
    }

    private int getInsertionIndex(IssueView issueView) {
        int insertIndex = 0;
        for (int i2 = 0; i2 < this.myErrorListPanel.getComponentCount(); ++i2) {
            Component component = this.myErrorListPanel.getComponent(i2);
            if (!(component instanceof IssueView)) continue;
            if (((IssueView)component).getDisplayPriority() > issueView.getDisplayPriority()) break;
            ++insertIndex;
        }
        return insertIndex;
    }

    @Nullable
    public IssueView getSelectedIssueView() {
        return this.mySelectedIssueView;
    }

    @Override
    public void doLayout() {
        int sourceColumnSize = 0;
        Set issueViews = this.myDisplayedError.values();
        IssueView lastView = null;
        for (IssueView view : issueViews) {
            sourceColumnSize = Math.max(sourceColumnSize, view.getSourceLabelWidth());
        }
        for (IssueView view : issueViews) {
            view.setSourceLabelSize(sourceColumnSize);
            lastView = view;
        }
        super.doLayout();
        if (lastView != null) {
            this.myColumnHeaderView.setColumnsX(lastView.getColumnsX());
        }
    }

    public void setMinimized(boolean minimized) {
        if (minimized == this.isMinimized) {
            return;
        }
        if (!minimized) {
            this.hasUserSeenNewErrors = true;
        }
        this.isMinimized = minimized;
        this.setVisible(!this.isMinimized);
        this.revalidate();
        this.repaint();
        if (this.myMinimizeListener != null) {
            UIUtil.invokeLaterIfNeeded(() -> this.myMinimizeListener.onMinimizeChanged(this.isMinimized));
        }
    }

    public void setMinimizeListener(@Nullable MinimizeListener listener2) {
        this.myMinimizeListener = listener2;
    }

    public void dispose() {
        this.myMinimizeListener = null;
        this.myIssueModel.removeErrorModelListener(this.myIssueModelListener);
        UIManager.removePropertyChangeListener(this);
    }

    public boolean isMinimized() {
        return this.isMinimized;
    }

    public void setSelectedIssue(@Nullable IssueView selectedIssue) {
        if (this.mySelectedIssueView != selectedIssue) {
            if (this.mySelectedIssueView != null) {
                this.mySelectedIssueView.setSelected(false);
            }
            this.mySelectedIssueView = selectedIssue;
            if (this.mySelectedIssueView != null) {
                this.mySelectedIssueView.setSelected(true);
                Issue issue2 = (Issue)this.myDisplayedError.inverse().get((Object)this.mySelectedIssueView);
                if (issue2 == null) {
                    return;
                }
                NlComponent source = issue2.getSource();
                if (source != null) {
                    this.mySurface.getSelectionModel().setSelection(Collections.singletonList(source));
                }
            }
        }
    }

    public String getTitleText() {
        return this.myTitleLabel.getText();
    }

    public IssueModel getIssueModel() {
        return this.myIssueModel;
    }

    public boolean containsErrorWithText(@NotNull String text) {
        if (text == null) {
            IssuePanel.$$$reportNull$$$0(13);
        }
        return this.myDisplayedError.values().stream().anyMatch(view -> view.getIssueTitle().contains(text) || MULTIPLE_SPACES.matcher(view.getIssueDescription()).replaceAll(" ").contains(text));
    }

    public void showIssueForComponent(NlComponent component, boolean collapseOthers) {
        Issue issue2 = this.myIssueModel.findIssue(component);
        if (issue2 != null) {
            IssueView issueView = (IssueView)this.myDisplayedError.get((Object)issue2);
            if (issueView != null) {
                this.setSelectedIssue(issueView);
                issueView.setExpanded(true);
                if (collapseOthers) {
                    for (IssueView other : this.myDisplayedError.values()) {
                        if (other == issueView) continue;
                        other.setExpanded(false);
                    }
                }
            }
            this.setMinimized(false);
            if (issueView != null) {
                JViewport viewport = this.myScrollPane.getViewport();
                viewport.validate();
                viewport.setViewPosition(issueView.getLocation());
            }
        }
    }

    public int getSuggestedHeight() {
        this.validate();
        int suggestedHeight = this.myTitleLabel.getHeight() + this.myColumnHeaderView.getHeight();
        suggestedHeight = this.mySelectedIssueView != null ? (suggestedHeight += this.mySelectedIssueView.getHeight()) : (suggestedHeight += this.myDisplayedError.size());
        return Math.max(this.getMinimumSize().height, suggestedHeight);
    }

    @NotNull
    ImmutableList<IssueView> getIssueViews() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Component component : this.myErrorListPanel.getComponents()) {
            if (!(component instanceof IssueView)) continue;
            builder.add((Object)((IssueView)component));
        }
        ImmutableList immutableList = builder.build();
        if (immutableList == null) {
            IssuePanel.$$$reportNull$$$0(14);
        }
        return immutableList;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("lookAndFeel".equals(evt.getPropertyName())) {
            this.myErrorListPanel.removeAll();
            this.myDisplayedError.clear();
            this.updateErrorList();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designSurface";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issueModel";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/error/IssuePanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titleLabel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issues";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newIssues";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/error/IssuePanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFocusListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTitlePanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createListScrollPane";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorListPanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTitleLabel";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssueViews";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTitlePanel";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createListScrollPane";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "displayNewIssues";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeOldIssues";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addErrorEntry";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "containsErrorWithText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ColumnHeaderPanel
    extends JPanel {
        private static final int HEIGHT = 15;
        private static final GradientPaint backgroundPaint = new GradientPaint(0.0f, 0.0f, (Color)new JBColor(0xFBFBFB, 5461850), 0.0f, 15.0f, (Color)new JBColor(0xE2E2E2, 3750717));
        public static final int COLUMN_COUNT = 2;
        private final JLabel myMessageLabel = ColumnHeaderPanel.createLabel("Message");
        private final JLabel mySourceLabel = ColumnHeaderPanel.createLabel("Source");
        private int[] myColumnsX;

        public ColumnHeaderPanel() {
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, JBColor.border()));
            this.mySourceLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, JBColor.border()), BorderFactory.createEmptyBorder(0, JBUIScale.scale((int)6), 0, 0)));
            this.add(this.myMessageLabel);
            this.add(this.mySourceLabel);
        }

        @NotNull
        private static JLabel createLabel(@Nullable String message) {
            JLabel label = new JLabel(message);
            label.setFont(label.getFont().deriveFont(JBUIScale.scale((float)11.0f)));
            JLabel jLabel = label;
            if (jLabel == null) {
                ColumnHeaderPanel.$$$reportNull$$$0(0);
            }
            return jLabel;
        }

        @Override
        public void doLayout() {
            super.doLayout();
            if (this.myColumnsX != null && this.myColumnsX.length == 2) {
                this.myMessageLabel.setLocation(this.myColumnsX[0], 0);
                int sourceLabelX = (int)Math.min((double)this.getWidth() * 0.9, (double)(this.myColumnsX[1] - this.mySourceLabel.getInsets().left));
                this.mySourceLabel.setLocation(sourceLabelX, 0);
            } else {
                this.myMessageLabel.setLocation(5, 0);
                this.mySourceLabel.setLocation((int)((double)this.getWidth() * 0.8), 0);
            }
        }

        @Override
        protected void paintComponent(@NotNull Graphics g) {
            if (g == null) {
                ColumnHeaderPanel.$$$reportNull$$$0(1);
            }
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            Paint paint = g2d.getPaint();
            g2d.setPaint(backgroundPaint);
            g2d.fill(this.getBounds());
            g2d.setPaint(paint);
        }

        @Override
        public Dimension getPreferredSize() {
            return JBUI.size((int)-1, (int)15);
        }

        private void setColumnsX(@NotNull int[] columnsX) {
            if (columnsX == null) {
                ColumnHeaderPanel.$$$reportNull$$$0(2);
            }
            this.myColumnsX = columnsX;
            this.revalidate();
            this.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/common/error/IssuePanel$ColumnHeaderPanel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnsX";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLabel";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/common/error/IssuePanel$ColumnHeaderPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "paintComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setColumnsX";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MinimizeAction
    extends AnAction {
        private static final String DESCRIPTION = "Hide the render errors panel";

        private MinimizeAction() {
            super(DESCRIPTION, DESCRIPTION, StudioIcons.Common.CLOSE);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MinimizeAction.$$$reportNull$$$0(0);
            }
            IssuePanel.this.setMinimized(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/common/error/IssuePanel$MinimizeAction", "actionPerformed"));
        }
    }

    public static interface MinimizeListener {
        public void onMinimizeChanged(boolean var1);
    }
}

