/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.repository.io.FileOp;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkinLayoutDefinition {
    static final Pattern ourQuerySeparator = Pattern.compile("\\.");
    static final Pattern ourWhitespacePattern = Pattern.compile("\\s+");
    private Map<String, String> myProperties = Maps.newHashMap();
    private Map<String, SkinLayoutDefinition> myChildren = Maps.newHashMap();

    @Nullable
    public static SkinLayoutDefinition parseFile(@NotNull File file, @NotNull FileOp fop) {
        String contents;
        if (file == null) {
            SkinLayoutDefinition.$$$reportNull$$$0(0);
        }
        if (fop == null) {
            SkinLayoutDefinition.$$$reportNull$$$0(1);
        }
        try {
            contents = fop.toString(file, Charsets.UTF_8);
        }
        catch (IOException e) {
            return null;
        }
        return SkinLayoutDefinition.loadFromTokens(Splitter.on((Pattern)ourWhitespacePattern).omitEmptyStrings().trimResults().split((CharSequence)contents).iterator());
    }

    static SkinLayoutDefinition loadFromTokens(Iterator<String> tokens) {
        String key;
        SkinLayoutDefinition definition = new SkinLayoutDefinition();
        while (tokens.hasNext() && !(key = tokens.next()).equals("}")) {
            String value2 = tokens.next();
            if (value2.equals("{")) {
                definition.myChildren.put(key, SkinLayoutDefinition.loadFromTokens(tokens));
                continue;
            }
            definition.myProperties.put(key, value2);
        }
        return definition;
    }

    private SkinLayoutDefinition() {
    }

    @Nullable
    public String get(@NotNull String queryString) {
        if (queryString == null) {
            SkinLayoutDefinition.$$$reportNull$$$0(2);
        }
        return this.get(Splitter.on((Pattern)ourQuerySeparator).split((CharSequence)queryString).iterator());
    }

    @Nullable
    private String get(@NotNull Iterator<String> queryIterator) {
        if (queryIterator == null) {
            SkinLayoutDefinition.$$$reportNull$$$0(3);
        }
        if (!queryIterator.hasNext()) {
            return null;
        }
        String key = queryIterator.next();
        if (!queryIterator.hasNext()) {
            return this.myProperties.get(key);
        }
        SkinLayoutDefinition child = this.myChildren.get(key);
        if (child != null) {
            return child.get(queryIterator);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.makeString(sb, 1);
        return sb.toString();
    }

    private void makeString(@NotNull StringBuilder sb, int depth) {
        if (sb == null) {
            SkinLayoutDefinition.$$$reportNull$$$0(4);
        }
        sb.append("{\n");
        for (String key : SkinLayoutDefinition.sort(this.myProperties.keySet())) {
            SkinLayoutDefinition.appendSpace(sb, depth);
            sb.append(key);
            sb.append("    ");
            sb.append(this.myProperties.get(key));
            sb.append("\n");
        }
        for (String key : SkinLayoutDefinition.sort(this.myChildren.keySet())) {
            SkinLayoutDefinition.appendSpace(sb, depth);
            sb.append(key);
            sb.append("    ");
            this.myChildren.get(key).makeString(sb, depth + 1);
        }
        SkinLayoutDefinition.appendSpace(sb, depth - 1);
        sb.append("}\n");
    }

    private static List<String> sort(Set<String> set) {
        ArrayList<String> list = new ArrayList<String>(set);
        Collections.sort(list);
        return list;
    }

    private static void appendSpace(@NotNull StringBuilder sb, int depth) {
        if (sb == null) {
            SkinLayoutDefinition.$$$reportNull$$$0(5);
        }
        for (int i2 = 0; i2 < depth; ++i2) {
            sb.append("  ");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fop";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryString";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryIterator";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/avdmanager/SkinLayoutDefinition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "makeString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "appendSpace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

