/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class EmulatorProcessHandler
extends BaseOSProcessHandler {
    private static final Logger LOG = Logger.getInstance(EmulatorProcessHandler.class);
    @NotNull
    private final Process myProcess;
    @NotNull
    private final GeneralCommandLine myCommandLine;
    @NotNull
    private final ConsoleListner myConsoleListner;

    public EmulatorProcessHandler(@NotNull Process process, @NotNull GeneralCommandLine commandLine) {
        if (process == null) {
            EmulatorProcessHandler.$$$reportNull$$$0(0);
        }
        if (commandLine == null) {
            EmulatorProcessHandler.$$$reportNull$$$0(1);
        }
        super(process, commandLine.getCommandLineString(), null);
        this.myProcess = process;
        this.myCommandLine = commandLine;
        this.myConsoleListner = new ConsoleListner();
        this.addProcessListener((ProcessListener)this.myConsoleListner);
        ProcessTerminatedListener.attach((ProcessHandler)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "process";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "commandLine";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/avdmanager/EmulatorProcessHandler";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ConsoleListner
    extends ProcessAdapter {
        private ConsoleListner() {
        }

        public void onTextAvailable(ProcessEvent event, Key outputType) {
            boolean hasError;
            String text = event.getText();
            String content = String.format("%s: %s", AndroidBundle.message("android.emulator", new Object[0]), text.trim());
            if (ProcessOutputTypes.SYSTEM.equals((Object)outputType) && EmulatorProcessHandler.this.isProcessTerminated()) {
                Integer exitCode = EmulatorProcessHandler.this.getExitCode();
                if (exitCode != null) {
                    Notification notification = new Notification(AndroidBundle.message("android.emulator", new Object[0]), "", content, exitCode == 0 ? NotificationType.INFORMATION : NotificationType.ERROR);
                    Notifications.Bus.notify((Notification)notification);
                }
                return;
            }
            boolean bl = hasError = text != null && StringUtil.toLowerCase((String)text).contains("error");
            if (hasError || ProcessOutputTypes.STDERR.equals((Object)outputType)) {
                Notification notification = new Notification(AndroidBundle.message("android.emulator", new Object[0]), "", content, NotificationType.ERROR);
                Notifications.Bus.notify((Notification)notification);
            }
        }
    }
}

