/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Shell32;
import com.sun.jna.platform.win32.ShellAPI;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ElevatedCommandLine
extends GeneralCommandLine {
    private static final int SEE_MASK_NO_CLOSE_PROCESS = 64;
    private static final int INFINITE = -1;
    private String myTempFilePrefix;

    public ElevatedCommandLine(String ... command) {
        if (command == null) {
            ElevatedCommandLine.$$$reportNull$$$0(0);
        }
        super(command);
        this.myTempFilePrefix = "temp";
    }

    public ElevatedCommandLine withTempFilePrefix(@NotNull String tempFilePrefix) {
        if (tempFilePrefix == null) {
            ElevatedCommandLine.$$$reportNull$$$0(1);
        }
        this.myTempFilePrefix = tempFilePrefix;
        return this;
    }

    @NotNull
    protected Process startProcess(@NotNull List<String> commands) throws IOException {
        if (commands == null) {
            ElevatedCommandLine.$$$reportNull$$$0(2);
        }
        if (SystemInfo.isWin7OrNewer) {
            Process process = this.executeAsShellCommand();
            if (process == null) {
                ElevatedCommandLine.$$$reportNull$$$0(3);
            }
            return process;
        }
        Process process = super.startProcess(commands);
        if (process == null) {
            ElevatedCommandLine.$$$reportNull$$$0(4);
        }
        return process;
    }

    private Process executeAsShellCommand() throws IOException {
        String exeName = new File(this.getExePath()).getName();
        File wrapper = FileUtil.createTempFile((String)(FileUtilRt.getNameWithoutExtension((String)exeName) + "_wrapper"), (String)".bat", (boolean)true);
        String exePath = new File(this.getExePath()).getParent();
        FileUtil.writeToFile((File)wrapper, (String)String.format("@echo off\nsetlocal enableextensions\n\ncd /d \"%1$s\"\n\n%2$s %%*", exePath, exeName));
        this.setExePath(wrapper.getPath());
        File outFile = FileUtil.createTempFile((String)(this.myTempFilePrefix + "_out"), (String)".txt", (boolean)true);
        File errFile = FileUtil.createTempFile((String)(this.myTempFilePrefix + "_err"), (String)".txt", (boolean)true);
        this.addParameters(new String[]{">", outFile.getPath(), "2>", errFile.getPath()});
        ShellAPI.SHELLEXECUTEINFO info = new ShellAPI.SHELLEXECUTEINFO();
        info.cbSize = info.size();
        info.lpFile = this.getExePath();
        info.lpVerb = "runas";
        info.lpParameters = this.getParametersList().getParametersString();
        info.lpDirectory = this.getWorkDirectory().getPath();
        info.nShow = 0;
        info.fMask = 64;
        boolean returnValue = Shell32.INSTANCE.ShellExecuteEx(info);
        int errorCode = returnValue ? 0 : Kernel32.INSTANCE.GetLastError();
        return new ProcessWrapper(info.hProcess, errorCode, outFile, errFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempFilePrefix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/avdmanager/ElevatedCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/avdmanager/ElevatedCommandLine";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "withTempFilePrefix";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ProcessWrapper
    extends Process {
        private WinNT.HANDLE myProcess;
        private final IntByReference myExitCode;
        private final File myOutFile;
        private final File myErrFile;

        private ProcessWrapper(@NotNull WinNT.HANDLE hProcess, int errorCode, @NotNull File outFile, @NotNull File errFile) {
            if (hProcess == null) {
                ProcessWrapper.$$$reportNull$$$0(0);
            }
            if (outFile == null) {
                ProcessWrapper.$$$reportNull$$$0(1);
            }
            if (errFile == null) {
                ProcessWrapper.$$$reportNull$$$0(2);
            }
            this.myProcess = hProcess;
            this.myExitCode = new IntByReference(errorCode);
            this.myOutFile = outFile;
            this.myErrFile = errFile;
        }

        @Override
        public OutputStream getOutputStream() {
            throw new RuntimeException("Unexpected behaviour");
        }

        @Override
        public InputStream getInputStream() {
            return this.toInputStream(this.myOutFile);
        }

        @Override
        public InputStream getErrorStream() {
            return this.toInputStream(this.myErrFile);
        }

        @Override
        public int waitFor() {
            if (this.myProcess != null) {
                Kernel32.INSTANCE.WaitForSingleObject(this.myProcess, -1);
                Kernel32.INSTANCE.GetExitCodeProcess(this.myProcess, this.myExitCode);
                Kernel32.INSTANCE.CloseHandle(this.myProcess);
                this.myProcess = null;
            }
            return this.myExitCode.getValue();
        }

        @Override
        public int exitValue() {
            return this.waitFor();
        }

        @Override
        public void destroy() {
            this.waitFor();
        }

        private InputStream toInputStream(@NotNull File file) {
            if (file == null) {
                ProcessWrapper.$$$reportNull$$$0(3);
            }
            try {
                this.waitFor();
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hProcess";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errFile";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/avdmanager/ElevatedCommandLine$ProcessWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toInputStream";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

