/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.devices.DeviceParser;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.utils.ILogger;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceManagerConnection {
    private static final Logger IJ_LOG = Logger.getInstance(AvdManagerConnection.class);
    private static final ILogger SDK_LOG = new LogWrapper(IJ_LOG).alwaysLogAsDebug(true).allowVerbose(false);
    private static final DeviceManagerConnection NULL_CONNECTION = new DeviceManagerConnection(null);
    private static Map<File, DeviceManagerConnection> ourCache = ContainerUtil.createWeakMap();
    private DeviceManager ourDeviceManager;
    @Nullable
    private File mySdkPath;

    public DeviceManagerConnection(@Nullable File sdkPath) {
        this.mySdkPath = sdkPath;
    }

    @NotNull
    public static DeviceManagerConnection getDeviceManagerConnection(@NotNull File sdkPath) {
        if (sdkPath == null) {
            DeviceManagerConnection.$$$reportNull$$$0(0);
        }
        if (!ourCache.containsKey(sdkPath)) {
            ourCache.put(sdkPath, new DeviceManagerConnection(sdkPath));
        }
        DeviceManagerConnection deviceManagerConnection = ourCache.get(sdkPath);
        if (deviceManagerConnection == null) {
            DeviceManagerConnection.$$$reportNull$$$0(1);
        }
        return deviceManagerConnection;
    }

    @NotNull
    public static DeviceManagerConnection getDefaultDeviceManagerConnection() {
        File sdkPath = AndroidSdks.getInstance().tryToChooseSdkHandler().getLocation();
        if (sdkPath != null) {
            DeviceManagerConnection deviceManagerConnection = DeviceManagerConnection.getDeviceManagerConnection(sdkPath);
            if (deviceManagerConnection == null) {
                DeviceManagerConnection.$$$reportNull$$$0(2);
            }
            return deviceManagerConnection;
        }
        DeviceManagerConnection deviceManagerConnection = NULL_CONNECTION;
        if (deviceManagerConnection == null) {
            DeviceManagerConnection.$$$reportNull$$$0(3);
        }
        return deviceManagerConnection;
    }

    private boolean initIfNecessary() {
        if (this.ourDeviceManager == null) {
            if (this.mySdkPath == null) {
                IJ_LOG.error("No installed SDK found!");
                return false;
            }
            this.ourDeviceManager = DeviceManager.createInstance((File)this.mySdkPath, (ILogger)SDK_LOG);
        }
        return true;
    }

    @NotNull
    public List<Device> getDevices() {
        if (!this.initIfNecessary()) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                DeviceManagerConnection.$$$reportNull$$$0(4);
            }
            return immutableList;
        }
        ArrayList arrayList = Lists.newArrayList((Iterable)this.ourDeviceManager.getDevices(DeviceManager.ALL_DEVICES));
        if (arrayList == null) {
            DeviceManagerConnection.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Nullable
    public Device getDevice(@NotNull String id, @NotNull String manufacturer) {
        if (id == null) {
            DeviceManagerConnection.$$$reportNull$$$0(6);
        }
        if (manufacturer == null) {
            DeviceManagerConnection.$$$reportNull$$$0(7);
        }
        if (!this.initIfNecessary()) {
            return null;
        }
        return this.ourDeviceManager.getDevice(id, manufacturer);
    }

    @NotNull
    public String getUniqueId(@Nullable String id) {
        String baseId;
        String string = baseId = id == null ? "New Device" : id;
        if (!this.initIfNecessary()) {
            String string2 = baseId;
            if (string2 == null) {
                DeviceManagerConnection.$$$reportNull$$$0(8);
            }
            return string2;
        }
        Collection devices = this.ourDeviceManager.getDevices(DeviceManager.DeviceFilter.USER);
        String candidate = baseId;
        int i2 = 0;
        while (DeviceManagerConnection.anyIdMatches(candidate, devices)) {
            candidate = String.format(Locale.getDefault(), "%s %d", baseId, ++i2);
        }
        String string3 = candidate;
        if (string3 == null) {
            DeviceManagerConnection.$$$reportNull$$$0(9);
        }
        return string3;
    }

    private static boolean anyIdMatches(@NotNull String id, @NotNull Collection<Device> devices) {
        if (id == null) {
            DeviceManagerConnection.$$$reportNull$$$0(10);
        }
        if (devices == null) {
            DeviceManagerConnection.$$$reportNull$$$0(11);
        }
        for (Device d : devices) {
            if (!id.equalsIgnoreCase(d.getId())) continue;
            return true;
        }
        return false;
    }

    public void deleteDevice(@Nullable Device info) {
        if (info != null) {
            if (!this.initIfNecessary()) {
                return;
            }
            this.ourDeviceManager.removeUserDevice(info);
            this.ourDeviceManager.saveUserDevices();
        }
    }

    public void createOrEditDevice(@NotNull Device device) {
        if (device == null) {
            DeviceManagerConnection.$$$reportNull$$$0(12);
        }
        if (!this.initIfNecessary()) {
            return;
        }
        this.ourDeviceManager.replaceUserDevice(device);
        this.ourDeviceManager.saveUserDevices();
    }

    public void createDevices(@NotNull List<Device> devices) {
        if (devices == null) {
            DeviceManagerConnection.$$$reportNull$$$0(13);
        }
        if (!this.initIfNecessary()) {
            return;
        }
        for (Device device : devices) {
            String deviceIdBase = device.getId();
            String deviceNameBase = device.getDisplayName();
            int i2 = 2;
            while (this.isUserDevice(device)) {
                String id = String.format(Locale.getDefault(), "%1$s_%2$d", deviceIdBase, i2);
                String name = String.format(Locale.getDefault(), "%1$s_%2$d", deviceNameBase, i2);
                device = DeviceManagerConnection.cloneDeviceWithNewIdAndName(device, id, name);
            }
            this.ourDeviceManager.addUserDevice(device);
        }
        this.ourDeviceManager.saveUserDevices();
    }

    private static Device cloneDeviceWithNewIdAndName(@NotNull Device device, @NotNull String id, @NotNull String name) {
        if (device == null) {
            DeviceManagerConnection.$$$reportNull$$$0(14);
        }
        if (id == null) {
            DeviceManagerConnection.$$$reportNull$$$0(15);
        }
        if (name == null) {
            DeviceManagerConnection.$$$reportNull$$$0(16);
        }
        Device.Builder builder = new Device.Builder(device);
        builder.setId(id);
        builder.setName(name);
        return builder.build();
    }

    public boolean isUserDevice(final @NotNull Device device) {
        if (device == null) {
            DeviceManagerConnection.$$$reportNull$$$0(17);
        }
        if (!this.initIfNecessary()) {
            return false;
        }
        return Iterables.any((Iterable)this.ourDeviceManager.getDevices(DeviceManager.DeviceFilter.USER), (Predicate)new Predicate<Device>(){

            public boolean apply(Device input) {
                return device.getId().equalsIgnoreCase(input.getId());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Device> getDevicesFromFile(@NotNull File xmlFile) {
        if (xmlFile == null) {
            DeviceManagerConnection.$$$reportNull$$$0(18);
        }
        FileInputStream stream = null;
        ArrayList list = Lists.newArrayList();
        try {
            stream = new FileInputStream(xmlFile);
            list.addAll(DeviceParser.parse((InputStream)stream).values());
        }
        catch (IllegalStateException e) {
            IJ_LOG.error((Throwable)e);
        }
        catch (Exception e) {
            IJ_LOG.error("Error reading devices", (Throwable)e);
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e) {}
            }
        }
        return list;
    }

    /*
     * Exception decompiling
     */
    public static void writeDevicesToFile(@NotNull List<Device> devices, @NotNull File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/avdmanager/DeviceManagerConnection";
                break;
            }
            case 6: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manufacturer";
                break;
            }
            case 11: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devices";
                break;
            }
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/avdmanager/DeviceManagerConnection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceManagerConnection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultDeviceManagerConnection";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevices";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDeviceManagerConnection";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDevice";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "anyIdMatches";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createOrEditDevice";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createDevices";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "cloneDeviceWithNewIdAndName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isUserDevice";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDevicesFromFile";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "writeDevicesToFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

