/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.dex;

import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.apk.analyzer.FilteredTreeModel;
import com.android.tools.apk.analyzer.dex.DexFileStats;
import com.android.tools.apk.analyzer.dex.DexFiles;
import com.android.tools.apk.analyzer.dex.DexReferences;
import com.android.tools.apk.analyzer.dex.DexViewFilters;
import com.android.tools.apk.analyzer.dex.PackageTreeCreator;
import com.android.tools.apk.analyzer.dex.ProguardMappings;
import com.android.tools.apk.analyzer.dex.tree.DexElementNode;
import com.android.tools.apk.analyzer.dex.tree.DexPackageNode;
import com.android.tools.apk.analyzer.internal.ProguardMappingFiles;
import com.android.tools.idea.apk.viewer.ApkFileEditorComponent;
import com.android.tools.idea.apk.viewer.ApkViewPanel;
import com.android.tools.idea.apk.viewer.dex.DexNodeIcons;
import com.android.tools.idea.apk.viewer.dex.GenerateProguardKeepRuleAction;
import com.android.tools.idea.apk.viewer.dex.SelectProguardMapsDialog;
import com.android.tools.idea.apk.viewer.dex.ShowDisassemblyAction;
import com.android.tools.idea.apk.viewer.dex.ShowReferencesAction;
import com.android.tools.idea.concurrent.EdtExecutor;
import com.android.tools.proguard.ProguardMap;
import com.android.tools.proguard.ProguardSeedsMap;
import com.android.tools.proguard.ProguardUsagesMap;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;

public class DexFileViewer
implements ApkFileEditorComponent {
    private final Disposable myDisposable;
    private final JBLoadingPanel myLoadingPanel;
    private final Tree myTree;
    private final JPanel myTopPanel;
    @NotNull
    private final Path[] myDexFiles;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myApkFolder;
    @NotNull
    private final DexViewFilters myDexFilters;
    private final DexTreeNodeRenderer myDexTreeRenderer;
    @Nullable
    private ProguardMappings myProguardMappings;
    private boolean myDeobfuscateNames;
    private ListenableFuture<DexReferences> myDexReferences;
    @NotNull
    public static final NotificationGroup LOGGING_NOTIFICATION = NotificationGroup.logOnlyGroup((String)"APK Analyzer (Info)");
    @NotNull
    public static final NotificationGroup BALLOON_NOTIFICATION = NotificationGroup.balloonGroup((String)"APK Analyzer (Important)");

    public DexFileViewer(@NotNull Project project, @NotNull Path[] dexFiles, @NotNull VirtualFile apkFolder) {
        if (project == null) {
            DexFileViewer.$$$reportNull$$$0(0);
        }
        if (dexFiles == null) {
            DexFileViewer.$$$reportNull$$$0(1);
        }
        if (apkFolder == null) {
            DexFileViewer.$$$reportNull$$$0(2);
        }
        this.myDexFiles = dexFiles;
        this.myProject = project;
        this.myApkFolder = apkFolder;
        this.myDisposable = new Disposable(){

            public void dispose() {
            }
        };
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.myDisposable);
        this.myLoadingPanel.startLoading();
        this.myTree = new Tree((TreeModel)new DefaultTreeModel((TreeNode)new LoadingNode()));
        this.myTree.setRootVisible(true);
        this.myTree.setShowsRootHandles(true);
        new TreeSpeedSearch(this.myTree, path -> {
            Object o = path.getLastPathComponent();
            if (!(o instanceof DexElementNode)) {
                return "";
            }
            DexElementNode node = (DexElementNode)o;
            return node.getName();
        }, true);
        this.myDexTreeRenderer = new DexTreeNodeRenderer();
        ColumnTreeBuilder builder = new ColumnTreeBuilder((JTree)this.myTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Class").setPreferredWidth(500).setHeaderAlignment(2).setComparator(Comparator.comparing(DexElementNode::getName).reversed()).setRenderer((ColoredTreeCellRenderer)this.myDexTreeRenderer)).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Defined Methods").setPreferredWidth(100).setHeaderAlignment(2).setComparator(Comparator.comparing(DexElementNode::getMethodDefinitionsCount)).setRenderer((ColoredTreeCellRenderer)new MethodCountRenderer(true))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Referenced Methods").setPreferredWidth(100).setHeaderAlignment(2).setComparator(Comparator.comparing(DexElementNode::getMethodReferencesCount)).setRenderer((ColoredTreeCellRenderer)new MethodCountRenderer(false))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Size").setPreferredWidth(50).setHeaderAlignment(2).setComparator(Comparator.comparing(DexElementNode::getSize)).setRenderer((ColoredTreeCellRenderer)new SizeRenderer()));
        builder.setTreeSorter((comparator2, order) -> {
            if (comparator2 != null) {
                TreeModel model = this.myTree.getModel();
                TreePath selectionPath = this.myTree.getSelectionPath();
                Object root = model.getRoot();
                if (root instanceof DexElementNode) {
                    ((DexElementNode)root).sort(comparator2.reversed());
                }
                if (model instanceof DefaultTreeModel) {
                    ((DefaultTreeModel)model).reload();
                }
                this.myTree.setSelectionPath(selectionPath);
                this.myTree.scrollPathToVisible(selectionPath);
            }
        });
        JComponent columnTree = builder.build();
        this.myLoadingPanel.add((Component)columnTree, (Object)"Center");
        this.myTopPanel = new JPanel(new BorderLayout());
        this.myLoadingPanel.add((Component)this.myTopPanel, (Object)"North");
        this.myDexFilters = new DexViewFilters();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new ShowFieldsAction(this.myTree, this.myDexFilters));
        actionGroup.add((AnAction)new ShowMethodsAction(this.myTree, this.myDexFilters));
        actionGroup.add((AnAction)new ShowReferencedAction(this.myTree, this.myDexFilters));
        actionGroup.addSeparator();
        actionGroup.add((AnAction)new ShowRemovedNodesAction(this.myTree, this.myDexFilters));
        actionGroup.add((AnAction)new DeobfuscateNodesAction());
        actionGroup.add((AnAction)new LoadProguardAction());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)actionGroup, true);
        this.myTopPanel.add((Component)toolbar.getComponent(), "West");
        ActionGroup group = this.createPopupActionGroup(this.myTree);
        PopupHandler.installPopupHandler((JComponent)this.myTree, (ActionGroup)group, (String)"unknown", (ActionManager)ActionManager.getInstance());
        this.initDex();
    }

    @NotNull
    private ActionGroup createPopupActionGroup(@NotNull Tree tree) {
        if (tree == null) {
            DexFileViewer.$$$reportNull$$$0(3);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ShowDisassemblyAction(tree));
        group.add((AnAction)new ShowReferencesAction(tree, this));
        group.add((AnAction)new GenerateProguardKeepRuleAction(tree));
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            DexFileViewer.$$$reportNull$$$0(4);
        }
        return defaultActionGroup;
    }

    public void selectProguardMapping() {
        SelectProguardMapsDialog dialog = new SelectProguardMapsDialog(this.myProject, this.myApkFolder);
        try {
            if (!dialog.showAndGet()) {
                return;
            }
            ProguardMappingFiles mappingFiles = dialog.getMappingFiles();
            ArrayList<String> loaded = new ArrayList<String>(3);
            ArrayList<String> errors = new ArrayList<String>(3);
            Path mappingFile = mappingFiles.mappingFile;
            ProguardMap proguardMap = new ProguardMap();
            if (mappingFile != null) {
                try {
                    proguardMap.readFromReader((Reader)new InputStreamReader(Files.newInputStream(mappingFile, new OpenOption[0]), Charsets.UTF_8));
                    loaded.add(mappingFile.getFileName().toString());
                }
                catch (IOException | ParseException e) {
                    errors.add(mappingFile.getFileName().toString());
                    proguardMap = null;
                }
            }
            Path seedsFile = mappingFiles.seedsFile;
            ProguardSeedsMap seeds = null;
            if (seedsFile != null) {
                try {
                    seeds = ProguardSeedsMap.parse((Reader)new InputStreamReader(Files.newInputStream(seedsFile, new OpenOption[0]), Charsets.UTF_8));
                    loaded.add(seedsFile.getFileName().toString());
                }
                catch (IOException e) {
                    errors.add(seedsFile.getFileName().toString());
                }
            }
            if ((this.myProguardMappings == null || this.myProguardMappings.map == null) && proguardMap != null) {
                this.myDeobfuscateNames = true;
            }
            Path usageFile = mappingFiles.usageFile;
            ProguardUsagesMap usage = null;
            if (usageFile != null) {
                try {
                    usage = ProguardUsagesMap.parse((Reader)new InputStreamReader(Files.newInputStream(usageFile, new OpenOption[0]), Charsets.UTF_8));
                    loaded.add(usageFile.getFileName().toString());
                }
                catch (IOException e) {
                    errors.add(usageFile.getFileName().toString());
                }
            }
            ProguardMappings proguardMappings = this.myProguardMappings = loaded.isEmpty() ? null : new ProguardMappings(proguardMap, seeds, usage);
            if (errors.isEmpty() && loaded.isEmpty()) {
                BALLOON_NOTIFICATION.createNotification("APK Analyzer couldn't find any ProGuard mapping files. The filenames must match one of: mapping.txt, seeds.txt, usage.txt", MessageType.ERROR).notify(this.myProject);
            } else if (errors.isEmpty()) {
                LOGGING_NOTIFICATION.createNotification("APK Analyzer successfully loaded maps from: " + StringUtil.join(loaded, (String)", "), MessageType.INFO).notify(this.myProject);
            } else {
                BALLOON_NOTIFICATION.createNotification("APK Analyzer successfully loaded maps from: " + StringUtil.join(loaded, (String)",") + "\nThere were problems loading: " + StringUtil.join(errors, (String)", "), MessageType.WARNING).notify(this.myProject);
            }
            this.myDexTreeRenderer.setMappings(this.myProguardMappings);
            this.initDex();
        }
        catch (IOException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)"Error Loading Mappings...");
        }
    }

    public void initDex() {
        ListeningExecutorService pooledThreadExecutor = MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE);
        ListenableFuture dexFileFuture = pooledThreadExecutor.submit(() -> {
            HashMap dexFiles = Maps.newHashMapWithExpectedSize((int)this.myDexFiles.length);
            for (int i2 = 0; i2 < this.myDexFiles.length; ++i2) {
                dexFiles.put(this.myDexFiles[i2], DexFiles.getDexFile((Path)this.myDexFiles[i2]));
            }
            return dexFiles;
        });
        ListenableFuture treeNodeFuture = Futures.transform((ListenableFuture)dexFileFuture, (Function)new Function<Map<Path, DexBackedDexFile>, DexPackageNode>(){

            @NotNull
            public DexPackageNode apply(@Nullable Map<Path, DexBackedDexFile> input) {
                assert (input != null);
                PackageTreeCreator treeCreator = new PackageTreeCreator(DexFileViewer.this.myProguardMappings, DexFileViewer.this.myDeobfuscateNames);
                DexPackageNode dexPackageNode = treeCreator.constructPackageTree(input);
                if (dexPackageNode == null) {
                    2.$$$reportNull$$$0(0);
                }
                return dexPackageNode;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/dex/DexFileViewer$2", "apply"));
            }
        }, (Executor)pooledThreadExecutor);
        Futures.addCallback((ListenableFuture)treeNodeFuture, (FutureCallback)new FutureCallback<DexPackageNode>(){

            public void onSuccess(DexPackageNode result2) {
                DexFileViewer.this.myLoadingPanel.stopLoading();
                DexFileViewer.this.myTree.setRootVisible(false);
                FilteredTreeModel treeModel = new FilteredTreeModel((TreeNode)result2, (Predicate)DexFileViewer.this.myDexFilters);
                DexFileViewer.this.myTree.setModel((TreeModel)treeModel);
                treeModel.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

                    protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                        Enumeration expanded;
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (type == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if ((expanded = DexFileViewer.this.myTree.getExpandedDescendants(new TreePath(DexFileViewer.this.myTree.getModel().getRoot()))) == null) {
                            return;
                        }
                        ApplicationManager.getApplication().invokeLater(() -> {
                            for (TreePath path : Collections.list(expanded)) {
                                DexFileViewer.this.myTree.expandPath(path);
                            }
                        });
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "type";
                                break;
                            }
                        }
                        objectArray[1] = "com/android/tools/idea/apk/viewer/dex/DexFileViewer$3$1";
                        objectArray[2] = "process";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    3.$$$reportNull$$$0(0);
                }
                DexFileViewer.this.myLoadingPanel.stopLoading();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/apk/viewer/dex/DexFileViewer$3", "onFailure"));
            }
        }, (Executor)EdtExecutor.INSTANCE);
        ListenableFuture dexStatsFuture = Futures.transform((ListenableFuture)dexFileFuture, (Function)new Function<Map<Path, DexBackedDexFile>, DexFileStats>(){

            @NotNull
            public DexFileStats apply(@Nullable Map<Path, DexBackedDexFile> input) {
                assert (input != null);
                DexFileStats dexFileStats = DexFileStats.create(input.values());
                if (dexFileStats == null) {
                    4.$$$reportNull$$$0(0);
                }
                return dexFileStats;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/dex/DexFileViewer$4", "apply"));
            }
        }, (Executor)pooledThreadExecutor);
        if (((BorderLayout)this.myTopPanel.getLayout()).getLayoutComponent("East") == null) {
            final SimpleColoredComponent titleComponent = new SimpleColoredComponent();
            titleComponent.setIcon(AllIcons.Actions.Refresh);
            titleComponent.append("Loading dex stats");
            this.myTopPanel.add((Component)titleComponent, "East");
            Futures.addCallback((ListenableFuture)dexStatsFuture, (FutureCallback)new FutureCallback<DexFileStats>(){

                public void onSuccess(DexFileStats result2) {
                    titleComponent.clear();
                    titleComponent.setIcon(AllIcons.General.Information);
                    titleComponent.append(DexFileViewer.this.myDexFiles.length == 1 ? "This dex file defines " : "These dex files define ");
                    titleComponent.append(Integer.toString(result2.classCount), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    titleComponent.append(" classes with ");
                    titleComponent.append(Integer.toString(result2.definedMethodCount), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    titleComponent.append(" methods, and references ");
                    titleComponent.append(Integer.toString(result2.referencedMethodCount), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    titleComponent.append(" methods.");
                }

                public void onFailure(@NotNull Throwable t) {
                    if (t == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    titleComponent.clear();
                    titleComponent.setIcon(AllIcons.General.Error);
                    titleComponent.append("Error parsing dex file: " + t.getMessage());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/apk/viewer/dex/DexFileViewer$5", "onFailure"));
                }
            }, (Executor)EdtExecutor.INSTANCE);
        }
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JBLoadingPanel jBLoadingPanel = this.myLoadingPanel;
        if (jBLoadingPanel == null) {
            DexFileViewer.$$$reportNull$$$0(5);
        }
        return jBLoadingPanel;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    @Nullable
    public ProguardMappings getProguardMappings() {
        return this.myProguardMappings;
    }

    public boolean isDeobfuscateNames() {
        return this.myDeobfuscateNames;
    }

    @Nullable
    ListenableFuture<DexReferences> getDexReferences() {
        if (this.myDexReferences == null) {
            ListeningExecutorService pooledThreadExecutor = MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE);
            ListenableFuture dexFileFuture = pooledThreadExecutor.submit(() -> {
                DexBackedDexFile[] files2 = new DexBackedDexFile[this.myDexFiles.length];
                for (int i2 = 0; i2 < files2.length; ++i2) {
                    files2[i2] = DexFiles.getDexFile((Path)this.myDexFiles[i2]);
                }
                return files2;
            });
            this.myDexReferences = Futures.transform((ListenableFuture)dexFileFuture, (Function)new Function<DexBackedDexFile[], DexReferences>(){

                public DexReferences apply(@Nullable DexBackedDexFile[] inputs) {
                    assert (inputs != null);
                    return new DexReferences(inputs);
                }
            }, (Executor)pooledThreadExecutor);
        }
        return this.myDexReferences;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dexFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkFolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/viewer/dex/DexFileViewer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/viewer/dex/DexFileViewer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPopupActionGroup";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LoadProguardAction
    extends AnAction {
        LoadProguardAction() {
            super("Load Proguard mappings...", null, EmptyIcon.ICON_0);
            this.getTemplatePresentation().setDisabledIcon(EmptyIcon.ICON_0);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                LoadProguardAction.$$$reportNull$$$0(0);
            }
            DexFileViewer.this.selectProguardMapping();
        }

        public boolean displayTextInToolbar() {
            return true;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                LoadProguardAction.$$$reportNull$$$0(1);
            }
            if (DexFileViewer.this.myProguardMappings != null) {
                e.getPresentation().setText("Change Proguard mappings...");
            } else {
                e.getPresentation().setText("Load Proguard mappings...");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/android/tools/idea/apk/viewer/dex/DexFileViewer$LoadProguardAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class DeobfuscateNodesAction
    extends ToggleAction {
        DeobfuscateNodesAction() {
            super("Deobfuscate names", "Deobfuscate names using Proguard mapping", AllIcons.ObjectBrowser.AbbreviatePackageNames);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                DeobfuscateNodesAction.$$$reportNull$$$0(0);
            }
            return DexFileViewer.this.myDeobfuscateNames;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                DeobfuscateNodesAction.$$$reportNull$$$0(1);
            }
            DexFileViewer.this.myDeobfuscateNames = state;
            DexFileViewer.this.initDex();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                DeobfuscateNodesAction.$$$reportNull$$$0(2);
            }
            super.update(e);
            e.getPresentation().setEnabled(DexFileViewer.this.myProguardMappings != null && ((DexFileViewer)DexFileViewer.this).myProguardMappings.map != null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/android/tools/idea/apk/viewer/dex/DexFileViewer$DeobfuscateNodesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ShowRemovedNodesAction
    extends ToggleAction {
        private final Tree myTree;
        private final DexViewFilters myDexViewFilters;

        ShowRemovedNodesAction(@NotNull Tree tree, DexViewFilters options) {
            if (tree == null) {
                ShowRemovedNodesAction.$$$reportNull$$$0(0);
            }
            if (options == null) {
                ShowRemovedNodesAction.$$$reportNull$$$0(1);
            }
            super("Show removed nodes", "Toggle between show/hide nodes removed by Proguard", AllIcons.ObjectBrowser.CompactEmptyPackages);
            this.myTree = tree;
            this.myDexViewFilters = options;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowRemovedNodesAction.$$$reportNull$$$0(2);
            }
            return this.myDexViewFilters.isShowRemovedNodes();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowRemovedNodesAction.$$$reportNull$$$0(3);
            }
            this.myDexViewFilters.setShowRemovedNodes(state);
            ((DefaultTreeModel)this.myTree.getModel()).reload();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowRemovedNodesAction.$$$reportNull$$$0(4);
            }
            super.update(e);
            e.getPresentation().setEnabled(DexFileViewer.this.myProguardMappings != null && ((DexFileViewer)DexFileViewer.this).myProguardMappings.usage != null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/apk/viewer/dex/DexFileViewer$ShowRemovedNodesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ShowReferencedAction
    extends ToggleAction {
        private final Tree myTree;
        private final DexViewFilters myDexViewFilters;

        ShowReferencedAction(@NotNull Tree tree, @NotNull DexViewFilters options) {
            if (tree == null) {
                ShowReferencedAction.$$$reportNull$$$0(0);
            }
            if (options == null) {
                ShowReferencedAction.$$$reportNull$$$0(1);
            }
            super("Show referenced-only nodes", "Toggle between show/hide referenced-only nodes", AllIcons.ObjectBrowser.ShowMembers);
            this.myTree = tree;
            this.myDexViewFilters = options;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowReferencedAction.$$$reportNull$$$0(2);
            }
            super.update(e);
            String text = this.myDexViewFilters.isShowReferencedNodes() ? "Show all referenced methods and fields" : "Show defined methods and fields";
            e.getPresentation().setText(text);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowReferencedAction.$$$reportNull$$$0(3);
            }
            return this.myDexViewFilters.isShowReferencedNodes();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowReferencedAction.$$$reportNull$$$0(4);
            }
            this.myDexViewFilters.setShowReferencedNodes(state);
            ((DefaultTreeModel)this.myTree.getModel()).reload();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/apk/viewer/dex/DexFileViewer$ShowReferencedAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ShowMethodsAction
    extends ToggleAction {
        private final Tree myTree;
        private final DexViewFilters myDexViewFilters;

        ShowMethodsAction(@NotNull Tree tree, @NotNull DexViewFilters options) {
            if (tree == null) {
                ShowMethodsAction.$$$reportNull$$$0(0);
            }
            if (options == null) {
                ShowMethodsAction.$$$reportNull$$$0(1);
            }
            super("Show methods", "Toggle between show/hide methods", PlatformIcons.METHOD_ICON);
            this.myTree = tree;
            this.myDexViewFilters = options;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowMethodsAction.$$$reportNull$$$0(2);
            }
            return this.myDexViewFilters.isShowMethods();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowMethodsAction.$$$reportNull$$$0(3);
            }
            this.myDexViewFilters.setShowMethods(state);
            ((DefaultTreeModel)this.myTree.getModel()).reload();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/apk/viewer/dex/DexFileViewer$ShowMethodsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ShowFieldsAction
    extends ToggleAction {
        private final Tree myTree;
        private final DexViewFilters myDexViewFilters;

        ShowFieldsAction(@NotNull Tree tree, @NotNull DexViewFilters options) {
            if (tree == null) {
                ShowFieldsAction.$$$reportNull$$$0(0);
            }
            if (options == null) {
                ShowFieldsAction.$$$reportNull$$$0(1);
            }
            super("Show fields", "Toggle between show/hide fields", PlatformIcons.FIELD_ICON);
            this.myTree = tree;
            this.myDexViewFilters = options;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowFieldsAction.$$$reportNull$$$0(2);
            }
            return this.myDexViewFilters.isShowFields();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowFieldsAction.$$$reportNull$$$0(3);
            }
            this.myDexViewFilters.setShowFields(state);
            ((DefaultTreeModel)this.myTree.getModel()).reload();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/apk/viewer/dex/DexFileViewer$ShowFieldsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SizeRenderer
    extends ColoredTreeCellRenderer {
        private SizeRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                SizeRenderer.$$$reportNull$$$0(0);
            }
            if (value2 instanceof DexElementNode) {
                DexElementNode node = (DexElementNode)value2;
                this.append(ApkViewPanel.getHumanizedSize(node.getSize()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/apk/viewer/dex/DexFileViewer$SizeRenderer", "customizeCellRenderer"));
        }
    }

    private static class MethodCountRenderer
    extends ColoredTreeCellRenderer {
        private final boolean myShowDefinedCount;

        MethodCountRenderer(boolean showDefinedCount) {
            this.myShowDefinedCount = showDefinedCount;
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                MethodCountRenderer.$$$reportNull$$$0(0);
            }
            if (value2 instanceof DexElementNode) {
                int count;
                DexElementNode node = (DexElementNode)value2;
                int n = count = this.myShowDefinedCount ? node.getMethodDefinitionsCount() : node.getMethodReferencesCount();
                if (count != 0) {
                    this.append(Integer.toString(count));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/apk/viewer/dex/DexFileViewer$MethodCountRenderer", "customizeCellRenderer"));
        }
    }

    private static class DexTreeNodeRenderer
    extends ColoredTreeCellRenderer {
        @Nullable
        private ProguardMappings myMappings;

        private DexTreeNodeRenderer() {
        }

        public void setMappings(@Nullable ProguardMappings mappings) {
            this.myMappings = mappings;
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                DexTreeNodeRenderer.$$$reportNull$$$0(0);
            }
            if (!(value2 instanceof DexElementNode)) {
                return;
            }
            DexElementNode node = (DexElementNode)value2;
            if (this.myMappings != null && node.isSeed(this.myMappings.seeds, this.myMappings.map, true)) {
                this.append(node.getName(), new SimpleTextAttributes(1, null));
            } else if (node.isRemoved()) {
                this.append(node.getName(), new SimpleTextAttributes(6, null));
            } else if (!node.isDefined()) {
                this.append(node.getName(), new SimpleTextAttributes(2, null));
            } else {
                this.append(node.getName());
            }
            this.setIcon(DexNodeIcons.forNode(node));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/apk/viewer/dex/DexFileViewer$DexTreeNodeRenderer", "customizeCellRenderer"));
        }
    }
}

