/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.actions.AndroidAssetStudioAction;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.npw.assetstudio.wizard.GenerateIconsModel;
import com.android.tools.idea.npw.assetstudio.wizard.NewVectorAssetStep;
import com.android.tools.idea.projectsystem.CapabilityNotSupported;
import com.android.tools.idea.projectsystem.CapabilityStatus;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\nH\u0014\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/actions/NewVectorAssetAction;", "Lcom/android/tools/idea/actions/AndroidAssetStudioAction;", "()V", "createWizard", "Lcom/android/tools/idea/wizard/model/ModelWizard;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "getHelpUrl", "Ljava/net/URL;", "getWizardMinimumSize", "Ljava/awt/Dimension;", "getWizardPreferredSize", "intellij.android.core"})
public final class NewVectorAssetAction
extends AndroidAssetStudioAction {
    @Override
    @Nullable
    protected ModelWizard createWizard(@NotNull AndroidFacet facet) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)facet), (String)"facet");
        Module module = facet.getModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"facet.module");
        Module module2 = module;
        CapabilityStatus status = ProjectSystemUtil.getModuleSystem(module2).canGeneratePngFromVectorGraphics();
        if (status instanceof CapabilityNotSupported) {
            AndroidVersion minSdkVersion2;
            AndroidFacetConfiguration androidFacetConfiguration = (AndroidFacetConfiguration)facet.getConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)androidFacetConfiguration, (String)"facet.configuration");
            AndroidModel androidModel = androidFacetConfiguration.getModel();
            if (androidModel != null && ((minSdkVersion2 = androidModel.getMinSdkVersion()) == null || minSdkVersion2.getApiLevel() < 21)) {
                Messages.showErrorDialog((Project)module2.getProject(), (String)((CapabilityNotSupported)status).getMessage(), (String)((CapabilityNotSupported)status).getTitle());
                return null;
            }
        }
        ModelWizard.Builder wizardBuilder = new ModelWizard.Builder(new ModelWizardStep[0]);
        wizardBuilder.addStep(new NewVectorAssetStep(new GenerateIconsModel(facet, "vectorWizard"), facet));
        return wizardBuilder.build();
    }

    @Override
    @NotNull
    protected Dimension getWizardMinimumSize() {
        JBDimension jBDimension = JBUI.size((int)700, (int)500);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBDimension, (String)"JBUI.size(700, 500)");
        return (Dimension)jBDimension;
    }

    @Override
    @NotNull
    protected Dimension getWizardPreferredSize() {
        return this.getWizardMinimumSize();
    }

    @Override
    @Nullable
    protected URL getHelpUrl() {
        return WizardUtils.toUrl("http://developer.android.com/tools/help/vector-asset-studio.html");
    }

    public NewVectorAssetAction() {
        super("Vector Asset", "Open Vector Asset Studio to create an image asset");
    }
}

