/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.npw.model.ProjectSyncInvoker;
import com.android.tools.idea.npw.model.RenderTemplateModel;
import com.android.tools.idea.npw.project.AndroidPackageUtils;
import com.android.tools.idea.npw.template.ConfigureTemplateParametersStep;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.ui.wizard.StudioWizardDialogBuilder;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import icons.AndroidIcons;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class NewAndroidComponentAction
extends AnAction {
    public static Set<String> NEW_WIZARD_CATEGORIES = ImmutableSet.of((Object)"Activity", (Object)"Google");
    public static final DataKey<List<File>> CREATED_FILES = DataKey.create((String)"CreatedFiles");
    private final String myTemplateCategory;
    private final String myTemplateName;
    private final int myMinSdkApi;
    private final int myMinBuildSdkApi;
    private boolean myShouldOpenFiles;

    public NewAndroidComponentAction(@NotNull String templateCategory, @NotNull String templateName, int minSdkVersion2) {
        if (templateCategory == null) {
            NewAndroidComponentAction.$$$reportNull$$$0(0);
        }
        if (templateName == null) {
            NewAndroidComponentAction.$$$reportNull$$$0(1);
        }
        this(templateCategory, templateName, minSdkVersion2, minSdkVersion2);
    }

    public NewAndroidComponentAction(@NotNull String templateCategory, @NotNull String templateName, int minSdkVersion2, int minBuildSdkApi) {
        if (templateCategory == null) {
            NewAndroidComponentAction.$$$reportNull$$$0(2);
        }
        if (templateName == null) {
            NewAndroidComponentAction.$$$reportNull$$$0(3);
        }
        super(templateName, AndroidBundle.message("android.wizard.action.new.component", templateName), null);
        this.myShouldOpenFiles = true;
        this.myTemplateCategory = templateCategory;
        this.myTemplateName = templateName;
        this.getTemplatePresentation().setIcon(this.isActivityTemplate() ? AndroidIcons.Activity : AndroidIcons.AndroidFile);
        this.myMinSdkApi = minSdkVersion2;
        this.myMinBuildSdkApi = minBuildSdkApi;
    }

    public void setShouldOpenFiles(boolean shouldOpenFiles) {
        this.myShouldOpenFiles = shouldOpenFiles;
    }

    private boolean isActivityTemplate() {
        return NEW_WIZARD_CATEGORIES.contains(this.myTemplateCategory);
    }

    public void update(@NotNull AnActionEvent e) {
        DataContext dataContext;
        Module module;
        if (e == null) {
            NewAndroidComponentAction.$$$reportNull$$$0(4);
        }
        if ((module = (Module)LangDataKeys.MODULE.getData(dataContext = e.getDataContext())) == null) {
            return;
        }
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.getInstance(module);
        if (moduleInfo == null) {
            return;
        }
        Presentation presentation = e.getPresentation();
        AndroidVersion buildSdkVersion = moduleInfo.getBuildSdkVersion();
        if (this.myMinSdkApi > moduleInfo.getMinSdkVersion().getFeatureLevel()) {
            presentation.setText(AndroidBundle.message("android.wizard.action.requires.minsdk", this.myTemplateName, this.myMinSdkApi));
            presentation.setEnabled(false);
        } else if (buildSdkVersion != null && this.myMinBuildSdkApi > buildSdkVersion.getFeatureLevel()) {
            presentation.setText(AndroidBundle.message("android.wizard.action.requires.minbuildsdk", this.myTemplateName, this.myMinBuildSdkApi));
            presentation.setEnabled(false);
        } else {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            boolean isProjectReady = facet != null && ((AndroidFacetConfiguration)facet.getConfiguration()).getModel() != null && ((AndroidFacetConfiguration)facet.getConfiguration()).getProjectType() != 4;
            presentation.setEnabled(isProjectReady);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext;
        Module module;
        if (e == null) {
            NewAndroidComponentAction.$$$reportNull$$$0(5);
        }
        if ((module = (Module)LangDataKeys.MODULE.getData(dataContext = e.getDataContext())) == null) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null || ((AndroidFacetConfiguration)facet.getConfiguration()).getModel() == null) {
            return;
        }
        VirtualFile targetDirectory = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (targetDirectory != null && !targetDirectory.isDirectory()) {
            targetDirectory = targetDirectory.getParent();
            assert (targetDirectory != null);
        }
        File file = TemplateManager.getInstance().getTemplateFile(this.myTemplateCategory, this.myTemplateName);
        assert (file != null);
        String activityDescription = e.getPresentation().getText();
        List<NamedModuleTemplate> moduleTemplates = AndroidPackageUtils.getModuleTemplates(facet, targetDirectory);
        assert (!moduleTemplates.isEmpty());
        String initialPackageSuggestion = targetDirectory == null ? AndroidPackageUtils.getPackageForApplication(facet) : AndroidPackageUtils.getPackageForPath(facet, moduleTemplates, targetDirectory);
        Project project = module.getProject();
        RenderTemplateModel templateModel = new RenderTemplateModel(facet, new TemplateHandle(file), initialPackageSuggestion, moduleTemplates.get(0), "New " + activityDescription, new ProjectSyncInvoker.DefaultProjectSyncInvoker(), this.myShouldOpenFiles);
        boolean isActivity = this.isActivityTemplate();
        String dialogTitle = AndroidBundle.message(isActivity ? "android.wizard.new.activity.title" : "android.wizard.new.component.title", new Object[0]);
        String stepTitle = AndroidBundle.message(isActivity ? "android.wizard.config.activity.title" : "android.wizard.config.component.title", new Object[0]);
        ModelWizard.Builder wizardBuilder = new ModelWizard.Builder(new ModelWizardStep[0]);
        wizardBuilder.addStep(new ConfigureTemplateParametersStep(templateModel, stepTitle, moduleTemplates));
        ModelWizardDialog dialog = new StudioWizardDialogBuilder(wizardBuilder.build(), dialogTitle).setProject(project).build();
        dialog.show();
        List createdFiles = (List)dataContext.getData(CREATED_FILES);
        if (createdFiles != null) {
            createdFiles.addAll(templateModel.getCreatedFiles());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateCategory";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/actions/NewAndroidComponentAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

