/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExportProjectZip
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ExportProjectZip.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        e.getPresentation().setEnabled(project != null && !project.isDefault());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ExportProjectZip.$$$reportNull$$$0(1);
        }
        final Project project = e.getProject();
        assert (project != null);
        FileSaverDialog saver = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor("Save Project As Zip", "Save to", new String[]{"zip"}), project);
        final VirtualFileWrapper target = saver.save(null, project.getName() + "." + "zip");
        if (target != null) {
            Task.Backgroundable task = new Task.Backgroundable(project, "Saving Project Zip"){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ExportProjectZip.save(target.getFile(), project, indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/actions/ExportProjectZip$1", "run"));
                }
            };
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (ProgressIndicator)new BackgroundableProcessIndicator(task));
        }
    }

    static void save(@NotNull File zipFile, @NotNull Project project, final @Nullable ProgressIndicator indicator) {
        if (zipFile == null) {
            ExportProjectZip.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ExportProjectZip.$$$reportNull$$$0(3);
        }
        HashSet<File> allRoots = new HashSet<File>();
        HashSet<File> excludes = new HashSet<File>();
        excludes.add(zipFile);
        assert (project.getBasePath() != null);
        File basePath = VfsUtilCore.virtualToIoFile((VirtualFile)project.getBaseDir());
        allRoots.add(basePath);
        excludes.add(new File(basePath, "local.properties"));
        boolean gradle = GradleProjectInfo.getInstance(project).isBuildWithGradle();
        if (gradle) {
            excludes.add(new File(basePath, ".gradle"));
            excludes.add(new File(basePath, "build"));
            excludes.add(new File(basePath, ".idea"));
            excludes.add(new File(basePath, "captures"));
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            JavaModuleModel model;
            VirtualFile[] exclude;
            VirtualFile[] contentRoots;
            VirtualFile moduleFile;
            if (gradle && (moduleFile = module.getModuleFile()) != null) {
                excludes.add(VfsUtilCore.virtualToIoFile((VirtualFile)moduleFile));
            }
            ModuleRootManager roots = ModuleRootManager.getInstance((Module)module);
            for (VirtualFile root : contentRoots = roots.getContentRoots()) {
                allRoots.add(VfsUtilCore.virtualToIoFile((VirtualFile)root));
            }
            VirtualFile[] virtualFileArray = exclude = roots.getExcludeRoots();
            int n = virtualFileArray.length;
            for (int j = 0; j < n; ++j) {
                VirtualFile virtualFile = virtualFileArray[j];
                excludes.add(VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile));
            }
            AndroidModuleModel androidModuleModel = AndroidModuleModel.get(module);
            if (androidModuleModel != null) {
                excludes.add(androidModuleModel.getAndroidProject().getBuildFolder());
            }
            if ((model = JavaModuleModel.get(module)) == null) continue;
            excludes.add(model.getBuildFolderPath());
        }
        File commonRoot = null;
        for (File root : allRoots) {
            if ((commonRoot = commonRoot == null ? root : FileUtil.findAncestor((File)commonRoot, (File)root)) != null) continue;
            throw new IllegalArgumentException("no common root found");
        }
        assert (commonRoot != null);
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        FileFilter fileFilter = file -> {
            if (fileTypeManager.isFileIgnored(file.getName()) || excludes.stream().anyMatch(root -> FileUtil.isAncestor((File)root, (File)file, (boolean)false))) {
                return false;
            }
            if (!file.exists()) {
                Logger.getInstance(ExportProjectZip.class).info("Skipping broken symlink: " + file);
                return false;
            }
            return allRoots.stream().anyMatch(root -> file.isDirectory() && FileUtil.isAncestor((File)file, (File)root, (boolean)false) || FileUtil.isAncestor((File)root, (File)file, (boolean)false));
        };
        AbstractSet<String> writtenItems = indicator == null ? null : new AbstractSet<String>(){

            @Override
            public boolean add(String s) {
                indicator.setText(s);
                return true;
            }

            @Override
            public Iterator<String> iterator() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                throw new UnsupportedOperationException();
            }
        };
        try (ZipOutputStream outputStream = new ZipOutputStream(new FileOutputStream(zipFile));){
            File[] children = commonRoot.listFiles();
            if (children != null) {
                for (File file2 : children) {
                    if (!fileFilter.accept(file2)) continue;
                    String childRelativePath = (FileUtil.filesEqual((File)commonRoot, (File)basePath) ? commonRoot.getName() + "/" : "") + file2.getName();
                    ZipUtil.addFileOrDirRecursively((ZipOutputStream)outputStream, null, (File)file2, (String)childRelativePath, (FileFilter)fileFilter, (Set)writtenItems);
                }
            }
        }
        catch (Exception ex) {
            Logger.getInstance(ExportProjectZip.class).info("error making zip", (Throwable)ex);
            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)("Error: " + ex), (String)"Error!"));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/actions/ExportProjectZip";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "save";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

