/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Factory;
import org.gradle.internal.impldep.kotlin.jvm.functions.Function0;
import org.gradle.util.GUtil;

public class DeferredUtil {
    private static Boolean kotlinFunction0CanBeLoaded = null;

    @Nullable
    public static Object unpack(@Nullable Object deferred) {
        if (deferred == null) {
            return null;
        }
        Object value = DeferredUtil.unpackNestableDeferred(deferred);
        if (value instanceof Provider) {
            return ((Provider)value).get();
        }
        if (value instanceof Factory) {
            return ((Factory)value).create();
        }
        return value;
    }

    public static boolean isDeferred(Object value) {
        return value instanceof Provider || value instanceof Factory || DeferredUtil.isNestableDeferred(value);
    }

    private static boolean isNestableDeferred(@Nullable Object value) {
        return value instanceof Callable || DeferredUtil.isKotlinFunction0Deferrable(value);
    }

    @Nullable
    private static Object unpackNestableDeferred(Object deferred) {
        Object current = deferred;
        while (DeferredUtil.isNestableDeferred(current)) {
            if (current instanceof Callable) {
                current = GUtil.uncheckedCall((Callable)current);
                continue;
            }
            current = DeferredUtil.unpackKotlinFunction0(current);
        }
        return current;
    }

    private static boolean isKotlinFunction0Deferrable(@Nullable Object value) {
        return value != null && DeferredUtil.kotlinFunction0CanBeLoaded() && value instanceof Function0;
    }

    private static boolean kotlinFunction0CanBeLoaded() {
        if (kotlinFunction0CanBeLoaded == null) {
            try {
                DeferredUtil.class.getClassLoader().loadClass("org/gradle/internal/impldep/kotlin.jvm.functions.Function0");
                kotlinFunction0CanBeLoaded = true;
            }
            catch (ClassNotFoundException ex) {
                kotlinFunction0CanBeLoaded = false;
            }
        }
        return kotlinFunction0CanBeLoaded;
    }

    @Nullable
    private static Object unpackKotlinFunction0(Object value) {
        assert (kotlinFunction0CanBeLoaded.booleanValue());
        return ((Function0)value).invoke();
    }
}

