/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.initialization.DefaultCommandLineConverter;
import org.gradle.internal.DefaultTaskExecutionRequest;
import org.gradle.launcher.cli.converter.PropertiesToStartParameterConverter;
import org.gradle.tooling.internal.protocol.InternalLaunchable;
import org.gradle.tooling.internal.protocol.exceptions.InternalUnsupportedBuildArgumentException;
import org.gradle.tooling.internal.provider.connection.ProviderOperationParameters;

class ProviderStartParameterConverter {
    ProviderStartParameterConverter() {
    }

    private List<TaskExecutionRequest> unpack(List<InternalLaunchable> launchables, File projectDir) {
        ArrayList<TaskExecutionRequest> requests = new ArrayList<TaskExecutionRequest>(launchables.size());
        for (InternalLaunchable launchable : launchables) {
            if (launchable instanceof TaskExecutionRequest) {
                TaskExecutionRequest originalLaunchable = (TaskExecutionRequest)((Object)launchable);
                DefaultTaskExecutionRequest launchableImpl = new DefaultTaskExecutionRequest(originalLaunchable.getArgs(), originalLaunchable.getProjectPath(), originalLaunchable.getRootDir());
                requests.add(launchableImpl);
                continue;
            }
            throw new InternalUnsupportedBuildArgumentException("Problem with provided launchable arguments: " + launchables + ". \nOnly objects from this provider can be built.");
        }
        return requests;
    }

    public StartParameterInternal toStartParameter(ProviderOperationParameters parameters, Map<String, String> properties) {
        List<InternalLaunchable> launchables;
        StartParameterInternal startParameter = new StartParameterInternal();
        startParameter.setProjectDir(parameters.getProjectDir());
        if (parameters.getGradleUserHomeDir() != null) {
            startParameter.setGradleUserHomeDir(parameters.getGradleUserHomeDir());
        }
        if ((launchables = parameters.getLaunchables(null)) != null) {
            startParameter.setTaskRequests(this.unpack(launchables, parameters.getProjectDir()));
        } else if (parameters.getTasks() != null) {
            startParameter.setTaskNames(parameters.getTasks());
        }
        new PropertiesToStartParameterConverter().convert(properties, startParameter);
        List<String> arguments = parameters.getArguments();
        if (arguments != null) {
            DefaultCommandLineConverter converter = new DefaultCommandLineConverter();
            try {
                converter.convert(arguments, startParameter);
            }
            catch (CommandLineArgumentException e) {
                throw new InternalUnsupportedBuildArgumentException("Problem with provided build arguments: " + arguments + ". \n" + e.getMessage() + "\nEither it is not a valid build option or it is not supported in the target Gradle version.\nNot all of the Gradle command line options are supported build arguments.\nExamples of supported build arguments: '--info', '-p'.\nExamples of unsupported build options: '--daemon', '-?', '-v'.\nPlease find more information in the javadoc for the BuildLauncher class.", e);
            }
        }
        if (parameters.isSearchUpwards() != null) {
            startParameter.setSearchUpwards(parameters.isSearchUpwards());
        }
        if (parameters.getBuildLogLevel() != null) {
            startParameter.setLogLevel(parameters.getBuildLogLevel());
        }
        return startParameter;
    }
}

