/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.jacoco.tasks;

import java.io.File;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.project.IsolatedAntBuilder;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.testing.jacoco.plugins.JacocoTaskExtension;
import org.gradle.testing.jacoco.tasks.JacocoBase;
import org.gradle.util.DeprecationLogger;

public abstract class JacocoReportBase
extends JacocoBase {
    private final ConfigurableFileCollection executionData = this.getProject().files(new Object[0]);
    private final ConfigurableFileCollection sourceDirectories = this.getProject().files(new Object[0]);
    private final ConfigurableFileCollection classDirectories = this.getProject().files(new Object[0]);
    private final ConfigurableFileCollection additionalClassDirs = this.getProject().files(new Object[0]);
    private final ConfigurableFileCollection additionalSourceDirs = this.getProject().files(new Object[0]);

    public JacocoReportBase() {
        this.onlyIf((Spec<? super Task>)new Spec<Task>(){

            @Override
            public boolean isSatisfiedBy(Task element) {
                return Iterables.any((Iterable)JacocoReportBase.this.getExecutionData(), (Predicate)new Predicate<File>(){

                    public boolean apply(File file) {
                        return file.exists();
                    }
                });
            }
        });
    }

    @Inject
    protected Instantiator getInstantiator() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected CollectionCallbackActionDecorator getCallbackActionDecorator() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected IsolatedAntBuilder getAntBuilder() {
        throw new UnsupportedOperationException();
    }

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFiles
    public ConfigurableFileCollection getExecutionData() {
        return this.executionData;
    }

    @Deprecated
    public void setExecutionData(FileCollection executionData) {
        DeprecationLogger.nagUserOfDiscontinuedMethod("JacocoReportBase.setExecutionData(FileCollection)", "Use getExecutionData().from(...)");
        this.executionData.setFrom(executionData);
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public ConfigurableFileCollection getSourceDirectories() {
        return this.sourceDirectories;
    }

    @Deprecated
    public void setSourceDirectories(FileCollection sourceDirectories) {
        DeprecationLogger.nagUserOfDiscontinuedMethod("JacocoReportBase.setSourceDirectories(FileCollection)", "Use getSourceDirectories().from(...)");
        this.sourceDirectories.setFrom(sourceDirectories);
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public ConfigurableFileCollection getClassDirectories() {
        return this.classDirectories;
    }

    @Deprecated
    public void setClassDirectories(FileCollection classDirectories) {
        DeprecationLogger.nagUserOfDiscontinuedMethod("JacocoReportBase.setClassDirectories(FileCollection)", "Use getClassDirectories().from(...)");
        this.classDirectories.setFrom(classDirectories);
    }

    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public ConfigurableFileCollection getAdditionalClassDirs() {
        return this.additionalClassDirs;
    }

    @Deprecated
    public void setAdditionalClassDirs(@Nullable FileCollection additionalClassDirs) {
        DeprecationLogger.nagUserOfDiscontinuedMethod("JacocoReportBase.setAdditionalClassDirs(FileCollection)", "Use getAdditionalClassDirs().from(...)");
        if (additionalClassDirs != null) {
            this.additionalClassDirs.setFrom(additionalClassDirs);
        } else {
            this.additionalClassDirs.setFrom(new Object[0]);
        }
    }

    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public ConfigurableFileCollection getAdditionalSourceDirs() {
        return this.additionalSourceDirs;
    }

    @Deprecated
    public void setAdditionalSourceDirs(@Nullable FileCollection additionalSourceDirs) {
        DeprecationLogger.nagUserOfDiscontinuedMethod("JacocoReportBase.setAdditionalSourceDirs(FileCollection)", "Use getAdditionalSourceDirs().from(...)");
        if (additionalSourceDirs != null) {
            this.additionalSourceDirs.setFrom(additionalSourceDirs);
        } else {
            this.additionalSourceDirs.setFrom(new Object[0]);
        }
    }

    public void executionData(Object ... files) {
        this.executionData.from(files);
    }

    public void executionData(Task ... tasks) {
        for (Task task : tasks) {
            final JacocoTaskExtension extension = task.getExtensions().findByType(JacocoTaskExtension.class);
            if (extension == null) continue;
            this.executionData(new Callable<File>(){

                @Override
                public File call() {
                    return extension.getDestinationFile();
                }
            });
            this.mustRunAfter(task);
        }
    }

    public void executionData(TaskCollection tasks) {
        tasks.all(new Action<Task>(){

            @Override
            public void execute(Task task) {
                JacocoReportBase.this.executionData(task);
            }
        });
    }

    @Internal
    public FileCollection getAllClassDirs() {
        return this.classDirectories.plus(this.getAdditionalClassDirs());
    }

    @Internal
    public FileCollection getAllSourceDirs() {
        return this.sourceDirectories.plus(this.getAdditionalSourceDirs());
    }

    public void sourceSets(SourceSet ... sourceSets) {
        for (final SourceSet sourceSet : sourceSets) {
            this.sourceDirectories.from(new Callable<Set<File>>(){

                @Override
                public Set<File> call() throws Exception {
                    return sourceSet.getAllJava().getSrcDirs();
                }
            });
            this.classDirectories.from(sourceSet.getOutput());
        }
    }

    public void additionalClassDirs(File ... dirs) {
        this.additionalClassDirs(this.getProject().files(Arrays.asList(dirs)));
    }

    public void additionalClassDirs(FileCollection dirs) {
        this.additionalClassDirs.from(dirs);
    }

    public void additionalSourceDirs(File ... dirs) {
        this.additionalSourceDirs(this.getProject().files(Arrays.asList(dirs)));
    }

    public void additionalSourceDirs(FileCollection dirs) {
        this.additionalSourceDirs.from(dirs);
    }
}

