/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.base.plugins;

import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.model.Each;
import org.gradle.model.Finalize;
import org.gradle.model.Model;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.TypeBuilder;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.testing.base.TestSuiteBinarySpec;
import org.gradle.testing.base.TestSuiteContainer;
import org.gradle.testing.base.TestSuiteSpec;
import org.gradle.testing.base.TestSuiteTaskCollection;
import org.gradle.testing.base.internal.BaseTestSuiteSpec;

@Incubating
public class TestingModelBasePlugin
implements Plugin<Project> {
    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(ComponentModelBasePlugin.class);
    }

    static class Rules
    extends RuleSource {
        Rules() {
        }

        @ComponentType
        void registerTestSuiteSpec(TypeBuilder<TestSuiteSpec> builder) {
            builder.defaultImplementation(BaseTestSuiteSpec.class);
        }

        @Model
        void testSuites(TestSuiteContainer testSuites) {
        }

        @Mutate
        void copyTestBinariesToGlobalContainer(BinaryContainer binaries, TestSuiteContainer testSuites) {
            for (TestSuiteSpec testSuite : testSuites.values()) {
                for (BinarySpecInternal binary : testSuite.getBinaries().withType(BinarySpecInternal.class).values()) {
                    binaries.put(binary.getProjectScopedName(), binary);
                }
            }
        }

        @Finalize
        public void defineBinariesCheckTasks(@Each BinarySpecInternal binary, NamedEntityInstantiator<Task> taskInstantiator) {
            if (binary.isLegacyBinary()) {
                return;
            }
            TaskInternal binaryLifecycleTask = taskInstantiator.create(binary.getNamingScheme().getTaskName("check"), DefaultTask.class);
            binaryLifecycleTask.setGroup("verification");
            binaryLifecycleTask.setDescription("Check " + binary);
            binary.setCheckTask(binaryLifecycleTask);
        }

        @Finalize
        void copyBinariesCheckTasksToTaskContainer(TaskContainer tasks, BinaryContainer binaries) {
            for (BinarySpec binary : binaries) {
                Task checkTask = binary.getCheckTask();
                if (checkTask == null) continue;
                ((TaskContainerInternal)tasks).addInternal(checkTask);
            }
        }

        @Finalize
        void linkTestSuiteBinariesRunTaskToBinariesCheckTasks(@Path(value="binaries") ModelMap<TestSuiteBinarySpec> binaries) {
            binaries.afterEach(new Action<TestSuiteBinarySpec>(){

                @Override
                public void execute(TestSuiteBinarySpec testSuiteBinary) {
                    if (testSuiteBinary.isBuildable()) {
                        BinarySpec testedBinary;
                        if (testSuiteBinary.getTasks() instanceof TestSuiteTaskCollection) {
                            testSuiteBinary.checkedBy(((TestSuiteTaskCollection)testSuiteBinary.getTasks()).getRun());
                        }
                        if ((testedBinary = testSuiteBinary.getTestedBinary()) != null && testedBinary.isBuildable()) {
                            testedBinary.checkedBy(testSuiteBinary.getCheckTask());
                        }
                    }
                }
            });
        }

        @Finalize
        void attachBinariesCheckTasksToCheckLifecycle(@Path(value="tasks.check") Task checkTask, @Path(value="binaries") ModelMap<BinarySpec> binaries) {
            for (BinarySpec binary : binaries) {
                Task binaryCheckTask;
                if (!binary.isBuildable() || (binaryCheckTask = binary.getCheckTask()) == null) continue;
                checkTask.dependsOn(binaryCheckTask);
            }
        }
    }
}

