/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testfixtures;

import java.io.File;
import org.gradle.api.Project;
import org.gradle.internal.Factory;
import org.gradle.testfixtures.internal.ProjectBuilderImpl;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.SingleMessageLogger;

public class ProjectBuilder {
    private File projectDir;
    private File gradleUserHomeDir;
    private String name = "test";
    private Project parent;
    private ProjectBuilderImpl impl = new ProjectBuilderImpl();

    @Deprecated
    public ProjectBuilder() {
        SingleMessageLogger.nagUserOfDeprecated("The ProjectBuilder() constructor", "Please use ProjectBuilder.builder() instead.");
    }

    public static ProjectBuilder builder() {
        return DeprecationLogger.whileDisabled(new Factory<ProjectBuilder>(){

            @Override
            public ProjectBuilder create() {
                return new ProjectBuilder();
            }
        });
    }

    public ProjectBuilder withProjectDir(File dir) {
        this.projectDir = dir;
        return this;
    }

    public ProjectBuilder withGradleUserHomeDir(File dir) {
        this.gradleUserHomeDir = dir;
        return this;
    }

    public ProjectBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public ProjectBuilder withParent(Project parent) {
        this.parent = parent;
        return this;
    }

    public Project build() {
        if (this.parent != null) {
            return this.impl.createChildProject(this.name, this.parent, this.projectDir);
        }
        return this.impl.createProject(this.name, this.projectDir, this.gradleUserHomeDir);
    }
}

