/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.health.memory;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.io.Files;
import org.gradle.process.internal.health.memory.OsMemoryInfo;
import org.gradle.process.internal.health.memory.OsMemoryStatus;
import org.gradle.process.internal.health.memory.OsMemoryStatusSnapshot;

public class MemInfoOsMemoryInfo
implements OsMemoryInfo {
    private static final Pattern MEMINFO_LINE_PATTERN = Pattern.compile("^\\D+(\\d+) kB$");
    private static final String MEMINFO_FILE_PATH = "/proc/meminfo";
    private final Matcher meminfoMatcher = MEMINFO_LINE_PATTERN.matcher("");

    @Override
    public synchronized OsMemoryStatus getOsSnapshot() {
        List meminfoOutputLines;
        try {
            meminfoOutputLines = Files.readLines((File)new File(MEMINFO_FILE_PATH), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Unable to read system memory from /proc/meminfo", e);
        }
        OsMemoryStatusSnapshot memInfo = this.getOsSnapshotFromMemInfo(meminfoOutputLines);
        if (memInfo.getFreePhysicalMemory() < 0L || memInfo.getTotalPhysicalMemory() < 0L) {
            throw new UnsupportedOperationException("Unable to read system memory from /proc/meminfo");
        }
        return memInfo;
    }

    @VisibleForTesting
    OsMemoryStatusSnapshot getOsSnapshotFromMemInfo(List<String> meminfoLines) {
        Meminfo meminfo = new Meminfo();
        for (String line : meminfoLines) {
            if (line.startsWith("MemAvailable")) {
                meminfo.setAvailable(this.parseMeminfoBytes(line));
                continue;
            }
            if (line.startsWith("MemFree")) {
                meminfo.setFree(this.parseMeminfoBytes(line));
                continue;
            }
            if (line.startsWith("Buffers")) {
                meminfo.setBuffers(this.parseMeminfoBytes(line));
                continue;
            }
            if (line.startsWith("Cached")) {
                meminfo.setCached(this.parseMeminfoBytes(line));
                continue;
            }
            if (line.startsWith("SReclaimable")) {
                meminfo.setReclaimable(this.parseMeminfoBytes(line));
                continue;
            }
            if (line.startsWith("Mapped")) {
                meminfo.setMapped(this.parseMeminfoBytes(line));
                continue;
            }
            if (!line.startsWith("MemTotal")) continue;
            meminfo.setTotal(this.parseMeminfoBytes(line));
        }
        return new OsMemoryStatusSnapshot(meminfo.getTotal(), meminfo.getAvailable());
    }

    private long parseMeminfoBytes(String line) {
        Matcher matcher = this.meminfoMatcher.reset(line);
        if (matcher.matches()) {
            return Long.parseLong(matcher.group(1)) * 1024L;
        }
        throw new UnsupportedOperationException("Unable to parse /proc/meminfo output to get system memory");
    }

    private class Meminfo {
        private long total = -1L;
        private long available = -1L;
        private long free = -1L;
        private long buffers = -1L;
        private long cached = -1L;
        private long reclaimable = -1L;
        private long mapped = -1L;

        private Meminfo() {
        }

        public long getTotal() {
            return this.total;
        }

        long getAvailable() {
            if (this.available != -1L) {
                return this.available;
            }
            if (this.free != -1L && this.buffers != -1L && this.cached != -1L && this.reclaimable != -1L && this.mapped != -1L) {
                return this.free + this.buffers + this.cached + this.reclaimable - this.mapped;
            }
            return -1L;
        }

        void setFree(long memFree) {
            this.free = memFree;
        }

        public void setBuffers(long buffers) {
            this.buffers = buffers;
        }

        public void setCached(long cached) {
            this.cached = cached;
        }

        void setReclaimable(long reclaimable) {
            this.reclaimable = reclaimable;
        }

        public void setMapped(long mapped) {
            this.mapped = mapped;
        }

        public void setTotal(long total) {
            this.total = total;
        }

        public void setAvailable(long available) {
            this.available = available;
        }
    }
}

