/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import java.util.LinkedList;
import java.util.List;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.plugins.PluginInspector;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.internal.Factory;
import org.gradle.plugin.use.resolve.internal.ArtifactRepositoriesPluginResolver;
import org.gradle.plugin.use.resolve.internal.CompositePluginResolver;
import org.gradle.plugin.use.resolve.internal.CorePluginResolver;
import org.gradle.plugin.use.resolve.internal.NoopPluginResolver;
import org.gradle.plugin.use.resolve.internal.PluginResolver;
import org.gradle.plugin.use.resolve.internal.PluginResolverContributor;
import org.gradle.plugin.use.resolve.internal.SelfResolvingRequestPluginResolver;
import org.gradle.plugin.use.resolve.service.internal.InjectedClasspathPluginResolver;

public class PluginResolverFactory
implements Factory<PluginResolver> {
    private final PluginRegistry pluginRegistry;
    private final DocumentationRegistry documentationRegistry;
    private final InjectedClasspathPluginResolver injectedClasspathPluginResolver;
    private final DependencyResolutionServices dependencyResolutionServices;
    private final List<PluginResolverContributor> pluginResolverContributors;
    private final VersionSelectorScheme versionSelectorScheme;
    private final PluginInspector pluginInspector;

    public PluginResolverFactory(PluginRegistry pluginRegistry, PluginInspector pluginInspector, DocumentationRegistry documentationRegistry, InjectedClasspathPluginResolver injectedClasspathPluginResolver, DependencyResolutionServices dependencyResolutionServices, List<PluginResolverContributor> pluginResolverContributors, VersionSelectorScheme versionSelectorScheme) {
        this.pluginRegistry = pluginRegistry;
        this.pluginInspector = pluginInspector;
        this.documentationRegistry = documentationRegistry;
        this.injectedClasspathPluginResolver = injectedClasspathPluginResolver;
        this.dependencyResolutionServices = dependencyResolutionServices;
        this.pluginResolverContributors = pluginResolverContributors;
        this.versionSelectorScheme = versionSelectorScheme;
    }

    @Override
    public PluginResolver create() {
        return new CompositePluginResolver(this.createDefaultResolvers());
    }

    private List<PluginResolver> createDefaultResolvers() {
        LinkedList<PluginResolver> resolvers = new LinkedList<PluginResolver>();
        this.addDefaultResolvers(resolvers);
        return resolvers;
    }

    private void addDefaultResolvers(List<PluginResolver> resolvers) {
        resolvers.add(new NoopPluginResolver(this.pluginRegistry));
        resolvers.add(new SelfResolvingRequestPluginResolver(this.pluginInspector));
        resolvers.add(new CorePluginResolver(this.documentationRegistry, this.pluginRegistry));
        if (!this.injectedClasspathPluginResolver.isClasspathEmpty()) {
            resolvers.add(this.injectedClasspathPluginResolver);
        }
        for (PluginResolverContributor contributor : this.pluginResolverContributors) {
            contributor.collectResolversInto(resolvers);
        }
        resolvers.add(ArtifactRepositoriesPluginResolver.createWithDefaults(this.dependencyResolutionServices, this.versionSelectorScheme));
    }
}

