/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.classpath.DefaultModuleRegistry;
import org.gradle.api.internal.classpath.Module;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.installation.CurrentGradleInstallation;
import org.gradle.internal.installation.GradleInstallation;
import org.gradle.internal.io.StreamByteBuffer;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.launcher.daemon.DaemonExecHandleBuilder;
import org.gradle.launcher.daemon.bootstrap.DaemonOutputConsumer;
import org.gradle.launcher.daemon.bootstrap.GradleDaemon;
import org.gradle.launcher.daemon.client.DaemonGreeter;
import org.gradle.launcher.daemon.client.DaemonStarter;
import org.gradle.launcher.daemon.client.JvmVersionValidator;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.diagnostics.DaemonStartupInfo;
import org.gradle.launcher.daemon.registry.DaemonDir;
import org.gradle.process.internal.DefaultExecActionFactory;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.streams.EncodedStream;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GFileUtils;
import org.gradle.util.GradleVersion;

public class DefaultDaemonStarter
implements DaemonStarter {
    private static final Logger LOGGER = Logging.getLogger(DefaultDaemonStarter.class);
    private final DaemonDir daemonDir;
    private final DaemonParameters daemonParameters;
    private final DaemonGreeter daemonGreeter;
    private final JvmVersionValidator versionValidator;

    public DefaultDaemonStarter(DaemonDir daemonDir, DaemonParameters daemonParameters, DaemonGreeter daemonGreeter, JvmVersionValidator versionValidator) {
        this.daemonDir = daemonDir;
        this.daemonParameters = daemonParameters;
        this.daemonGreeter = daemonGreeter;
        this.versionValidator = versionValidator;
    }

    @Override
    public DaemonStartupInfo startDaemon(boolean singleUse) {
        List<Object> searchClassPath;
        ClassPath classpath;
        String daemonUid = UUID.randomUUID().toString();
        GradleInstallation gradleInstallation = CurrentGradleInstallation.get();
        DefaultModuleRegistry registry = new DefaultModuleRegistry(gradleInstallation);
        if (gradleInstallation == null) {
            classpath = ClassPath.EMPTY;
            for (Module module : registry.getModule("gradle-launcher").getAllRequiredModules()) {
                classpath = classpath.plus(module.getClasspath());
            }
            searchClassPath = registry.getAdditionalClassPath().getAsFiles();
        } else {
            classpath = registry.getModule("gradle-launcher").getImplementationClasspath();
            searchClassPath = Collections.emptyList();
        }
        if (classpath.isEmpty()) {
            throw new IllegalStateException("Unable to construct a bootstrap classpath when starting the daemon");
        }
        this.versionValidator.validate(this.daemonParameters);
        ArrayList<String> daemonArgs = new ArrayList<String>();
        daemonArgs.addAll(this.getPriorityArgs(this.daemonParameters.getPriority()));
        daemonArgs.add(this.daemonParameters.getEffectiveJvm().getJavaExecutable().getAbsolutePath());
        List<String> daemonOpts = this.daemonParameters.getEffectiveJvmArgs();
        daemonArgs.addAll(daemonOpts);
        daemonArgs.add("-cp");
        daemonArgs.add(CollectionUtils.join(File.pathSeparator, classpath.getAsFiles()));
        if (Boolean.getBoolean("org.gradle.daemon.debug")) {
            daemonArgs.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=5005");
        }
        LOGGER.debug("Using daemon args: {}", daemonArgs);
        daemonArgs.add(GradleDaemon.class.getName());
        daemonArgs.add(GradleVersion.current().getVersion());
        StreamByteBuffer buffer = new StreamByteBuffer();
        KryoBackedEncoder encoder = new KryoBackedEncoder(new EncodedStream.EncodedOutput(buffer.getOutputStream()));
        try {
            encoder.writeString(this.daemonParameters.getGradleUserHomeDir().getAbsolutePath());
            encoder.writeString(this.daemonDir.getBaseDir().getAbsolutePath());
            encoder.writeSmallInt(this.daemonParameters.getIdleTimeout());
            encoder.writeSmallInt(this.daemonParameters.getPeriodicCheckInterval());
            encoder.writeBoolean(singleUse);
            encoder.writeString(daemonUid);
            encoder.writeSmallInt(this.daemonParameters.getPriority().ordinal());
            encoder.writeSmallInt(daemonOpts.size());
            for (String string : daemonOpts) {
                encoder.writeString(string);
            }
            encoder.writeSmallInt(searchClassPath.size());
            for (File file : searchClassPath) {
                encoder.writeString(file.getAbsolutePath());
            }
            encoder.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        InputStream stdInput = buffer.getInputStream();
        return this.startProcess(daemonArgs, this.daemonDir.getVersionedDir(), stdInput);
    }

    private List<String> getPriorityArgs(DaemonParameters.Priority priority) {
        if (priority == DaemonParameters.Priority.NORMAL) {
            return Collections.emptyList();
        }
        OperatingSystem os = OperatingSystem.current();
        if (os.isUnix()) {
            return Arrays.asList("nice", "-n", "10");
        }
        if (os.isWindows()) {
            return Arrays.asList("cmd", "/C", "start", "\"Gradle build daemon\"", "/B", "/belownormal", "/WAIT");
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DaemonStartupInfo startProcess(List<String> args, File workingDir, InputStream stdInput) {
        LOGGER.debug("Starting daemon process: workingDir = {}, daemonArgs: {}", workingDir, args);
        Timer clock = Time.startTimer();
        try {
            GFileUtils.mkdirs(workingDir);
            DaemonOutputConsumer outputConsumer = new DaemonOutputConsumer();
            DefaultExecActionFactory execActionFactory = new DefaultExecActionFactory(new IdentityFileResolver());
            try {
                ExecHandle handle = new DaemonExecHandleBuilder().build(args, workingDir, outputConsumer, stdInput, execActionFactory.newExec());
                handle.start();
                LOGGER.debug("Gradle daemon process is starting. Waiting for the daemon to detach...");
                handle.waitForFinish();
                LOGGER.debug("Gradle daemon process is now detached.");
            }
            finally {
                execActionFactory.stop();
            }
            DaemonStartupInfo daemonStartupInfo = this.daemonGreeter.parseDaemonOutput(outputConsumer.getProcessOutput());
            return daemonStartupInfo;
        }
        catch (GradleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GradleException("Could not start Gradle daemon.", e);
        }
        finally {
            LOGGER.info("An attempt to start the daemon took {}.", clock.getElapsed());
        }
    }
}

