/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.tasks;

import java.io.File;
import java.io.IOException;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.language.swift.tasks.internal.SymbolHider;
import org.gradle.process.ExecSpec;

@Incubating
@CacheableTask
public class UnexportMainSymbol
extends DefaultTask {
    private final ConfigurableFileCollection source = this.getProject().files(new Object[0]);
    private final DirectoryProperty outputDirectory = this.getProject().getObjects().directoryProperty();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @SkipWhenEmpty
    public ConfigurableFileCollection getObjects() {
        return this.source;
    }

    @Internal
    public FileCollection getRelocatedObjects() {
        return this.outputDirectory.getAsFileTree();
    }

    @OutputDirectory
    public DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    @TaskAction
    public void unexport() {
        for (final File file : this.source) {
            final File relocatedObject = this.outputDirectory.file(file.getName()).get().getAsFile();
            if (OperatingSystem.current().isWindows()) {
                try {
                    SymbolHider symbolHider = new SymbolHider(file);
                    symbolHider.hideSymbol("main");
                    symbolHider.hideSymbol("_main");
                    symbolHider.saveTo(relocatedObject);
                    continue;
                }
                catch (IOException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
            this.getProject().exec((Action<? super ExecSpec>)new Action<ExecSpec>(){

                @Override
                public void execute(ExecSpec execSpec) {
                    if (OperatingSystem.current().isMacOsX()) {
                        execSpec.executable("ld");
                        execSpec.args(file);
                        execSpec.args("-o", relocatedObject);
                        execSpec.args("-r");
                        execSpec.args("-unexported_symbol", "_main");
                    } else if (OperatingSystem.current().isLinux()) {
                        execSpec.executable("objcopy");
                        execSpec.args("-L", "main");
                        execSpec.args(file);
                        execSpec.args(relocatedObject);
                    } else {
                        throw new IllegalStateException("Do not know how to unexport a main symbol on " + OperatingSystem.current());
                    }
                }
            });
        }
    }
}

