/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.internal.operations.logging.BuildOperationLoggerFactory;
import org.gradle.language.base.compile.CompilerVersion;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.VersionAwareCompiler;
import org.gradle.language.swift.SwiftVersion;
import org.gradle.language.swift.tasks.internal.DefaultSwiftCompileSpec;
import org.gradle.nativeplatform.internal.BuildOperationLoggingCompilerDecorator;
import org.gradle.nativeplatform.internal.CompilerOutputFileNamingSchemeFactory;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.compilespec.SwiftCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.swift.IncrementalSwiftCompiler;

@Incubating
@CacheableTask
public class SwiftCompile
extends DefaultTask {
    private final Property<String> moduleName;
    private final RegularFileProperty moduleFile;
    private final ConfigurableFileCollection modules;
    private final ListProperty<String> compilerArgs;
    private final DirectoryProperty objectFileDir;
    private final ConfigurableFileCollection source;
    private final Property<SwiftVersion> sourceCompatibility;
    private final ListProperty<String> macros;
    private final Property<Boolean> debuggable;
    private final Property<Boolean> optimize;
    private final Property<NativePlatform> targetPlatform;
    private final Property<NativeToolChain> toolChain;
    private final CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory;

    @Inject
    public SwiftCompile(CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory) {
        this.compilerOutputFileNamingSchemeFactory = compilerOutputFileNamingSchemeFactory;
        ObjectFactory objectFactory = this.getProject().getObjects();
        this.moduleName = objectFactory.property(String.class);
        this.moduleFile = objectFactory.fileProperty();
        this.modules = this.getProject().files(new Object[0]);
        this.compilerArgs = objectFactory.listProperty(String.class);
        this.objectFileDir = objectFactory.directoryProperty();
        this.source = this.getProject().files(new Object[0]);
        this.sourceCompatibility = objectFactory.property(SwiftVersion.class);
        this.macros = objectFactory.listProperty(String.class);
        this.debuggable = objectFactory.property(Boolean.class).value(false);
        this.optimize = objectFactory.property(Boolean.class).value(false);
        this.targetPlatform = objectFactory.property(NativePlatform.class);
        this.toolChain = objectFactory.property(NativeToolChain.class);
    }

    @Internal
    public Property<NativeToolChain> getToolChain() {
        return this.toolChain;
    }

    @Nested
    public Property<NativePlatform> getTargetPlatform() {
        return this.targetPlatform;
    }

    @InputFiles
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public ConfigurableFileCollection getSource() {
        return this.source;
    }

    @Input
    public ListProperty<String> getMacros() {
        return this.macros;
    }

    @Internal
    public boolean isDebuggable() {
        return (Boolean)this.debuggable.get();
    }

    @Input
    public Property<Boolean> getDebuggable() {
        return this.debuggable;
    }

    @Internal
    public boolean isOptimized() {
        return (Boolean)this.optimize.get();
    }

    @Input
    public Property<Boolean> getOptimized() {
        return this.optimize;
    }

    @Input
    public ListProperty<String> getCompilerArgs() {
        return this.compilerArgs;
    }

    @OutputDirectory
    public DirectoryProperty getObjectFileDir() {
        return this.objectFileDir;
    }

    @OutputFile
    public RegularFileProperty getModuleFile() {
        return this.moduleFile;
    }

    @Optional
    @Input
    public Property<String> getModuleName() {
        return this.moduleName;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public ConfigurableFileCollection getModules() {
        return this.modules;
    }

    @Input
    public Property<SwiftVersion> getSourceCompatibility() {
        return this.sourceCompatibility;
    }

    @Nested
    protected CompilerVersion getCompilerVersion() {
        return ((VersionAwareCompiler)this.createCompiler()).getVersion();
    }

    private Compiler<SwiftCompileSpec> createCompiler() {
        NativePlatformInternal targetPlatform = Cast.cast(NativePlatformInternal.class, (NativePlatform)this.targetPlatform.get());
        NativeToolChainInternal toolChain = Cast.cast(NativeToolChainInternal.class, (NativeToolChain)this.getToolChain().get());
        PlatformToolProvider toolProvider = toolChain.select(targetPlatform);
        return toolProvider.newCompiler(SwiftCompileSpec.class);
    }

    @TaskAction
    void compile(IncrementalTaskInputs inputs) {
        final ArrayList removedFiles = Lists.newArrayList();
        final HashSet changedFiles = Sets.newHashSet();
        boolean isIncremental = inputs.isIncremental();
        if (isIncremental) {
            inputs.outOfDate((Action<? super InputFileDetails>)new Action<InputFileDetails>(){

                @Override
                public void execute(InputFileDetails inputFileDetails) {
                    if (inputFileDetails.isModified()) {
                        changedFiles.add(inputFileDetails.getFile());
                    }
                }
            });
            inputs.removed((Action<? super InputFileDetails>)new Action<InputFileDetails>(){

                @Override
                public void execute(InputFileDetails removed) {
                    removedFiles.add(removed.getFile());
                }
            });
            Set<File> allSourceFiles = this.getSource().getFiles();
            if (!allSourceFiles.containsAll(changedFiles)) {
                isIncremental = false;
            }
        }
        BuildOperationLogger operationLogger = this.getServices().get(BuildOperationLoggerFactory.class).newOperationLogger(this.getName(), this.getTemporaryDir());
        NativePlatformInternal targetPlatform = Cast.cast(NativePlatformInternal.class, (NativePlatform)this.targetPlatform.get());
        SwiftCompileSpec spec = this.createSpec(operationLogger, isIncremental, changedFiles, removedFiles, targetPlatform);
        IncrementalSwiftCompiler baseCompiler = new IncrementalSwiftCompiler(this.createCompiler(), this.getOutputs(), this.compilerOutputFileNamingSchemeFactory);
        Compiler<SwiftCompileSpec> loggingCompiler = BuildOperationLoggingCompilerDecorator.wrap(baseCompiler);
        WorkResult result = loggingCompiler.execute(spec);
        this.setDidWork(result.getDidWork());
    }

    private SwiftCompileSpec createSpec(BuildOperationLogger operationLogger, boolean isIncremental, Collection<File> changedFiles, Collection<File> removedFiles, NativePlatformInternal targetPlatform) {
        DefaultSwiftCompileSpec spec = new DefaultSwiftCompileSpec();
        spec.setModuleName((String)this.moduleName.getOrNull());
        spec.setModuleFile(((RegularFile)this.moduleFile.get()).getAsFile());
        for (File file : this.modules.getFiles()) {
            if (file.isFile()) {
                spec.include(file.getParentFile());
                continue;
            }
            spec.include(file);
        }
        spec.setTargetPlatform(targetPlatform);
        spec.setTempDir(this.getTemporaryDir());
        spec.setObjectFileDir(((Directory)this.objectFileDir.get()).getAsFile());
        spec.source(this.getSource());
        spec.setRemovedSourceFiles(removedFiles);
        spec.setChangedFiles(changedFiles);
        LinkedHashMap<String, String> macros = new LinkedHashMap<String, String>();
        for (String macro : (List)this.getMacros().get()) {
            macros.put(macro, null);
        }
        spec.setMacros(macros);
        spec.args((List)this.getCompilerArgs().get());
        spec.setDebuggable((Boolean)this.getDebuggable().get());
        spec.setOptimized((Boolean)this.getOptimized().get());
        spec.setIncrementalCompile(isIncremental);
        spec.setOperationLogger(operationLogger);
        spec.setSourceCompatibility((SwiftVersion)((Object)this.sourceCompatibility.get()));
        return spec;
    }
}

