/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.plugins;

import java.util.concurrent.Callable;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.ComponentWithNames;
import org.gradle.language.nativeplatform.internal.Dimensions;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.language.swift.SwiftBinary;
import org.gradle.language.swift.SwiftLibrary;
import org.gradle.language.swift.SwiftPlatform;
import org.gradle.language.swift.SwiftSharedLibrary;
import org.gradle.language.swift.SwiftStaticLibrary;
import org.gradle.language.swift.SwiftVersion;
import org.gradle.language.swift.internal.DefaultSwiftLibrary;
import org.gradle.language.swift.internal.DefaultSwiftPlatform;
import org.gradle.language.swift.internal.DefaultSwiftSharedLibrary;
import org.gradle.language.swift.internal.DefaultSwiftStaticLibrary;
import org.gradle.language.swift.plugins.SwiftBasePlugin;
import org.gradle.nativeplatform.Linkage;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.gradle.nativeplatform.TargetMachineFactory;
import org.gradle.nativeplatform.platform.internal.Architectures;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.util.GUtil;

@Incubating
public class SwiftLibraryPlugin
implements Plugin<Project> {
    private final NativeComponentFactory componentFactory;
    private final ToolChainSelector toolChainSelector;
    private final ImmutableAttributesFactory attributesFactory;
    private final TargetMachineFactory targetMachineFactory;

    @Inject
    public SwiftLibraryPlugin(NativeComponentFactory componentFactory, ToolChainSelector toolChainSelector, ImmutableAttributesFactory attributesFactory, TargetMachineFactory targetMachineFactory) {
        this.componentFactory = componentFactory;
        this.toolChainSelector = toolChainSelector;
        this.attributesFactory = attributesFactory;
        this.targetMachineFactory = targetMachineFactory;
    }

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(SwiftBasePlugin.class);
        ConfigurationContainer configurations = project.getConfigurations();
        ObjectFactory objectFactory = project.getObjects();
        ProviderFactory providers = project.getProviders();
        final DefaultSwiftLibrary library = this.componentFactory.newInstance(SwiftLibrary.class, DefaultSwiftLibrary.class, "main");
        project.getExtensions().add(SwiftLibrary.class, "library", library);
        project.getComponents().add(library);
        Property<String> module = library.getModule();
        module.set(GUtil.toCamelCase(project.getName()));
        library.getTargetMachines().convention(Dimensions.useHostAsDefaultTargetMachine(this.targetMachineFactory));
        library.getDevelopmentBinary().convention(project.provider(new Callable<SwiftBinary>(){

            @Override
            public SwiftBinary call() throws Exception {
                return this.getDebugSharedHostStream().findFirst().orElse(this.getDebugStaticHostStream().findFirst().orElse(this.getDebugSharedStream().findFirst().orElse(this.getDebugStaticStream().findFirst().orElse(null))));
            }

            private Stream<SwiftBinary> getDebugStream() {
                return ((DefaultBinaryCollection)library.getBinaries()).get().stream().filter(binary -> !binary.isOptimized());
            }

            private Stream<SwiftBinary> getDebugSharedStream() {
                return this.getDebugStream().filter(SwiftSharedLibrary.class::isInstance);
            }

            private Stream<SwiftBinary> getDebugSharedHostStream() {
                return this.getDebugSharedStream().filter(binary -> Architectures.forInput(binary.getTargetMachine().getArchitecture().getName()).equals(DefaultNativePlatform.host().getArchitecture()));
            }

            private Stream<SwiftBinary> getDebugStaticStream() {
                return this.getDebugStream().filter(SwiftStaticLibrary.class::isInstance);
            }

            private Stream<SwiftBinary> getDebugStaticHostStream() {
                return this.getDebugStaticStream().filter(binary -> Architectures.forInput(binary.getTargetMachine().getArchitecture().getName()).equals(DefaultNativePlatform.host().getArchitecture()));
            }
        }));
        project.afterEvaluate(p -> {
            Dimensions.libraryVariants(library.getModule(), library.getLinkage(), library.getTargetMachines(), objectFactory, this.attributesFactory, providers.provider(() -> project.getGroup().toString()), providers.provider(() -> project.getVersion().toString()), variantIdentity -> {
                if (Dimensions.tryToBuildOnHost(variantIdentity)) {
                    library.getSourceCompatibility().finalizeValue();
                    ToolChainSelector.Result<DefaultSwiftPlatform> result = this.toolChainSelector.select(SwiftPlatform.class, new DefaultSwiftPlatform(variantIdentity.getTargetMachine(), (SwiftVersion)((Object)((Object)((Object)library.getSourceCompatibility().getOrNull())))));
                    if (variantIdentity.getLinkage().equals(Linkage.SHARED)) {
                        library.addSharedLibrary((NativeVariantIdentity)variantIdentity, variantIdentity.isDebuggable() && !variantIdentity.isOptimized(), result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                    } else {
                        library.addStaticLibrary((NativeVariantIdentity)variantIdentity, variantIdentity.isDebuggable() && !variantIdentity.isOptimized(), result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                    }
                }
            });
            ((DefaultBinaryCollection)library.getBinaries()).whenElementKnown(SwiftSharedLibrary.class, sharedLibrary -> {
                Names names = ((ComponentWithNames)((Object)sharedLibrary)).getNames();
                Configuration apiElements = (Configuration)configurations.create(names.withSuffix("SwiftApiElements"));
                apiElements.extendsFrom(((DefaultSwiftSharedLibrary)sharedLibrary).getImplementationDependencies());
                apiElements.setCanBeResolved(false);
                apiElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, objectFactory.named(Usage.class, "swift-api"));
                apiElements.getAttributes().attribute(CppBinary.LINKAGE_ATTRIBUTE, Linkage.SHARED);
                apiElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, sharedLibrary.isDebuggable());
                apiElements.getAttributes().attribute(CppBinary.OPTIMIZED_ATTRIBUTE, sharedLibrary.isOptimized());
                apiElements.getAttributes().attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, sharedLibrary.getTargetMachine().getOperatingSystemFamily());
                apiElements.getOutgoing().artifact(sharedLibrary.getModuleFile());
            });
            ((DefaultBinaryCollection)library.getBinaries()).whenElementKnown(SwiftStaticLibrary.class, staticLibrary -> {
                Names names = ((ComponentWithNames)((Object)staticLibrary)).getNames();
                Configuration apiElements = (Configuration)configurations.create(names.withSuffix("SwiftApiElements"));
                apiElements.extendsFrom(((DefaultSwiftStaticLibrary)staticLibrary).getImplementationDependencies());
                apiElements.setCanBeResolved(false);
                apiElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, objectFactory.named(Usage.class, "swift-api"));
                apiElements.getAttributes().attribute(CppBinary.LINKAGE_ATTRIBUTE, Linkage.STATIC);
                apiElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, staticLibrary.isDebuggable());
                apiElements.getAttributes().attribute(CppBinary.OPTIMIZED_ATTRIBUTE, staticLibrary.isOptimized());
                apiElements.getAttributes().attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, staticLibrary.getTargetMachine().getOperatingSystemFamily());
                apiElements.getOutgoing().artifact(staticLibrary.getModuleFile());
            });
            ((DefaultBinaryCollection)library.getBinaries()).realizeNow();
        });
    }
}

