/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.tasks;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.Incubating;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.language.base.compile.CompilerVersion;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.VersionAwareCompiler;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.RegexBackedCSourceParser;
import org.gradle.language.nativeplatform.tasks.AbstractNativeCompileTask;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PCHUtils;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.PreCompiledHeader;

@Incubating
public abstract class AbstractNativeSourceCompileTask
extends AbstractNativeCompileTask {
    private PreCompiledHeader preCompiledHeader;

    @Override
    protected void configureSpec(NativeCompileSpec spec) {
        super.configureSpec(spec);
        if (this.preCompiledHeader != null) {
            File pchObjectFile = this.preCompiledHeader.getObjectFile();
            File pchDir = PCHUtils.generatePCHObjectDirectory(spec.getTempDir(), this.preCompiledHeader.getPrefixHeaderFile(), pchObjectFile);
            spec.setPrefixHeaderFile(new File(pchDir, this.preCompiledHeader.getPrefixHeaderFile().getName()));
            spec.setPreCompiledHeaderObjectFile(new File(pchDir, pchObjectFile.getName()));
            spec.setPreCompiledHeader(RegexBackedCSourceParser.parseExpression(this.preCompiledHeader.getIncludeString()).getValue());
        }
    }

    public AbstractNativeSourceCompileTask() {
        this.getOutputs().doNotCacheIf("Pre-compiled headers are used", (Spec<? super Task>)new Spec<Task>(){

            @Override
            public boolean isSatisfiedBy(Task element) {
                return AbstractNativeSourceCompileTask.this.getPreCompiledHeader() != null;
            }
        });
        this.getOutputs().doNotCacheIf("Could not determine compiler version", (Spec<? super Task>)new Spec<Task>(){

            @Override
            public boolean isSatisfiedBy(Task element) {
                CompilerVersion compilerVersion = AbstractNativeSourceCompileTask.this.getCompilerVersion();
                return compilerVersion == null;
            }
        });
    }

    @Nullable
    @Optional
    @Nested
    public PreCompiledHeader getPreCompiledHeader() {
        return this.preCompiledHeader;
    }

    public void setPreCompiledHeader(@Nullable PreCompiledHeader preCompiledHeader) {
        this.preCompiledHeader = preCompiledHeader;
    }

    @Nullable
    @Optional
    @Nested
    protected CompilerVersion getCompilerVersion() {
        NativePlatformInternal targetPlatform;
        NativeToolChainInternal toolChain = (NativeToolChainInternal)this.getToolChain().get();
        PlatformToolProvider toolProvider = toolChain.select(targetPlatform = (NativePlatformInternal)this.getTargetPlatform().get());
        Compiler<?> compiler = toolProvider.newCompiler(this.createCompileSpec().getClass());
        if (!(compiler instanceof VersionAwareCompiler)) {
            return null;
        }
        return ((VersionAwareCompiler)compiler).getVersion();
    }
}

