/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental.sourceparser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.language.nativeplatform.internal.Expression;
import org.gradle.language.nativeplatform.internal.Include;
import org.gradle.language.nativeplatform.internal.IncludeDirectives;
import org.gradle.language.nativeplatform.internal.IncludeType;
import org.gradle.language.nativeplatform.internal.Macro;
import org.gradle.language.nativeplatform.internal.MacroFunction;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.ArgsMappingMacroFunction;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.CSourceParser;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.ComplexExpression;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.DefaultIncludeDirectives;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.IncludeWithSimpleExpression;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.MacroWithComplexExpression;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.MacroWithSimpleExpression;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.PreprocessingReader;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.ReturnFixedValueMacroFunction;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.ReturnParameterMacroFunction;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.SimpleExpression;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.UnresolveableMacro;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.UnresolveableMacroFunction;

public class RegexBackedCSourceParser
implements CSourceParser {
    @Override
    public IncludeDirectives parseSource(File sourceFile) {
        IncludeDirectives includeDirectives;
        FileReader fileReader = new FileReader(sourceFile);
        try {
            includeDirectives = this.parseSource(fileReader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)fileReader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not extract includes from source file %s.", sourceFile), e);
            }
        }
        ((Reader)fileReader).close();
        return includeDirectives;
    }

    protected IncludeDirectives parseSource(Reader sourceReader) throws IOException {
        LinkedHashSet includes = Sets.newLinkedHashSet();
        ArrayList macros = Lists.newArrayList();
        ArrayList macroFunctions = Lists.newArrayList();
        BufferedReader reader = new BufferedReader(sourceReader);
        PreprocessingReader lineReader = new PreprocessingReader(reader);
        Buffer buffer = new Buffer();
        while (true) {
            buffer.reset();
            if (!lineReader.readNextLine(buffer.value)) break;
            buffer.consumeWhitespace();
            if (!buffer.consume('#')) continue;
            buffer.consumeWhitespace();
            if (buffer.consume("define")) {
                this.parseDefineDirectiveBody(buffer, macros, macroFunctions);
                continue;
            }
            if (buffer.consume("include")) {
                this.parseIncludeOrImportDirectiveBody(buffer, false, includes);
                continue;
            }
            if (!buffer.consume("import")) continue;
            this.parseIncludeOrImportDirectiveBody(buffer, true, includes);
        }
        return DefaultIncludeDirectives.of((ImmutableList<Include>)ImmutableList.copyOf((Collection)includes), (ImmutableList<Macro>)ImmutableList.copyOf((Collection)macros), (ImmutableList<MacroFunction>)ImmutableList.copyOf((Collection)macroFunctions));
    }

    private void parseIncludeOrImportDirectiveBody(Buffer buffer, boolean isImport, Collection<Include> includes) {
        if (!buffer.hasAny()) {
            return;
        }
        if (buffer.hasIdentifierChar()) {
            return;
        }
        Expression expression = RegexBackedCSourceParser.parseDirectiveBodyExpression(buffer);
        if (expression.getType() == IncludeType.TOKEN_CONCATENATION || expression.getType() == IncludeType.ARGS_LIST || expression.getType() == IncludeType.EXPRESSIONS) {
            expression = new SimpleExpression(expression.getAsSourceText(), IncludeType.OTHER);
        }
        if ((expression = expression.asMacroExpansion()).getType() != IncludeType.OTHER || !expression.getValue().isEmpty()) {
            includes.add(IncludeWithSimpleExpression.create(expression, isImport));
        }
    }

    private void parseDefineDirectiveBody(Buffer buffer, Collection<Macro> macros, Collection<MacroFunction> macroFunctions) {
        if (!buffer.consumeWhitespace()) {
            return;
        }
        String name = buffer.readIdentifier();
        if (name == null) {
            return;
        }
        if (buffer.consume('(')) {
            this.parseMacroFunctionDirectiveBody(buffer, name, macroFunctions);
        } else {
            this.parseMacroObjectDirectiveBody(buffer, name, macros);
        }
    }

    private void parseMacroObjectDirectiveBody(Buffer buffer, String macroName, Collection<Macro> macros) {
        Expression expression = RegexBackedCSourceParser.parseDirectiveBodyExpression(buffer);
        if (!(expression = expression.asMacroExpansion()).getArguments().isEmpty()) {
            macros.add(new MacroWithComplexExpression(macroName, expression.getType(), expression.getValue(), expression.getArguments()));
        } else if (expression.getType() != IncludeType.OTHER) {
            macros.add(new MacroWithSimpleExpression(macroName, expression.getType(), expression.getValue()));
        } else {
            macros.add(new UnresolveableMacro(macroName));
        }
    }

    private void parseMacroFunctionDirectiveBody(Buffer buffer, String macroName, Collection<MacroFunction> macroFunctions) {
        buffer.consumeWhitespace();
        ArrayList<String> paramNames = new ArrayList<String>();
        this.consumeParameterList(buffer, paramNames);
        if (!buffer.consume(')')) {
            return;
        }
        Expression expression = RegexBackedCSourceParser.parseDirectiveBodyExpression(buffer);
        if (expression.getType() == IncludeType.QUOTED || expression.getType() == IncludeType.SYSTEM) {
            macroFunctions.add(new ReturnFixedValueMacroFunction(macroName, paramNames.size(), expression.getType(), expression.getValue(), Collections.emptyList()));
            return;
        }
        if (expression.getType() == IncludeType.IDENTIFIER) {
            for (int i = 0; i < paramNames.size(); ++i) {
                String name = (String)paramNames.get(i);
                if (!name.equals(expression.getValue())) continue;
                macroFunctions.add(new ReturnParameterMacroFunction(macroName, paramNames.size(), i));
                return;
            }
            macroFunctions.add(new ReturnFixedValueMacroFunction(macroName, paramNames.size(), IncludeType.MACRO, expression.getValue(), Collections.emptyList()));
            return;
        }
        if (expression.getType() != IncludeType.OTHER) {
            if (paramNames.isEmpty() || expression.getArguments().isEmpty()) {
                expression = expression.asMacroExpansion();
                macroFunctions.add(new ReturnFixedValueMacroFunction(macroName, paramNames.size(), expression.getType(), expression.getValue(), expression.getArguments()));
                return;
            }
            ArrayList<Integer> argsMap = new ArrayList<Integer>(expression.getArguments().size());
            boolean usesArgs = this.mapArgs(paramNames, expression, argsMap);
            if (!usesArgs) {
                expression = expression.asMacroExpansion();
                macroFunctions.add(new ReturnFixedValueMacroFunction(macroName, paramNames.size(), expression.getType(), expression.getValue(), expression.getArguments()));
            } else {
                int[] argsMapArray = new int[argsMap.size()];
                for (int i = 0; i < argsMap.size(); ++i) {
                    argsMapArray[i] = (Integer)argsMap.get(i);
                }
                expression = expression.asMacroExpansion();
                macroFunctions.add(new ArgsMappingMacroFunction(macroName, paramNames.size(), argsMapArray, expression.getType(), expression.getValue(), expression.getArguments()));
            }
            return;
        }
        macroFunctions.add(new UnresolveableMacroFunction(macroName, paramNames.size()));
    }

    private boolean mapArgs(List<String> paramNames, Expression expression, List<Integer> argsMap) {
        boolean usesParameters = false;
        for (int i = 0; i < expression.getArguments().size(); ++i) {
            Expression argument = expression.getArguments().get(i);
            if (argument.getType() == IncludeType.IDENTIFIER) {
                boolean matches = false;
                for (int j = 0; j < paramNames.size(); ++j) {
                    String paramName = paramNames.get(j);
                    if (!argument.getValue().equals(paramName)) continue;
                    argsMap.add(j);
                    usesParameters = true;
                    matches = true;
                    break;
                }
                if (matches) continue;
            }
            if (argument.getArguments().isEmpty()) {
                argsMap.add(-1);
                continue;
            }
            ArrayList<Integer> nestedMap = new ArrayList<Integer>(argument.getArguments().size());
            boolean argUsesParameters = this.mapArgs(paramNames, argument, nestedMap);
            if (argUsesParameters) {
                argsMap.add(-2);
                argsMap.addAll(nestedMap);
            } else {
                argsMap.add(-1);
            }
            usesParameters |= argUsesParameters;
        }
        return usesParameters;
    }

    private void consumeParameterList(Buffer buffer, List<String> paramNames) {
        String paramName = buffer.readIdentifier();
        while (paramName != null) {
            paramNames.add(paramName);
            buffer.consumeWhitespace();
            if (!buffer.consume(',')) {
                return;
            }
            buffer.consumeWhitespace();
            paramName = buffer.readIdentifier();
            if (paramName != null) continue;
            return;
        }
    }

    public static Expression parseExpression(String value) {
        Buffer buffer = new Buffer();
        buffer.value.append(value);
        return RegexBackedCSourceParser.parseDirectiveBodyExpression(buffer).asMacroExpansion();
    }

    private static Expression parseDirectiveBodyExpression(Buffer buffer) {
        int startPos = buffer.pos;
        Expression expression = RegexBackedCSourceParser.parseExpression(buffer);
        buffer.consumeWhitespace();
        if (expression == null || buffer.hasAny()) {
            return new SimpleExpression(buffer.substring(startPos).trim(), IncludeType.OTHER);
        }
        return expression;
    }

    @Nullable
    private static Expression parseExpression(Buffer buffer) {
        buffer.consumeWhitespace();
        if (!buffer.hasAny()) {
            return null;
        }
        Expression expression = RegexBackedCSourceParser.readPathExpression(buffer);
        if (expression != null) {
            return expression;
        }
        List<Expression> arguments = RegexBackedCSourceParser.readArgumentList(buffer);
        if (arguments != null) {
            if (arguments.isEmpty()) {
                return SimpleExpression.EMPTY_ARGS;
            }
            return new ComplexExpression(IncludeType.ARGS_LIST, null, arguments);
        }
        String identifier = buffer.readIdentifier();
        if (identifier == null) {
            String token = buffer.readAnyExcept("(),");
            if (token != null) {
                return new SimpleExpression(token, IncludeType.TOKEN);
            }
            return null;
        }
        buffer.consumeWhitespace();
        arguments = RegexBackedCSourceParser.readArgumentList(buffer);
        if (arguments != null) {
            if (arguments.isEmpty()) {
                return new SimpleExpression(identifier, IncludeType.MACRO_FUNCTION);
            }
            return new ComplexExpression(IncludeType.MACRO_FUNCTION, identifier, arguments);
        }
        expression = RegexBackedCSourceParser.readTokenConcatenation(buffer, identifier);
        if (expression != null) {
            return expression;
        }
        return new SimpleExpression(identifier, IncludeType.IDENTIFIER);
    }

    private static Expression readPathExpression(Buffer buffer) {
        if (buffer.consume('<')) {
            return RegexBackedCSourceParser.readDelimitedExpression(buffer, '>', IncludeType.SYSTEM);
        }
        if (buffer.consume('\"')) {
            return RegexBackedCSourceParser.readDelimitedExpression(buffer, '\"', IncludeType.QUOTED);
        }
        return null;
    }

    private static Expression readTokenConcatenation(Buffer buffer, String leftToken) {
        int pos = buffer.pos;
        if (!buffer.consume("##")) {
            return null;
        }
        buffer.consumeWhitespace();
        String right = buffer.readIdentifier();
        if (right == null) {
            buffer.pos = pos;
            return null;
        }
        ComplexExpression concatExpression = new ComplexExpression(IncludeType.TOKEN_CONCATENATION, null, Arrays.asList(new SimpleExpression(leftToken, IncludeType.IDENTIFIER), new SimpleExpression(right, IncludeType.IDENTIFIER)));
        buffer.consumeWhitespace();
        while (buffer.consume("##")) {
            buffer.consumeWhitespace();
            right = buffer.readIdentifier();
            if (right == null) {
                buffer.pos = pos;
                return null;
            }
            concatExpression = new ComplexExpression(IncludeType.TOKEN_CONCATENATION, null, Arrays.asList(concatExpression, new SimpleExpression(right, IncludeType.IDENTIFIER)));
            buffer.consumeWhitespace();
        }
        return concatExpression;
    }

    private static List<Expression> readArgumentList(Buffer buffer) {
        int pos = buffer.pos;
        if (!buffer.consume('(')) {
            return null;
        }
        ArrayList<Expression> argumentExpressions = new ArrayList<Expression>();
        buffer.consumeWhitespace();
        RegexBackedCSourceParser.consumeArgumentList(buffer, argumentExpressions);
        if (!buffer.consume(')')) {
            buffer.pos = pos;
            return null;
        }
        return argumentExpressions;
    }

    private static void consumeArgumentList(Buffer buffer, List<Expression> expressions) {
        Expression expression = RegexBackedCSourceParser.readArgument(buffer);
        if (expression == null) {
            if (!buffer.has(',')) {
                return;
            }
            expression = SimpleExpression.EMPTY_EXPRESSIONS;
        }
        expressions.add(expression);
        while (true) {
            buffer.consumeWhitespace();
            if (!buffer.consume(',')) {
                return;
            }
            expression = RegexBackedCSourceParser.readArgument(buffer);
            if (expression == null) {
                expression = SimpleExpression.EMPTY_EXPRESSIONS;
            }
            expressions.add(expression);
        }
    }

    private static Expression readArgument(Buffer buffer) {
        Expression expression = RegexBackedCSourceParser.parseExpression(buffer);
        if (expression == null) {
            return null;
        }
        buffer.consumeWhitespace();
        if (buffer.hasAny(",)")) {
            return expression;
        }
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        expressions.add(expression);
        do {
            if ((expression = RegexBackedCSourceParser.parseExpression(buffer)) == null) {
                return null;
            }
            expressions.add(expression);
            buffer.consumeWhitespace();
        } while (!buffer.hasAny(",)"));
        return new ComplexExpression(IncludeType.EXPRESSIONS, null, expressions);
    }

    @Nullable
    private static Expression readDelimitedExpression(Buffer buffer, char endDelim, IncludeType type) {
        int startValue = buffer.pos;
        buffer.consumeUpTo(endDelim);
        int endValue = buffer.pos;
        if (!buffer.consume(endDelim)) {
            return null;
        }
        return new SimpleExpression(buffer.value.substring(startValue, endValue), type);
    }

    private static int consumeIdentifier(CharSequence value, int startOffset) {
        char ch;
        int pos;
        for (pos = startOffset; pos < value.length() && (Character.isLetterOrDigit(ch = value.charAt(pos)) || ch == '_' || ch == '$'); ++pos) {
        }
        return pos;
    }

    private static int consumeWhitespace(CharSequence value, int startOffset) {
        char ch;
        int pos;
        for (pos = startOffset; pos < value.length() && (Character.isWhitespace(ch = value.charAt(pos)) || ch == '\u0000'); ++pos) {
        }
        return pos;
    }

    private static class Buffer {
        final StringBuilder value = new StringBuilder();
        int pos = 0;

        private Buffer() {
        }

        public String toString() {
            return "{buffer remaining: '" + this.value.substring(this.pos, this.pos + Math.min(this.value.length() - this.pos, 20)) + "'}";
        }

        void reset() {
            this.value.setLength(0);
            this.pos = 0;
        }

        String substring(int pos) {
            return this.value.substring(pos);
        }

        boolean hasAny() {
            return this.pos < this.value.length();
        }

        public boolean has(char c) {
            return this.pos < this.value.length() && this.value.charAt(this.pos) == c;
        }

        public boolean hasAny(String chars) {
            if (this.pos >= this.value.length()) {
                return false;
            }
            char ch = this.value.charAt(this.pos);
            for (int i = 0; i < chars.length(); ++i) {
                if (chars.charAt(i) != ch) continue;
                return true;
            }
            return false;
        }

        boolean hasIdentifierChar() {
            if (this.pos < this.value.length()) {
                char ch = this.value.charAt(this.pos);
                return Character.isLetterOrDigit(ch) || ch == '_' || ch == '$';
            }
            return false;
        }

        @Nullable
        String readIdentifier() {
            int oldPos = this.pos;
            this.pos = RegexBackedCSourceParser.consumeIdentifier(this.value, this.pos);
            if (this.pos == oldPos) {
                return null;
            }
            return this.value.substring(oldPos, this.pos);
        }

        @Nullable
        String readAnyExcept(String chars) {
            if (this.pos >= this.value.length()) {
                return null;
            }
            char ch = this.value.charAt(this.pos);
            for (int i = 0; i < chars.length(); ++i) {
                if (chars.charAt(i) != ch) continue;
                return null;
            }
            ++this.pos;
            return String.valueOf(ch);
        }

        @Nullable
        String readAnyExcept(char ch) {
            if (this.pos < this.value.length() && this.value.charAt(this.pos) != ch) {
                return this.value.substring(this.pos, ++this.pos);
            }
            return null;
        }

        boolean consumeWhitespace() {
            int oldPos = this.pos;
            this.pos = RegexBackedCSourceParser.consumeWhitespace(this.value, this.pos);
            return this.pos != oldPos;
        }

        boolean consume(String token) {
            if (this.pos + token.length() < this.value.length()) {
                for (int i = 0; i < token.length(); ++i) {
                    if (this.value.charAt(this.pos + i) == token.charAt(i)) continue;
                    return false;
                }
                this.pos += token.length();
                return true;
            }
            return false;
        }

        boolean consume(char c) {
            if (this.pos < this.value.length() && this.value.charAt(this.pos) == c) {
                ++this.pos;
                return true;
            }
            return false;
        }

        void consumeUpTo(char c) {
            while (this.pos < this.value.length() && this.value.charAt(this.pos) != c) {
                ++this.pos;
            }
        }
    }
}

