/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.plugins;

import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.language.cpp.CppApplication;
import org.gradle.language.cpp.CppExecutable;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.internal.DefaultCppApplication;
import org.gradle.language.cpp.internal.DefaultCppPlatform;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.cpp.plugins.CppBasePlugin;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.Dimensions;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.nativeplatform.TargetMachineFactory;
import org.gradle.nativeplatform.platform.internal.Architectures;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;

@Incubating
public class CppApplicationPlugin
implements Plugin<Project> {
    private final NativeComponentFactory componentFactory;
    private final ToolChainSelector toolChainSelector;
    private final ImmutableAttributesFactory attributesFactory;
    private final TargetMachineFactory targetMachineFactory;

    @Inject
    public CppApplicationPlugin(NativeComponentFactory componentFactory, ToolChainSelector toolChainSelector, ImmutableAttributesFactory attributesFactory, TargetMachineFactory targetMachineFactory) {
        this.componentFactory = componentFactory;
        this.toolChainSelector = toolChainSelector;
        this.attributesFactory = attributesFactory;
        this.targetMachineFactory = targetMachineFactory;
    }

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(CppBasePlugin.class);
        ObjectFactory objectFactory = project.getObjects();
        ProviderFactory providers = project.getProviders();
        DefaultCppApplication application = this.componentFactory.newInstance(CppApplication.class, DefaultCppApplication.class, "main");
        project.getExtensions().add(CppApplication.class, "application", application);
        project.getComponents().add(application);
        application.getBaseName().convention(project.getName());
        application.getTargetMachines().convention(Dimensions.useHostAsDefaultTargetMachine(this.targetMachineFactory));
        application.getDevelopmentBinary().convention(project.provider(() -> ((DefaultBinaryCollection)application.getBinaries()).get().stream().filter(CppExecutable.class::isInstance).map(CppExecutable.class::cast).filter(binary -> !binary.isOptimized() && Architectures.forInput(binary.getTargetMachine().getArchitecture().getName()).equals(DefaultNativePlatform.host().getArchitecture())).findFirst().orElse(((DefaultBinaryCollection)application.getBinaries()).get().stream().filter(CppExecutable.class::isInstance).map(CppExecutable.class::cast).filter(binary -> !binary.isOptimized()).findFirst().orElse(null))));
        ((DefaultBinaryCollection)application.getBinaries()).whenElementKnown(binary -> application.getMainPublication().addVariant((SoftwareComponent)binary));
        project.afterEvaluate(p -> {
            Dimensions.applicationVariants(application.getBaseName(), application.getTargetMachines(), objectFactory, this.attributesFactory, providers.provider(() -> project.getGroup().toString()), providers.provider(() -> project.getVersion().toString()), variantIdentity -> {
                if (Dimensions.tryToBuildOnHost(variantIdentity)) {
                    ToolChainSelector.Result<DefaultCppPlatform> result = this.toolChainSelector.select(CppPlatform.class, new DefaultCppPlatform(variantIdentity.getTargetMachine()));
                    application.addExecutable((NativeVariantIdentity)variantIdentity, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                } else {
                    application.getMainPublication().addVariant((SoftwareComponent)variantIdentity);
                }
            });
            ((DefaultBinaryCollection)application.getBinaries()).realizeNow();
        });
    }
}

