/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.tasks.api;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.gradle.api.Incubating;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.tasks.compile.ApiClassExtractor;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.FileUtils;
import org.gradle.internal.IoActions;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.org.objectweb.asm.ClassReader;

@Incubating
public class ApiJar
extends SourceTask {
    private Set<String> exportedPackages;
    private File outputFile;

    @Override
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    @Input
    public Set<String> getExportedPackages() {
        return this.exportedPackages;
    }

    public void setExportedPackages(Set<String> exportedPackages) {
        this.exportedPackages = exportedPackages;
    }

    @OutputFile
    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    @TaskAction
    public void createApiJar() throws IOException {
        final List<File> sourceFiles = this.sortedSourceFiles();
        final ApiClassExtractor apiClassExtractor = new ApiClassExtractor(this.getExportedPackages());
        IoActions.withResource(new JarOutputStream(new BufferedOutputStream(new FileOutputStream(this.getOutputFile()), 65536)), new ErroringAction<JarOutputStream>(){

            @Override
            protected void doExecute(JarOutputStream jos) throws Exception {
                this.writeManifest(jos);
                this.writeClasses(jos);
            }

            private void writeManifest(JarOutputStream jos) throws IOException {
                this.writeEntry(jos, "META-INF/MANIFEST.MF", "Manifest-Version: 1.0\n".getBytes());
            }

            private void writeClasses(JarOutputStream jos) throws Exception {
                for (File sourceFile : sourceFiles) {
                    byte[] apiClassBytes;
                    ClassReader classReader;
                    if (!ApiJar.this.isClassFile(sourceFile) || !apiClassExtractor.shouldExtractApiClassFrom(classReader = new ClassReader(org.gradle.internal.impldep.org.apache.commons.io.FileUtils.readFileToByteArray((File)sourceFile))) || (apiClassBytes = apiClassExtractor.extractApiClassFrom(classReader)) == null) continue;
                    String internalClassName = classReader.getClassName();
                    String entryPath = internalClassName + ".class";
                    this.writeEntry(jos, entryPath, apiClassBytes);
                }
            }

            private void writeEntry(JarOutputStream jos, String name, byte[] bytes) throws IOException {
                JarEntry je = new JarEntry(name);
                je.setTime(0L);
                je.setSize(bytes.length);
                jos.putNextEntry(je);
                jos.write(bytes);
                jos.closeEntry();
            }
        });
    }

    private boolean isClassFile(File file) {
        return FileUtils.hasExtension(file, ".class");
    }

    private List<File> sortedSourceFiles() {
        ArrayList sourceFiles = Lists.newArrayList(this.getSource().getFiles());
        Collections.sort(sourceFiles);
        return sourceFiles;
    }
}

