/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.work;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.specs.Spec;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.impldep.com.google.common.collect.ArrayListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.resources.ProjectLeaseRegistry;
import org.gradle.internal.work.AsyncWorkCompletion;
import org.gradle.internal.work.AsyncWorkTracker;
import org.gradle.util.CollectionUtils;

public class DefaultAsyncWorkTracker
implements AsyncWorkTracker {
    private final ListMultimap<BuildOperationRef, AsyncWorkCompletion> items = ArrayListMultimap.create();
    private final Set<BuildOperationRef> waiting = Sets.newHashSet();
    private final ReentrantLock lock = new ReentrantLock();
    private final ProjectLeaseRegistry projectLeaseRegistry;

    public DefaultAsyncWorkTracker(ProjectLeaseRegistry projectLeaseRegistry) {
        this.projectLeaseRegistry = projectLeaseRegistry;
    }

    @Override
    public void registerWork(BuildOperationRef operation, AsyncWorkCompletion workCompletion) {
        this.lock.lock();
        try {
            if (this.waiting.contains(operation)) {
                throw new IllegalStateException("Another thread is currently waiting on the completion of work for the provided operation");
            }
            this.items.put((Object)operation, (Object)workCompletion);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForCompletion(BuildOperationRef operation, boolean releaseLocks) {
        ImmutableList workItems;
        this.lock.lock();
        try {
            workItems = ImmutableList.copyOf((Collection)this.items.get((Object)operation));
            this.items.removeAll((Object)operation);
            this.startWaiting(operation);
        }
        finally {
            this.lock.unlock();
        }
        try {
            if (workItems.size() > 0) {
                boolean workInProgress = CollectionUtils.any(workItems, new Spec<AsyncWorkCompletion>(){

                    @Override
                    public boolean isSatisfiedBy(AsyncWorkCompletion workCompletion) {
                        return !workCompletion.isComplete();
                    }
                });
                if (releaseLocks && workInProgress) {
                    this.projectLeaseRegistry.withoutProjectLock(new Runnable((List)workItems){
                        final /* synthetic */ List val$workItems;
                        {
                            this.val$workItems = list;
                        }

                        @Override
                        public void run() {
                            DefaultAsyncWorkTracker.this.waitForItemsAndGatherFailures(this.val$workItems);
                        }
                    });
                } else {
                    this.waitForItemsAndGatherFailures((Iterable<AsyncWorkCompletion>)workItems);
                }
            }
        }
        finally {
            this.stopWaiting(operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasUncompletedWork(BuildOperationRef operation) {
        this.lock.lock();
        try {
            List workItems = this.items.get((Object)operation);
            for (AsyncWorkCompletion workCompletion : workItems) {
                if (workCompletion.isComplete()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void waitForItemsAndGatherFailures(Iterable<AsyncWorkCompletion> workItems) {
        ArrayList failures = Lists.newArrayList();
        for (AsyncWorkCompletion item : workItems) {
            try {
                item.waitForCompletion();
            }
            catch (Throwable t) {
                if (Thread.currentThread().isInterrupted()) {
                    this.cancel(workItems);
                }
                failures.add(t);
            }
        }
        if (failures.size() > 0) {
            throw new DefaultMultiCauseException("There were failures while executing asynchronous work:", failures);
        }
    }

    private void cancel(Iterable<AsyncWorkCompletion> workItems) {
        for (AsyncWorkCompletion workItem : workItems) {
            workItem.cancel();
        }
    }

    private void startWaiting(BuildOperationRef operation) {
        this.lock.lock();
        try {
            this.waiting.add(operation);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void stopWaiting(BuildOperationRef operation) {
        this.lock.lock();
        try {
            this.waiting.remove(operation);
        }
        finally {
            this.lock.unlock();
        }
    }
}

