/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import javax.annotation.Nullable;
import org.gradle.internal.Cast;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.snapshot.impl.SerializedValueSnapshot;

public class IsolatableSerializedValueSnapshot
extends SerializedValueSnapshot
implements Isolatable<Object> {
    private final Class<?> originalClass;

    public IsolatableSerializedValueSnapshot(HashCode implementationHash, byte[] serializedValue, Class<?> originalClass) {
        super(implementationHash, serializedValue);
        this.originalClass = originalClass;
    }

    @Override
    public Object isolate() {
        return this.populateClass(this.originalClass);
    }

    @Override
    @Nullable
    public <S> Isolatable<S> coerce(Class<S> type) {
        if (type.isAssignableFrom(this.originalClass)) {
            return (Isolatable)Cast.uncheckedCast(this);
        }
        if (type.getName().equals(this.originalClass.getName())) {
            return (Isolatable)Cast.uncheckedCast(new IsolatableSerializedValueSnapshot(this.getImplementationHash(), this.getValue(), type));
        }
        return null;
    }
}

