/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.internal.Cast;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.internal.snapshot.impl.AbstractScalarValueSnapshot;

public class FileValueSnapshot
extends AbstractScalarValueSnapshot<String>
implements Isolatable<File> {
    public FileValueSnapshot(File value) {
        super(value.getPath());
    }

    public FileValueSnapshot(String value) {
        super(value);
    }

    @Override
    public File isolate() {
        return new File((String)this.getValue());
    }

    @Override
    @Nullable
    public <S> Isolatable<S> coerce(Class<S> type) {
        if (type.isAssignableFrom(File.class)) {
            return (Isolatable)Cast.uncheckedCast(this);
        }
        return null;
    }

    @Override
    public ValueSnapshot snapshot(Object value, ValueSnapshotter snapshotter) {
        File file;
        if (value instanceof File && (file = (File)value).getPath().equals(this.getValue())) {
            return this;
        }
        return snapshotter.snapshot(value);
    }

    @Override
    public void appendToHasher(Hasher hasher) {
        hasher.putString((CharSequence)this.getValue());
    }
}

