/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.MutableBoolean;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.base.Predicates;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.nativeintegration.filesystem.DefaultFileMetadata;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.filesystem.Stat;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.MerkleDirectorySnapshotBuilder;
import org.gradle.internal.snapshot.RegularFileSnapshot;

public class DirectorySnapshotter {
    private final FileHasher hasher;
    private final FileSystem fileSystem;
    private final StringInterner stringInterner;
    private final DefaultExcludes defaultExcludes;

    public DirectorySnapshotter(FileHasher hasher, FileSystem fileSystem, StringInterner stringInterner, String ... defaultExcludes) {
        this.hasher = hasher;
        this.fileSystem = fileSystem;
        this.stringInterner = stringInterner;
        this.defaultExcludes = new DefaultExcludes(defaultExcludes);
    }

    public FileSystemLocationSnapshot snapshot(String absolutePath, @Nullable PatternSet patterns, final MutableBoolean hasBeenFiltered) {
        Path rootPath = Paths.get(absolutePath, new String[0]);
        final Spec<FileTreeElement> spec = patterns == null || patterns.isEmpty() ? null : patterns.getAsSpec();
        final MerkleDirectorySnapshotBuilder builder = MerkleDirectorySnapshotBuilder.sortingRequired();
        try {
            Files.walkFileTree(rootPath, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    String name = DirectorySnapshotter.this.stringInterner.intern(dir.getFileName().toString());
                    if (builder.isRoot() || this.isAllowed(dir, name, true, attrs, builder.getRelativePath())) {
                        builder.preVisitDirectory(this.internedAbsolutePath(dir), name);
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }

                @Override
                public FileVisitResult visitFile(Path file, @Nullable BasicFileAttributes attrs) {
                    String name = DirectorySnapshotter.this.stringInterner.intern(file.getFileName().toString());
                    if (this.isAllowed(file, name, false, attrs, builder.getRelativePath())) {
                        if (attrs == null) {
                            throw new GradleException(String.format("Cannot read file '%s': not authorized.", file));
                        }
                        if (attrs.isSymbolicLink()) {
                            throw new GradleException(String.format("Could not list contents of '%s'. Couldn't follow symbolic link.", file));
                        }
                        this.addFileSnapshot(file, name, attrs);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    if (this.isNotFileSystemLoopException(exc) && this.isAllowed(file, file.getFileName().toString(), false, null, builder.getRelativePath())) {
                        throw new GradleException(String.format("Could not read path '%s'.", file), exc);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, @Nullable IOException exc) {
                    if (this.isNotFileSystemLoopException(exc)) {
                        throw new GradleException(String.format("Could not read directory path '%s'.", dir), exc);
                    }
                    builder.postVisitDirectory();
                    return FileVisitResult.CONTINUE;
                }

                private boolean isNotFileSystemLoopException(@Nullable IOException e) {
                    return e != null && !(e instanceof FileSystemLoopException);
                }

                private void addFileSnapshot(Path file, String name, BasicFileAttributes attrs) {
                    Preconditions.checkNotNull((Object)attrs, (String)"Unauthorized access to %", (Object)file);
                    DefaultFileMetadata metadata = new DefaultFileMetadata(FileType.RegularFile, attrs.lastModifiedTime().toMillis(), attrs.size());
                    HashCode hash = DirectorySnapshotter.this.hasher.hash(file.toFile(), metadata);
                    RegularFileSnapshot fileSnapshot = new RegularFileSnapshot(this.internedAbsolutePath(file), name, hash, metadata.getLastModified());
                    builder.visit(fileSnapshot);
                }

                private String internedAbsolutePath(Path file) {
                    return DirectorySnapshotter.this.stringInterner.intern(file.toString());
                }

                private boolean isAllowed(Path path, String name, boolean isDirectory, @Nullable BasicFileAttributes attrs, Iterable<String> relativePath) {
                    if (isDirectory ? DirectorySnapshotter.this.defaultExcludes.excludeDir(name) : DirectorySnapshotter.this.defaultExcludes.excludeFile(name)) {
                        return false;
                    }
                    if (spec == null) {
                        return true;
                    }
                    boolean allowed = spec.isSatisfiedBy(new PathBackedFileTreeElement(path, name, isDirectory, attrs, relativePath, DirectorySnapshotter.this.fileSystem));
                    if (!allowed) {
                        hasBeenFiltered.set(true);
                    }
                    return allowed;
                }
            });
        }
        catch (IOException e) {
            throw new GradleException(String.format("Could not list contents of directory '%s'.", rootPath), e);
        }
        return builder.getResult();
    }

    private static class PathBackedFileTreeElement
    implements FileTreeElement {
        private final Path path;
        private final String name;
        private final boolean isDirectory;
        private final BasicFileAttributes attrs;
        private final Iterable<String> relativePath;
        private final Stat stat;

        public PathBackedFileTreeElement(Path path, String name, boolean isDirectory, @Nullable BasicFileAttributes attrs, Iterable<String> relativePath, Stat stat) {
            this.path = path;
            this.name = name;
            this.isDirectory = isDirectory;
            this.attrs = attrs;
            this.relativePath = relativePath;
            this.stat = stat;
        }

        @Override
        public File getFile() {
            return this.path.toFile();
        }

        @Override
        public boolean isDirectory() {
            return this.isDirectory;
        }

        @Override
        public long getLastModified() {
            return this.getAttributes().lastModifiedTime().toMillis();
        }

        @Override
        public long getSize() {
            return this.getAttributes().size();
        }

        private BasicFileAttributes getAttributes() {
            return (BasicFileAttributes)Preconditions.checkNotNull((Object)this.attrs, (String)"Cannot read file attributes of %s", (Object)this.path);
        }

        @Override
        public InputStream open() {
            try {
                return Files.newInputStream(this.path, new OpenOption[0]);
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }

        @Override
        public void copyTo(OutputStream output) {
            throw new UnsupportedOperationException("Copy to not supported for filters");
        }

        @Override
        public boolean copyTo(File target) {
            throw new UnsupportedOperationException("Copy to not supported for filters");
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getPath() {
            return this.getRelativePath().getPathString();
        }

        @Override
        public RelativePath getRelativePath() {
            String[] segments = new String[Iterables.size(this.relativePath) + 1];
            int i = 0;
            Iterator<String> iterator = this.relativePath.iterator();
            while (iterator.hasNext()) {
                String segment;
                segments[i] = segment = iterator.next();
                ++i;
            }
            segments[i] = this.name;
            return new RelativePath(!this.isDirectory, segments);
        }

        @Override
        public int getMode() {
            return this.stat.getUnixMode(this.path.toFile());
        }
    }

    @VisibleForTesting
    static class DefaultExcludes {
        private final ImmutableSet<String> excludeFileNames;
        private final ImmutableSet<String> excludedDirNames;
        private final Predicate<String> excludedFileNameSpec;

        public DefaultExcludes(String[] defaultExcludes) {
            ArrayList excludeFiles = Lists.newArrayList();
            ArrayList excludeDirs = Lists.newArrayList();
            ArrayList excludeFileSpecs = Lists.newArrayList();
            for (String defaultExclude : defaultExcludes) {
                if (defaultExclude.startsWith("**/")) {
                    defaultExclude = defaultExclude.substring(3);
                }
                int length = defaultExclude.length();
                if (defaultExclude.endsWith("/**")) {
                    excludeDirs.add(defaultExclude.substring(0, length - 3));
                    continue;
                }
                int firstStar = defaultExclude.indexOf(42);
                if (firstStar == -1) {
                    excludeFiles.add(defaultExclude);
                    continue;
                }
                Predicate start = firstStar == 0 ? Predicates.alwaysTrue() : new StartMatcher(defaultExclude.substring(0, firstStar));
                Predicate end = firstStar == length - 1 ? Predicates.alwaysTrue() : new EndMatcher(defaultExclude.substring(firstStar + 1, length));
                excludeFileSpecs.add(Predicates.and((Predicate)start, (Predicate)end));
            }
            this.excludeFileNames = ImmutableSet.copyOf((Collection)excludeFiles);
            this.excludedFileNameSpec = Predicates.or((Iterable)excludeFileSpecs);
            this.excludedDirNames = ImmutableSet.copyOf((Collection)excludeDirs);
        }

        public boolean excludeDir(String name) {
            return this.excludedDirNames.contains((Object)name);
        }

        public boolean excludeFile(String name) {
            return this.excludeFileNames.contains((Object)name) || this.excludedFileNameSpec.apply((Object)name);
        }

        private static class StartMatcher
        implements Predicate<String> {
            private final String start;

            public StartMatcher(String start) {
                this.start = start;
            }

            public boolean apply(String element) {
                return element.startsWith(this.start);
            }
        }

        private static class EndMatcher
        implements Predicate<String> {
            private final String end;

            public EndMatcher(String end) {
                this.end = end;
            }

            public boolean apply(String element) {
                return element.endsWith(this.end);
            }
        }
    }
}

