/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Named;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.isolation.IsolationException;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotStrategy;
import org.gradle.internal.snapshot.ValueSnapshottable;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.internal.snapshot.impl.ArrayValueSnapshot;
import org.gradle.internal.snapshot.impl.AttributeDefinitionSnapshot;
import org.gradle.internal.snapshot.impl.BooleanValueSnapshot;
import org.gradle.internal.snapshot.impl.EnumValueSnapshot;
import org.gradle.internal.snapshot.impl.FileValueSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.gradle.internal.snapshot.impl.IntegerValueSnapshot;
import org.gradle.internal.snapshot.impl.IsolatableEnumValueSnapshot;
import org.gradle.internal.snapshot.impl.IsolatableSerializedValueSnapshot;
import org.gradle.internal.snapshot.impl.IsolatableValueSnapshotStrategy;
import org.gradle.internal.snapshot.impl.IsolatedManagedNamedTypeSnapshot;
import org.gradle.internal.snapshot.impl.ListValueSnapshot;
import org.gradle.internal.snapshot.impl.LongValueSnapshot;
import org.gradle.internal.snapshot.impl.ManagedNamedTypeSnapshot;
import org.gradle.internal.snapshot.impl.MapValueSnapshot;
import org.gradle.internal.snapshot.impl.NullValueSnapshot;
import org.gradle.internal.snapshot.impl.ProviderSnapshot;
import org.gradle.internal.snapshot.impl.SerializedValueSnapshot;
import org.gradle.internal.snapshot.impl.SetValueSnapshot;
import org.gradle.internal.snapshot.impl.ShortValueSnapshot;
import org.gradle.internal.snapshot.impl.StringValueSnapshot;

public class DefaultValueSnapshotter
implements ValueSnapshotter {
    private final ClassLoaderHierarchyHasher classLoaderHasher;
    private final NamedObjectInstantiator namedObjectInstantiator;
    private final ValueSnapshotStrategy valueSnapshotStrategy;
    private final IsolatableValueSnapshotStrategy isolatedSnapshotStrategy;

    public DefaultValueSnapshotter(ClassLoaderHierarchyHasher classLoaderHasher, NamedObjectInstantiator namedObjectInstantiator) {
        this.classLoaderHasher = classLoaderHasher;
        this.namedObjectInstantiator = namedObjectInstantiator;
        this.valueSnapshotStrategy = new ValueSnapshotStrategy(this);
        this.isolatedSnapshotStrategy = new IsolatableValueSnapshotStrategy(this);
    }

    @Override
    public ValueSnapshot snapshot(Object value) throws UncheckedIOException {
        return this.processValue(value, this.valueSnapshotStrategy);
    }

    @Override
    public <T> Isolatable<T> isolate(T value) {
        try {
            return (Isolatable)Cast.uncheckedCast(this.isolatableSnapshot(value));
        }
        catch (Throwable t) {
            throw new IsolationException(value, t);
        }
    }

    @Override
    public ValueSnapshot isolatableSnapshot(Object value) throws UncheckedIOException {
        ValueSnapshot possible = this.processValue(value, this.isolatedSnapshotStrategy);
        if (possible instanceof Isolatable) {
            return possible;
        }
        return this.wrap(value, possible);
    }

    private ValueSnapshot processValue(Object value, ValueSnapshotStrategy strategy) {
        if (value == null) {
            return NullValueSnapshot.INSTANCE;
        }
        if (value instanceof String) {
            return new StringValueSnapshot((String)value);
        }
        if (value instanceof Boolean) {
            return value.equals(Boolean.TRUE) ? BooleanValueSnapshot.TRUE : BooleanValueSnapshot.FALSE;
        }
        if (value instanceof List) {
            List list = (List)value;
            if (list.size() == 0) {
                return ListValueSnapshot.EMPTY;
            }
            ValueSnapshot[] elements = new ValueSnapshot[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Object element = list.get(i);
                elements[i] = strategy.snapshot(element);
            }
            return new ListValueSnapshot(elements);
        }
        if (value instanceof Enum) {
            return new EnumValueSnapshot((Enum)value);
        }
        if (value instanceof Class) {
            Class implementation = (Class)value;
            return ImplementationSnapshot.of(implementation, this.classLoaderHasher);
        }
        if (value.getClass().equals(File.class)) {
            return new FileValueSnapshot((File)value);
        }
        if (value instanceof Number) {
            if (value instanceof Integer) {
                return new IntegerValueSnapshot((Integer)value);
            }
            if (value instanceof Long) {
                return new LongValueSnapshot((Long)value);
            }
            if (value instanceof Short) {
                return new ShortValueSnapshot((Short)value);
            }
        }
        if (value instanceof Set) {
            Set set = (Set)value;
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Object element : set) {
                builder.add((Object)strategy.snapshot(element));
            }
            return new SetValueSnapshot((ImmutableSet<ValueSnapshot>)builder.build());
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Map.Entry entry : map.entrySet()) {
                builder.put((Object)strategy.snapshot(entry.getKey()), (Object)strategy.snapshot(entry.getValue()));
            }
            return new MapValueSnapshot((ImmutableMap<ValueSnapshot, ValueSnapshot>)builder.build());
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            if (length == 0) {
                return ArrayValueSnapshot.EMPTY;
            }
            ValueSnapshot[] elements = new ValueSnapshot[length];
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(value, i);
                elements[i] = strategy.snapshot(element);
            }
            return new ArrayValueSnapshot(elements);
        }
        if (value instanceof Attribute) {
            return new AttributeDefinitionSnapshot((Attribute)value, this.classLoaderHasher);
        }
        if (value instanceof Provider) {
            Provider provider = (Provider)value;
            ValueSnapshot valueSnapshot = strategy.snapshot(provider.get());
            return new ProviderSnapshot(valueSnapshot);
        }
        if (value instanceof NamedObjectInstantiator.Managed) {
            return new ManagedNamedTypeSnapshot((Named)value);
        }
        if (value instanceof ValueSnapshottable) {
            return (ValueSnapshot)((ValueSnapshottable)value).snapshot();
        }
        if (value instanceof ValueSnapshot) {
            return (ValueSnapshot)value;
        }
        return this.serialize(value);
    }

    private SerializedValueSnapshot serialize(Object value) {
        ByteArrayOutputStream outputStream;
        try {
            outputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectStr = new ObjectOutputStream(outputStream);
            objectStr.writeObject(value);
            objectStr.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new SerializedValueSnapshot(this.classLoaderHasher.getClassLoaderHash(value.getClass().getClassLoader()), outputStream.toByteArray());
    }

    private ValueSnapshot wrap(Object value, ValueSnapshot possible) {
        if (possible instanceof EnumValueSnapshot) {
            return new IsolatableEnumValueSnapshot((Enum)value);
        }
        if (possible instanceof SerializedValueSnapshot) {
            SerializedValueSnapshot original = (SerializedValueSnapshot)possible;
            return new IsolatableSerializedValueSnapshot(original.getImplementationHash(), original.getValue(), value.getClass());
        }
        if (possible instanceof ManagedNamedTypeSnapshot) {
            return new IsolatedManagedNamedTypeSnapshot((Named)value, this.namedObjectInstantiator);
        }
        throw new IsolationException(value);
    }

    @Override
    public ValueSnapshot snapshot(Object value, ValueSnapshot candidate) {
        return candidate.snapshot(value, this);
    }
}

