/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service.scopes;

import java.util.Collections;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.DefaultExecutionHistoryCacheAccess;
import org.gradle.api.invocation.Gradle;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.caching.internal.command.BuildCacheCommandFactory;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.execution.plan.DefaultPlanExecutor;
import org.gradle.execution.plan.PlanExecutor;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ParallelismConfigurationManager;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.execution.WorkExecutor;
import org.gradle.internal.execution.history.ExecutionHistoryCacheAccess;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.OutputFilesRepository;
import org.gradle.internal.execution.history.impl.DefaultExecutionHistoryStore;
import org.gradle.internal.execution.history.impl.DefaultOutputFilesRepository;
import org.gradle.internal.execution.impl.DefaultWorkExecutor;
import org.gradle.internal.execution.impl.steps.CacheStep;
import org.gradle.internal.execution.impl.steps.CancelExecutionStep;
import org.gradle.internal.execution.impl.steps.CatchExceptionStep;
import org.gradle.internal.execution.impl.steps.Context;
import org.gradle.internal.execution.impl.steps.CreateOutputsStep;
import org.gradle.internal.execution.impl.steps.ExecuteStep;
import org.gradle.internal.execution.impl.steps.PrepareCachingStep;
import org.gradle.internal.execution.impl.steps.SkipUpToDateStep;
import org.gradle.internal.execution.impl.steps.SnapshotOutputStep;
import org.gradle.internal.execution.impl.steps.StoreSnapshotsStep;
import org.gradle.internal.execution.impl.steps.TimeoutStep;
import org.gradle.internal.execution.impl.steps.UpToDateResult;
import org.gradle.internal.execution.timeout.TimeoutHandler;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.util.GradleVersion;

public class ExecutionServices {
    ExecutionHistoryCacheAccess createCacheAccess(Gradle gradle, CacheRepository cacheRepository, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory) {
        return new DefaultExecutionHistoryCacheAccess(gradle, cacheRepository, inMemoryCacheDecoratorFactory);
    }

    ExecutionHistoryStore createExecutionHistoryStore(ExecutionHistoryCacheAccess executionHistoryCacheAccess, StringInterner stringInterner) {
        return new DefaultExecutionHistoryStore(executionHistoryCacheAccess, stringInterner);
    }

    OutputFilesRepository createOutputFilesRepository(CacheRepository cacheRepository, Gradle gradle, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory) {
        PersistentCache cacheAccess = cacheRepository.cache(gradle, "buildOutputCleanup").withCrossVersionCache(CacheBuilder.LockTarget.DefaultTarget).withDisplayName("Build Output Cleanup Cache").withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.None)).withProperties(Collections.singletonMap("gradle.version", GradleVersion.current().getVersion())).open();
        return new DefaultOutputFilesRepository(cacheAccess, inMemoryCacheDecoratorFactory);
    }

    PlanExecutor createPlanExecutor(ParallelismConfigurationManager parallelismConfigurationManager, ExecutorFactory executorFactory, WorkerLeaseService workerLeaseService, BuildCancellationToken cancellationToken, ResourceLockCoordinationService coordinationService) {
        int parallelThreads = parallelismConfigurationManager.getParallelismConfiguration().getMaxWorkerCount();
        if (parallelThreads < 1) {
            throw new IllegalStateException(String.format("Cannot create executor for requested number of worker threads: %s.", parallelThreads));
        }
        return new DefaultPlanExecutor(parallelismConfigurationManager.getParallelismConfiguration(), executorFactory, workerLeaseService, cancellationToken, coordinationService);
    }

    OutputChangeListener createOutputChangeListener(ListenerManager listenerManager) {
        return listenerManager.getBroadcaster(OutputChangeListener.class);
    }

    public WorkExecutor<UpToDateResult> createWorkExecutor(BuildCacheController buildCacheController, BuildCacheCommandFactory buildCacheCommandFactory, BuildInvocationScopeId buildInvocationScopeId, BuildCancellationToken cancellationToken, OutputChangeListener outputChangeListener, OutputFilesRepository outputFilesRepository, TimeoutHandler timeoutHandler) {
        return new DefaultWorkExecutor<UpToDateResult>(new SkipUpToDateStep(new StoreSnapshotsStep(outputFilesRepository, new PrepareCachingStep(new CacheStep(buildCacheController, outputChangeListener, buildCacheCommandFactory, new SnapshotOutputStep(buildInvocationScopeId.getId(), new CreateOutputsStep(new CatchExceptionStep(new TimeoutStep(timeoutHandler, new CancelExecutionStep<Context>(cancellationToken, new ExecuteStep(outputChangeListener)))))))))));
    }
}

