/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize.kryo;

import java.io.Closeable;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.internal.impldep.com.esotericsoftware.kryo.io.Output;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.serialize.AbstractEncoder;
import org.gradle.internal.serialize.FlushableEncoder;

public class StringDeduplicatingKryoBackedEncoder
extends AbstractEncoder
implements FlushableEncoder,
Closeable {
    private IndexedStringSet strings;
    private final Output output;

    public StringDeduplicatingKryoBackedEncoder(OutputStream outputStream) {
        this(outputStream, 4096);
    }

    public StringDeduplicatingKryoBackedEncoder(OutputStream outputStream, int bufferSize) {
        this.output = new Output(outputStream, bufferSize);
    }

    @Override
    public void writeByte(byte value) {
        this.output.writeByte(value);
    }

    @Override
    public void writeBytes(byte[] bytes, int offset, int count) {
        this.output.writeBytes(bytes, offset, count);
    }

    @Override
    public void writeLong(long value) {
        this.output.writeLong(value);
    }

    @Override
    public void writeSmallLong(long value) {
        this.output.writeLong(value, true);
    }

    @Override
    public void writeInt(int value) {
        this.output.writeInt(value);
    }

    @Override
    public void writeSmallInt(int value) {
        this.output.writeInt(value, true);
    }

    @Override
    public void writeBoolean(boolean value) {
        this.output.writeBoolean(value);
    }

    @Override
    public void writeString(CharSequence value) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot encode a null string.");
        }
        this.writeNullableString(value);
    }

    @Override
    public void writeNullableString(@Nullable CharSequence value) {
        if (value == null) {
            this.output.writeByte((byte)0);
            return;
        }
        if (this.strings == null) {
            this.strings = new IndexedStringSet();
        }
        this.output.writeByte((byte)1);
        this.strings.register(value.toString());
    }

    public long getWritePosition() {
        return this.output.total();
    }

    @Override
    public void flush() {
        this.output.flush();
    }

    @Override
    public void close() {
        this.output.close();
    }

    public void done() {
        this.strings = null;
    }

    private static class IndexedString {
        private final String value;
        private final int index;

        private IndexedString(String value, int index) {
            this.value = value;
            this.index = index;
        }

        boolean matches(String value) {
            return value.hashCode() == this.value.hashCode() && value.equals(this.value);
        }

        public String toString() {
            return "Value '" + this.value + "' index " + this.index;
        }
    }

    private static interface StringSetBucket {
        public StringSetBucket register(String var1);
    }

    private class IndexedStringSet {
        private final StringSetBucket[] buckets = new StringSetBucket[256];
        private int count;

        private IndexedStringSet() {
        }

        public void register(String value) {
            int bucketId = value.hashCode() & 0xFF;
            StringSetBucket bucket = this.buckets[bucketId];
            this.buckets[bucketId] = bucket == null ? new SingleEntryStringSet(value) : bucket.register(value);
        }

        private class MultiMapStringSet
        implements StringSetBucket {
            private final Map<String, Integer> map;

            private MultiMapStringSet(List<IndexedString> strings) {
                this.map = Maps.newHashMapWithExpectedSize((int)(strings.size() << 1));
                for (IndexedString indexedString : strings) {
                    this.map.put(indexedString.value, indexedString.index);
                }
            }

            @Override
            public StringSetBucket register(String value) {
                Integer index = this.map.get(value);
                if (index != null) {
                    StringDeduplicatingKryoBackedEncoder.this.output.writeInt(index.intValue(), true);
                    return this;
                }
                StringDeduplicatingKryoBackedEncoder.this.output.writeInt(IndexedStringSet.this.count, true);
                StringDeduplicatingKryoBackedEncoder.this.output.writeString(value);
                IndexedStringSet.this.count++;
                return this;
            }

            public String toString() {
                return this.map.toString();
            }
        }

        private class MultiListStringSet
        implements StringSetBucket {
            private final List<IndexedString> store = Lists.newArrayList();

            public MultiListStringSet(IndexedString initial) {
                this.store.add(initial);
            }

            @Override
            public StringSetBucket register(String value) {
                for (IndexedString indexedString : this.store) {
                    if (!indexedString.matches(value)) continue;
                    StringDeduplicatingKryoBackedEncoder.this.output.writeInt(indexedString.index, true);
                    return this;
                }
                StringDeduplicatingKryoBackedEncoder.this.output.writeInt(IndexedStringSet.this.count, true);
                StringDeduplicatingKryoBackedEncoder.this.output.writeString(value);
                this.store.add(new IndexedString(value, IndexedStringSet.this.count));
                IndexedStringSet.this.count++;
                if (this.store.size() > 4) {
                    return new MultiMapStringSet(this.store);
                }
                return this;
            }

            public String toString() {
                return this.store.toString();
            }
        }

        private class SingleEntryStringSet
        implements StringSetBucket {
            private final IndexedString indexed;

            private SingleEntryStringSet(String value) {
                this.indexed = new IndexedString(value, IndexedStringSet.this.count);
                StringDeduplicatingKryoBackedEncoder.this.output.writeInt(IndexedStringSet.this.count, true);
                StringDeduplicatingKryoBackedEncoder.this.output.writeString(value);
                IndexedStringSet.this.count++;
            }

            @Override
            public StringSetBucket register(String value) {
                if (this.indexed.matches(value)) {
                    StringDeduplicatingKryoBackedEncoder.this.output.writeInt(this.indexed.index, true);
                    return this;
                }
                return new MultiListStringSet(this.indexed).register(value);
            }

            public String toString() {
                return this.indexed.toString();
            }
        }
    }
}

