/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.org.apache.http.client.methods.CloseableHttpResponse;
import org.gradle.internal.impldep.org.apache.http.client.methods.HttpGet;
import org.gradle.internal.impldep.org.apache.http.client.methods.HttpHead;
import org.gradle.internal.impldep.org.apache.http.client.methods.HttpRequestBase;
import org.gradle.internal.impldep.org.apache.http.client.methods.HttpUriRequest;
import org.gradle.internal.impldep.org.apache.http.impl.client.CloseableHttpClient;
import org.gradle.internal.impldep.org.apache.http.impl.client.HttpClientBuilder;
import org.gradle.internal.impldep.org.apache.http.protocol.BasicHttpContext;
import org.gradle.internal.impldep.org.apache.http.protocol.HttpContext;
import org.gradle.internal.resource.transport.http.HttpClientConfigurer;
import org.gradle.internal.resource.transport.http.HttpClientResponse;
import org.gradle.internal.resource.transport.http.HttpErrorStatusCodeException;
import org.gradle.internal.resource.transport.http.HttpRequestException;
import org.gradle.internal.resource.transport.http.HttpSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientHelper
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientHelper.class);
    private CloseableHttpClient client;
    private final HttpSettings settings;
    private final ConcurrentLinkedQueue<HttpContext> sharedContext;

    public HttpClientHelper(HttpSettings settings) {
        this.settings = settings;
        this.sharedContext = !settings.getAuthenticationSettings().isEmpty() ? new ConcurrentLinkedQueue() : null;
    }

    private HttpClientResponse performRawHead(String source, boolean revalidate) {
        return this.performRequest((HttpRequestBase)new HttpHead(source), revalidate);
    }

    public HttpClientResponse performHead(String source, boolean revalidate) {
        return this.processResponse(this.performRawHead(source, revalidate));
    }

    HttpClientResponse performRawGet(String source, boolean revalidate) {
        return this.performRequest((HttpRequestBase)new HttpGet(source), revalidate);
    }

    public HttpClientResponse performGet(String source, boolean revalidate) {
        return this.processResponse(this.performRawGet(source, revalidate));
    }

    public HttpClientResponse performRequest(HttpRequestBase request, boolean revalidate) {
        String method = request.getMethod();
        if (revalidate) {
            request.addHeader("Cache-Control", "max-age=0");
        }
        try {
            return this.executeGetOrHead(request);
        }
        catch (FailureFromRedirectLocation e) {
            throw new HttpRequestException(String.format("Could not %s '%s'.", method, e.getLastRedirectLocation()), e.getCause());
        }
        catch (IOException e) {
            throw new HttpRequestException(String.format("Could not %s '%s'.", method, request.getURI()), e);
        }
    }

    protected HttpClientResponse executeGetOrHead(HttpRequestBase method) throws IOException {
        HttpClientResponse response = this.performHttpRequest(method);
        if (!response.wasSuccessful()) {
            response.close();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClientResponse performHttpRequest(HttpRequestBase request) throws IOException {
        if (this.sharedContext == null) {
            return this.performHttpRequest(request, (HttpContext)new BasicHttpContext());
        }
        HttpContext httpContext = this.nextAvailableSharedContext();
        try {
            HttpClientResponse httpClientResponse = this.performHttpRequest(request, httpContext);
            return httpClientResponse;
        }
        finally {
            this.sharedContext.add(httpContext);
        }
    }

    private HttpContext nextAvailableSharedContext() {
        HttpContext context = this.sharedContext.poll();
        if (context == null) {
            return new BasicHttpContext();
        }
        return context;
    }

    private HttpClientResponse performHttpRequest(HttpRequestBase request, HttpContext httpContext) throws IOException {
        httpContext.removeAttribute("http.protocol.redirect-locations");
        LOGGER.debug("Performing HTTP {}: {}", (Object)request.getMethod(), (Object)request.getURI());
        try {
            CloseableHttpResponse response = this.getClient().execute((HttpUriRequest)request, httpContext);
            return this.toHttpClientResponse(request, httpContext, response);
        }
        catch (IOException e) {
            URI lastRedirectLocation = this.getLastRedirectLocation(httpContext);
            throw lastRedirectLocation == null ? e : new FailureFromRedirectLocation(lastRedirectLocation, e);
        }
    }

    private HttpClientResponse toHttpClientResponse(HttpRequestBase request, HttpContext httpContext, CloseableHttpResponse response) {
        URI lastRedirectLocation = this.getLastRedirectLocation(httpContext);
        URI effectiveUri = lastRedirectLocation == null ? request.getURI() : lastRedirectLocation;
        return new HttpClientResponse(request.getMethod(), effectiveUri, response);
    }

    private URI getLastRedirectLocation(HttpContext httpContext) {
        List redirectLocations = (List)httpContext.getAttribute("http.protocol.redirect-locations");
        return redirectLocations == null || redirectLocations.isEmpty() ? null : (URI)Iterables.getLast((Iterable)redirectLocations);
    }

    private HttpClientResponse processResponse(HttpClientResponse response) {
        if (response.wasMissing()) {
            LOGGER.info("Resource missing. [HTTP {}: {}]", (Object)response.getMethod(), (Object)response.getEffectiveUri());
            return null;
        }
        if (!response.wasSuccessful()) {
            URI effectiveUri = response.getEffectiveUri();
            LOGGER.info("Failed to get resource: {}. [HTTP {}: {})]", new Object[]{response.getMethod(), response.getStatusLine(), effectiveUri});
            throw new HttpErrorStatusCodeException(response.getMethod(), effectiveUri.toString(), response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase());
        }
        return response;
    }

    private synchronized CloseableHttpClient getClient() {
        if (this.client == null) {
            HttpClientBuilder builder = HttpClientBuilder.create();
            new HttpClientConfigurer(this.settings).configure(builder);
            this.client = builder.build();
        }
        return this.client;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.client != null) {
            this.client.close();
            if (this.sharedContext != null) {
                this.sharedContext.clear();
            }
        }
    }

    private static class FailureFromRedirectLocation
    extends IOException {
        private final URI lastRedirectLocation;

        private FailureFromRedirectLocation(URI lastRedirectLocation, Throwable cause) {
            super(cause);
            this.lastRedirectLocation = lastRedirectLocation;
        }

        private URI getLastRedirectLocation() {
            return this.lastRedirectLocation;
        }
    }
}

