/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.impldep.com.google.common.base.Charsets;
import org.gradle.internal.impldep.org.cyberneko.html.parsers.SAXParser;
import org.gradle.internal.resource.UriTextResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ApacheDirectoryListingParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApacheDirectoryListingParser.class);

    public List<String> parse(URI baseURI, InputStream content, String contentType) throws Exception {
        baseURI = this.addTrailingSlashes(baseURI);
        if (contentType == null || !contentType.startsWith("text/html")) {
            throw new ResourceException(baseURI, String.format("Unsupported ContentType %s for directory listing '%s'", contentType, baseURI));
        }
        Charset contentEncoding = UriTextResource.extractCharacterEncoding(contentType, Charsets.UTF_8);
        InputStreamReader htmlText = new InputStreamReader(content, contentEncoding);
        InputSource inputSource = new InputSource(htmlText);
        SAXParser htmlParser = new SAXParser();
        AnchorListerHandler anchorListerHandler = new AnchorListerHandler();
        htmlParser.setContentHandler((ContentHandler)anchorListerHandler);
        htmlParser.parse(inputSource);
        List<String> hrefs = anchorListerHandler.getHrefs();
        List<URI> uris = this.resolveURIs(baseURI, hrefs);
        return this.filterNonDirectChilds(baseURI, uris);
    }

    private URI addTrailingSlashes(URI uri) throws IOException, URISyntaxException {
        if (uri.getPath() == null) {
            uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), "/", uri.getQuery(), uri.getFragment());
        } else if (!uri.getPath().endsWith("/") && !uri.getPath().endsWith(".html")) {
            uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath() + "/", uri.getQuery(), uri.getFragment());
        }
        return uri;
    }

    private List<String> filterNonDirectChilds(URI baseURI, List<URI> inputURIs) throws MalformedURLException {
        int baseURIPort = baseURI.getPort();
        String baseURIHost = baseURI.getHost();
        String baseURIScheme = baseURI.getScheme();
        ArrayList<String> uris = new ArrayList<String>();
        String prefixPath = baseURI.getPath();
        for (URI parsedURI : inputURIs) {
            String childPathPart;
            if (parsedURI.getHost() != null && !parsedURI.getHost().equals(baseURIHost) || parsedURI.getScheme() != null && !parsedURI.getScheme().equals(baseURIScheme) || parsedURI.getPort() != baseURIPort || parsedURI.getPath() != null && !parsedURI.getPath().startsWith(prefixPath) || (childPathPart = parsedURI.getPath().substring(prefixPath.length(), parsedURI.getPath().length())).startsWith("../") || childPathPart.equals("") || childPathPart.split("/").length > 1) continue;
            String path = parsedURI.getPath();
            int pos = path.lastIndexOf(47);
            if (pos < 0) {
                uris.add(path);
                continue;
            }
            if (pos == path.length() - 1) {
                int start = path.lastIndexOf(47, pos - 1);
                if (start < 0) {
                    uris.add(path.substring(0, pos));
                    continue;
                }
                uris.add(path.substring(start + 1, pos));
                continue;
            }
            uris.add(path.substring(pos + 1));
        }
        return uris;
    }

    private List<URI> resolveURIs(URI baseURI, List<String> hrefs) {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (String href : hrefs) {
            try {
                uris.add(baseURI.resolve(href));
            }
            catch (IllegalArgumentException ex) {
                LOGGER.debug("Cannot resolve anchor: {}", (Object)href);
            }
        }
        return uris;
    }

    private class AnchorListerHandler
    extends DefaultHandler {
        List<String> hrefs = new ArrayList<String>();

        private AnchorListerHandler() {
        }

        public List<String> getHrefs() {
            return this.hrefs;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            String href;
            if (qName.equalsIgnoreCase("A") && (href = atts.getValue("href")) != null) {
                this.hrefs.add(href);
            }
        }
    }
}

