/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.local;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.resource.local.FileAccessTimeJournal;
import org.gradle.internal.resource.local.FileAccessTracker;

public class SingleDepthFileAccessTracker
implements FileAccessTracker {
    private final Path baseDir;
    private final int endNameIndex;
    private final int startNameIndex;
    private final FileAccessTimeJournal journal;

    public SingleDepthFileAccessTracker(FileAccessTimeJournal journal, File baseDir, int depth) {
        this.journal = journal;
        Preconditions.checkArgument((depth > 0 ? 1 : 0) != 0, (String)"depth must be > 0: %s", (int)depth);
        this.baseDir = baseDir.toPath().toAbsolutePath();
        this.startNameIndex = this.baseDir.getNameCount();
        this.endNameIndex = this.startNameIndex + depth;
    }

    @Override
    public void markAccessed(File file) {
        this.markAccessed(this.toSubPath(file));
    }

    @Override
    public void markAccessed(Collection<File> files) {
        for (Path path : this.collectSubPaths(files)) {
            this.markAccessed(path);
        }
    }

    private void markAccessed(Path path) {
        if (path != null) {
            this.journal.setLastAccessTime(path.toFile(), System.currentTimeMillis());
        }
    }

    private Set<Path> collectSubPaths(Collection<File> files) {
        HashSet<Path> paths = new HashSet<Path>();
        for (File file : files) {
            paths.add(this.toSubPath(file));
        }
        return paths;
    }

    private Path toSubPath(File file) {
        Path path = file.toPath().toAbsolutePath();
        if (path.getNameCount() >= this.endNameIndex && path.startsWith(this.baseDir)) {
            return this.baseDir.resolve(path.subpath(this.startNameIndex, this.endNameIndex));
        }
        return null;
    }
}

