/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.text;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.logging.text.AbstractStyledTextOutput;
import org.gradle.internal.logging.text.DiagnosticsVisitor;
import org.gradle.internal.logging.text.LinePrefixingStyledTextOutput;
import org.gradle.util.TextUtil;

public class TreeFormatter
implements DiagnosticsVisitor {
    private final StringBuilder buffer = new StringBuilder();
    private final AbstractStyledTextOutput original = new AbstractStyledTextOutput(){

        @Override
        protected void doAppend(String text) {
            TreeFormatter.this.buffer.append(text);
        }
    };
    private Node current = new Node();

    public String toString() {
        return this.buffer.toString();
    }

    @Override
    public TreeFormatter node(String text) {
        if (this.current.state == State.TraverseChildren) {
            this.current = new Node(this.current, text);
        } else {
            this.current.state = State.Done;
            this.current = new Node(this.current.parent, text);
        }
        if (this.current.isTopLevelNode()) {
            if (this.current != this.current.parent.firstChild) {
                this.original.append(TextUtil.getPlatformLineSeparator());
            }
            this.original.append(text);
            this.current.valueWritten = true;
        }
        return this;
    }

    public void node(Class<?> type) {
        this.node(StringUtils.capitalize((String)type.toString()));
    }

    public void append(CharSequence text) {
        if (this.current.state == State.CollectValue) {
            this.current.value.append(text);
            if (this.current.valueWritten) {
                this.original.append(text);
            }
        } else {
            throw new IllegalStateException("Cannot append text to node.");
        }
    }

    public void appendType(Class<?> type) {
        this.append(type.toString());
    }

    public void appendAnnotation(Class<? extends Annotation> type) {
        this.append("@" + type.getSimpleName());
    }

    public void appendMethod(Method method) {
        this.append(method.getDeclaringClass().getSimpleName());
        this.append(".");
        this.append(method.getName());
        this.append("()");
    }

    public void appendValue(@Nullable Object value) {
        if (value == null) {
            this.append("null");
        } else if (value instanceof String) {
            this.append("'");
            this.append(value.toString());
            this.append("'");
        } else {
            this.append(value.toString());
        }
    }

    public void appendValues(Object[] values) {
        this.append("[");
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (i > 0) {
                this.append(", ");
            }
            this.appendValue(value);
        }
        this.append("]");
    }

    @Override
    public TreeFormatter startChildren() {
        if (this.current.state != State.CollectValue) {
            throw new IllegalStateException("Cannot start children again");
        }
        this.current.state = State.TraverseChildren;
        return this;
    }

    @Override
    public TreeFormatter endChildren() {
        if (this.current.parent == null) {
            throw new IllegalStateException("Not visiting any node.");
        }
        if (this.current.state == State.CollectValue) {
            this.current.state = State.Done;
            this.current = this.current.parent;
        }
        if (this.current.state != State.TraverseChildren) {
            throw new IllegalStateException("Cannot end children.");
        }
        if (this.current.isTopLevelNode()) {
            this.writeNode(this.current);
        }
        this.current.state = State.Done;
        this.current = this.current.parent;
        return this;
    }

    private void writeNode(Node node) {
        if (node.prefix == null) {
            node.prefix = node.isTopLevelNode() ? "" : node.parent.prefix + "    ";
        }
        LinePrefixingStyledTextOutput output = new LinePrefixingStyledTextOutput(this.original, node.prefix, false);
        if (!node.valueWritten) {
            output.append(node.parent.prefix);
            output.append("  - ");
            output.append(node.value);
        }
        Separator separator = node.getFirstChildSeparator();
        if (!separator.newLine) {
            output.append(separator.text);
            Node firstChild = node.firstChild;
            output.append(firstChild.value);
            firstChild.valueWritten = true;
            firstChild.prefix = node.prefix;
            this.writeNode(firstChild);
        } else if (node.firstChild != null) {
            this.original.append(separator.text);
            this.writeNode(node.firstChild);
        }
        if (node.nextSibling != null) {
            this.original.append(TextUtil.getPlatformLineSeparator());
            this.writeNode(node.nextSibling);
        }
    }

    private static class Node {
        final Node parent;
        final StringBuilder value;
        Node firstChild;
        Node lastChild;
        Node nextSibling;
        String prefix;
        State state;
        boolean valueWritten;

        private Node() {
            this.parent = null;
            this.value = new StringBuilder();
            this.prefix = "";
            this.state = State.TraverseChildren;
        }

        private Node(Node parent, String value) {
            this.parent = parent;
            this.value = new StringBuilder(value);
            this.state = State.CollectValue;
            if (parent.firstChild == null) {
                parent.firstChild = this;
                parent.lastChild = this;
            } else {
                parent.lastChild.nextSibling = this;
                parent.lastChild = this;
            }
        }

        Separator getFirstChildSeparator() {
            if (this.firstChild == null) {
                return Separator.NewLine;
            }
            if (this.value.length() == 0) {
                return Separator.NewLine;
            }
            char trailing = this.value.charAt(this.value.length() - 1);
            if (trailing == '.') {
                return Separator.NewLine;
            }
            if (this.firstChild.nextSibling == null && this.firstChild.firstChild == null && this.value.length() + this.firstChild.value.length() < 60) {
                if (trailing == ':') {
                    return Separator.Empty;
                }
                return Separator.Colon;
            }
            if (trailing == ':') {
                return Separator.NewLine;
            }
            return Separator.ColonNewLine;
        }

        boolean isTopLevelNode() {
            return this.parent.parent == null;
        }
    }

    private static enum Separator {
        NewLine(true, TextUtil.getPlatformLineSeparator()),
        Empty(false, " "),
        Colon(false, ": "),
        ColonNewLine(true, ":" + TextUtil.getPlatformLineSeparator());

        final boolean newLine;
        final String text;

        private Separator(boolean newLine, String text) {
            this.newLine = newLine;
            this.text = text;
        }
    }

    private static enum State {
        CollectValue,
        TraverseChildren,
        Done;

    }
}

