/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.locking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.StartParameter;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingState;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.locking.DefaultDependencyLockingState;
import org.gradle.internal.locking.DependencyLockingNotationConverter;
import org.gradle.internal.locking.InvalidLockFileException;
import org.gradle.internal.locking.LockEntryFilter;
import org.gradle.internal.locking.LockEntryFilterFactory;
import org.gradle.internal.locking.LockFileReaderWriter;

public class DefaultDependencyLockingProvider
implements DependencyLockingProvider {
    private static final Logger LOGGER = Logging.getLogger(DefaultDependencyLockingProvider.class);
    private static final DocumentationRegistry DOC_REG = new DocumentationRegistry();
    private final DependencyLockingNotationConverter converter = new DependencyLockingNotationConverter();
    private final LockFileReaderWriter lockFileReaderWriter;
    private final boolean writeLocks;
    private final boolean partialUpdate;
    private final LockEntryFilter lockEntryFilter;
    private final DomainObjectContext context;

    public DefaultDependencyLockingProvider(FileResolver fileResolver, StartParameter startParameter, DomainObjectContext context) {
        List<String> lockedDependenciesToUpdate;
        this.context = context;
        this.lockFileReaderWriter = new LockFileReaderWriter(fileResolver, context);
        this.writeLocks = startParameter.isWriteDependencyLocks();
        if (this.writeLocks) {
            LOGGER.debug("Write locks is enabled");
        }
        this.partialUpdate = !(lockedDependenciesToUpdate = startParameter.getLockedDependenciesToUpdate()).isEmpty();
        this.lockEntryFilter = LockEntryFilterFactory.forParameter(lockedDependenciesToUpdate);
    }

    @Override
    public DependencyLockingState loadLockState(String configurationName) {
        List<String> lockedModules;
        if ((!this.writeLocks || this.partialUpdate) && (lockedModules = this.lockFileReaderWriter.readLockFile(configurationName)) != null) {
            HashSet results = Sets.newHashSetWithExpectedSize((int)lockedModules.size());
            for (String module : lockedModules) {
                ModuleComponentIdentifier lockedIdentifier = this.parseLockNotation(configurationName, module);
                if (this.lockEntryFilter.isSatisfiedBy(lockedIdentifier)) continue;
                results.add(lockedIdentifier);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Loaded lock state for configuration '{}', state is: {}", this.context.identityPath(configurationName), lockedModules);
            } else {
                LOGGER.info("Loaded lock state for configuration '{}'", this.context.identityPath(configurationName));
            }
            return new DefaultDependencyLockingState(this.partialUpdate, results);
        }
        return DefaultDependencyLockingState.EMPTY_LOCK_CONSTRAINT;
    }

    private ModuleComponentIdentifier parseLockNotation(String configurationName, String module) {
        ModuleComponentIdentifier lockedIdentifier;
        try {
            lockedIdentifier = this.converter.convertFromLockNotation(module);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLockFileException(this.context.identityPath(configurationName).getPath(), e);
        }
        return lockedIdentifier;
    }

    @Override
    public void persistResolvedDependencies(String configurationName, Set<ModuleComponentIdentifier> resolvedModules, Set<ModuleComponentIdentifier> changingResolvedModules) {
        if (this.writeLocks) {
            List<String> modulesOrdered = this.getModulesOrdered(resolvedModules);
            this.lockFileReaderWriter.writeLockFile(configurationName, modulesOrdered);
            if (!changingResolvedModules.isEmpty()) {
                LOGGER.warn("Dependency lock state for configuration '{}' contains changing modules: {}. This means that dependencies content may still change over time. See {} for details.", new Object[]{this.context.identityPath(configurationName), this.getModulesOrdered(changingResolvedModules), DOC_REG.getDocumentationFor("dependency_locking")});
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Persisted dependency lock state for configuration '{}', state is: {}", this.context.identityPath(configurationName), modulesOrdered);
            } else {
                LOGGER.lifecycle("Persisted dependency lock state for configuration '{}'", this.context.identityPath(configurationName));
            }
        }
    }

    private List<String> getModulesOrdered(Collection<ModuleComponentIdentifier> resolvedComponents) {
        ArrayList modules = Lists.newArrayListWithCapacity((int)resolvedComponents.size());
        for (ModuleComponentIdentifier identifier : resolvedComponents) {
            modules.add(this.converter.convertToLockNotation(identifier));
        }
        Collections.sort(modules);
        return modules;
    }
}

