/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instantiation;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.cache.CacheBuilder;
import org.gradle.internal.impldep.com.google.common.cache.CacheLoader;
import org.gradle.internal.impldep.com.google.common.cache.LoadingCache;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.util.concurrent.UncheckedExecutionException;
import org.gradle.internal.instantiation.AsmBackedClassGenerator;
import org.gradle.internal.instantiation.ClassGenerator;
import org.gradle.internal.instantiation.ConstructorSelector;
import org.gradle.internal.instantiation.DefaultInstantiationScheme;
import org.gradle.internal.instantiation.DependencyInjectingInstantiator;
import org.gradle.internal.instantiation.InjectAnnotationHandler;
import org.gradle.internal.instantiation.InstantiationScheme;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.instantiation.Jsr330ConstructorSelector;
import org.gradle.internal.instantiation.ParamsMatchingConstructorSelector;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;

public class DefaultInstantiatorFactory
implements InstantiatorFactory {
    private final ServiceRegistry noServices = new DefaultServiceRegistry();
    private final ConstructorSelector injectOnlyLenientSelector;
    private final ConstructorSelector decoratedJsr330Selector;
    private final ConstructorSelector decoratedLenientSelector;
    private final Instantiator decoratingLenientInstantiator;
    private final Instantiator decoratingJsr330Instantiator;
    private final Instantiator injectOnlyLenientInstantiator;
    private final CrossBuildInMemoryCacheFactory cacheFactory;
    private final List<InjectAnnotationHandler> annotationHandlers;
    private final DefaultInstantiationScheme injectOnlyScheme;
    private final LoadingCache<Set<Class<? extends Annotation>>, InstantiationScheme> schemes = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Set<Class<? extends Annotation>>, InstantiationScheme>(){

        public InstantiationScheme load(Set<Class<? extends Annotation>> annotations) {
            for (Class<? extends Annotation> annotation : annotations) {
                DefaultInstantiatorFactory.this.assertKnownAnnotation(annotation);
            }
            ClassGenerator classGenerator = AsmBackedClassGenerator.injectOnly(DefaultInstantiatorFactory.this.annotationHandlers, annotations);
            Jsr330ConstructorSelector constructorSelector = new Jsr330ConstructorSelector(classGenerator, DefaultInstantiatorFactory.this.cacheFactory.newClassCache());
            return new DefaultInstantiationScheme(constructorSelector, DefaultInstantiatorFactory.this.noServices);
        }
    });

    public DefaultInstantiatorFactory(CrossBuildInMemoryCacheFactory cacheFactory, List<InjectAnnotationHandler> annotationHandlers) {
        this.cacheFactory = cacheFactory;
        this.annotationHandlers = annotationHandlers;
        ClassGenerator injectOnly = AsmBackedClassGenerator.injectOnly(annotationHandlers, (Collection<Class<? extends Annotation>>)ImmutableSet.of());
        ClassGenerator decorated = AsmBackedClassGenerator.decorateAndInject(annotationHandlers, (Collection<Class<? extends Annotation>>)ImmutableSet.of());
        Jsr330ConstructorSelector injectOnlyJsr330Selector = new Jsr330ConstructorSelector(injectOnly, cacheFactory.newClassCache());
        this.decoratedJsr330Selector = new Jsr330ConstructorSelector(decorated, cacheFactory.newClassCache());
        this.injectOnlyLenientSelector = new ParamsMatchingConstructorSelector(injectOnly, cacheFactory.newClassCache());
        this.decoratedLenientSelector = new ParamsMatchingConstructorSelector(decorated, cacheFactory.newClassCache());
        this.decoratingJsr330Instantiator = new DependencyInjectingInstantiator(this.decoratedJsr330Selector, this.noServices);
        this.decoratingLenientInstantiator = new DependencyInjectingInstantiator(this.decoratedLenientSelector, this.noServices);
        this.injectOnlyLenientInstantiator = new DependencyInjectingInstantiator(this.injectOnlyLenientSelector, this.noServices);
        this.injectOnlyScheme = new DefaultInstantiationScheme(injectOnlyJsr330Selector, this.noServices);
        this.schemes.put((Object)ImmutableSet.of(), (Object)this.injectOnlyScheme);
    }

    @Override
    public Instantiator inject(ServiceLookup services) {
        return this.injectOnlyScheme.withServices(services);
    }

    @Override
    public Instantiator inject() {
        return this.injectOnlyScheme.instantiator();
    }

    @Override
    public InstantiationScheme injectScheme(Collection<Class<? extends Annotation>> injectAnnotations) {
        try {
            return (InstantiationScheme)this.schemes.getUnchecked((Object)ImmutableSet.copyOf(injectAnnotations));
        }
        catch (UncheckedExecutionException e) {
            throw UncheckedException.throwAsUncheckedException(e.getCause());
        }
    }

    @Override
    public Instantiator injectLenient() {
        return this.injectOnlyLenientInstantiator;
    }

    @Override
    public Instantiator injectLenient(ServiceLookup services) {
        return new DependencyInjectingInstantiator(this.injectOnlyLenientSelector, services);
    }

    @Override
    public Instantiator decorateLenient() {
        return this.decoratingLenientInstantiator;
    }

    @Override
    public Instantiator injectAndDecorate() {
        return this.decoratingJsr330Instantiator;
    }

    @Override
    public Instantiator injectAndDecorate(ServiceLookup services) {
        return new DependencyInjectingInstantiator(this.decoratedJsr330Selector, services);
    }

    @Override
    public Instantiator injectAndDecorateLenient(ServiceLookup services) {
        return new DependencyInjectingInstantiator(this.decoratedLenientSelector, services);
    }

    private void assertKnownAnnotation(Class<? extends Annotation> annotation) {
        for (InjectAnnotationHandler annotationHandler : this.annotationHandlers) {
            if (!annotationHandler.getAnnotation().equals(annotation)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Annotation @%s is not a registered injection annotation.", annotation.getSimpleName()));
    }
}

