/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instantiation;

import org.gradle.internal.instantiation.ConstructorSelector;
import org.gradle.internal.instantiation.DependencyInjectingInstantiator;
import org.gradle.internal.instantiation.InstanceFactory;
import org.gradle.internal.instantiation.InstantiationScheme;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;

class DefaultInstantiationScheme
implements InstantiationScheme {
    private final DependencyInjectingInstantiator instantiator;
    private final ConstructorSelector constructorSelector;

    public DefaultInstantiationScheme(ConstructorSelector constructorSelector, ServiceRegistry defaultServices) {
        this.constructorSelector = constructorSelector;
        this.instantiator = new DependencyInjectingInstantiator(constructorSelector, defaultServices);
    }

    @Override
    public <T> InstanceFactory<T> forType(Class<T> type) {
        return this.instantiator.factoryFor(type);
    }

    @Override
    public Instantiator withServices(ServiceLookup services) {
        return new DependencyInjectingInstantiator(this.constructorSelector, services);
    }

    @Override
    public Instantiator instantiator() {
        return this.instantiator;
    }
}

